/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.impl;

import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.DelegatingEcoreEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.oomph.base.impl.ModelElementImpl;
import org.eclipse.oomph.setup.CatalogSelection;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.Project;
import org.eclipse.oomph.setup.ProjectCatalog;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.Stream;
import org.eclipse.oomph.setup.impl.ProductToProductVersionMapEntryImpl;
import org.eclipse.oomph.setup.impl.ProjectToStreamMapEntryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogSelectionImpl
extends ModelElementImpl
implements CatalogSelection {
    protected EList<ProductCatalog> productCatalogs;
    protected EList<ProjectCatalog> projectCatalogs;
    protected EMap<Product, ProductVersion> defaultProductVersions;
    protected EMap<Project, Stream> defaultStreams;
    protected EList<Stream> selectedStreams;

    protected CatalogSelectionImpl() {
    }

    protected EClass eStaticClass() {
        return SetupPackage.Literals.CATALOG_SELECTION;
    }

    @Override
    public EList<ProductCatalog> getProductCatalogs() {
        if (this.productCatalogs == null) {
            this.productCatalogs = new EObjectResolvingEList(ProductCatalog.class, (InternalEObject)this, 1);
        }
        return this.productCatalogs;
    }

    @Override
    public EList<ProjectCatalog> getProjectCatalogs() {
        if (this.projectCatalogs == null) {
            this.projectCatalogs = new EObjectResolvingEList(ProjectCatalog.class, (InternalEObject)this, 2);
        }
        return this.projectCatalogs;
    }

    @Override
    public EMap<Product, ProductVersion> getDefaultProductVersions() {
        if (this.defaultProductVersions == null) {
            this.defaultProductVersions = new EcoreEMap(SetupPackage.Literals.PRODUCT_TO_PRODUCT_VERSION_MAP_ENTRY, ProductToProductVersionMapEntryImpl.class, (InternalEObject)this, 3);
        }
        return this.defaultProductVersions;
    }

    @Override
    public EMap<Project, Stream> getDefaultStreams() {
        if (this.defaultStreams == null) {
            this.defaultStreams = new EcoreEMap(SetupPackage.Literals.PROJECT_TO_STREAM_MAP_ENTRY, ProjectToStreamMapEntryImpl.class, (InternalEObject)this, 4);
        }
        return this.defaultStreams;
    }

    @Override
    public EList<Stream> getSelectedStreams() {
        if (this.selectedStreams == null) {
            this.getDefaultStreams();
            this.selectedStreams = new DelegatingEcoreEList<Stream>((InternalEObject)this){
                private static final long serialVersionUID = 1L;

                protected List<Stream> delegateList() {
                    return null;
                }

                protected List<Stream> delegateBasicList() {
                    return new AbstractSequentialList<Stream>(){

                        @Override
                        public ListIterator<Stream> listIterator(int index) {
                            return this.basicListIterator(index);
                        }

                        @Override
                        public int size() {
                            return this.delegateSize();
                        }
                    };
                }

                protected Iterator<Stream> delegateIterator() {
                    return this.iterator();
                }

                protected ListIterator<Stream> delegateListIterator() {
                    return this.listIterator();
                }

                protected ProjectToStreamMapEntryImpl wrap(Stream stream) {
                    ProjectToStreamMapEntryImpl entry = (ProjectToStreamMapEntryImpl)SetupFactory.eINSTANCE.create(SetupPackage.Literals.PROJECT_TO_STREAM_MAP_ENTRY);
                    entry.setKey(stream.getProject());
                    entry.setValue(stream);
                    entry.setSelection(true);
                    return entry;
                }

                protected void delegateAdd(int index, Stream stream) {
                    ProjectToStreamMapEntryImpl entry = this.getEntry(stream, true);
                    entry.setSelection(true);
                }

                private ProjectToStreamMapEntryImpl getEntry(Stream stream, boolean demandCreate) {
                    int index = CatalogSelectionImpl.this.defaultStreams.indexOfKey((Object)stream.getProject());
                    if (index != -1) {
                        ProjectToStreamMapEntryImpl entry = (ProjectToStreamMapEntryImpl)((Object)CatalogSelectionImpl.this.defaultStreams.get(index));
                        return entry;
                    }
                    if (demandCreate) {
                        ProjectToStreamMapEntryImpl entry = this.wrap(stream);
                        CatalogSelectionImpl.this.defaultStreams.add((Object)entry);
                        return entry;
                    }
                    return null;
                }

                protected void delegateClear() {
                    for (Stream stream : new ArrayList(this)) {
                        ProjectToStreamMapEntryImpl entry = this.getEntry(stream, true);
                        entry.setSelection(false);
                    }
                }

                protected void delegateAdd(Stream stream) {
                    ProjectToStreamMapEntryImpl entry = this.getEntry(stream, true);
                    entry.setSelection(true);
                }

                protected boolean delegateContains(Object object) {
                    Iterator iterator = this.iterator();
                    while (iterator.hasNext()) {
                        Stream stream = (Stream)iterator.next();
                        if (object != stream) continue;
                        return true;
                    }
                    return false;
                }

                protected boolean delegateContainsAll(Collection<?> collection) {
                    for (Object object : collection) {
                        if (this.delegateContains(object)) continue;
                        return false;
                    }
                    return true;
                }

                protected boolean delegateEquals(Object object) {
                    List list;
                    if (object instanceof List && (list = (List)object).size() == this.delegateSize()) {
                        Iterator i = list.iterator();
                        Iterator j = this.iterator();
                        while (i.hasNext()) {
                            if (i.next() == j.next()) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }

                protected Stream delegateGet(int index) {
                    int count = 0;
                    for (Map.Entry entry : CatalogSelectionImpl.this.defaultStreams) {
                        ProjectToStreamMapEntryImpl projectToStreamMapEntry = (ProjectToStreamMapEntryImpl)((Object)entry);
                        if (!projectToStreamMapEntry.isSelection() || count++ != index) continue;
                        return projectToStreamMapEntry.getValue();
                    }
                    throw new IndexOutOfBoundsException("size=" + this.size() + " index=" + index);
                }

                protected int delegateHashCode() {
                    int hashCode = 1;
                    Iterator iterator = this.iterator();
                    while (iterator.hasNext()) {
                        Stream stream = (Stream)iterator.next();
                        hashCode = 31 * hashCode + (stream == null ? 0 : stream.hashCode());
                    }
                    return hashCode;
                }

                protected int delegateIndexOf(Object object) {
                    int index = 0;
                    Iterator iterator = this.iterator();
                    while (iterator.hasNext()) {
                        Stream stream = (Stream)iterator.next();
                        if (object == stream) {
                            return index;
                        }
                        ++index;
                    }
                    return -1;
                }

                protected boolean delegateIsEmpty() {
                    return !this.iterator().hasNext();
                }

                protected int delegateLastIndexOf(Object object) {
                    return this.delegateIndexOf(object);
                }

                protected Stream delegateRemove(int index) {
                    Stream stream = (Stream)this.get(index);
                    ProjectToStreamMapEntryImpl entry = this.getEntry(stream, false);
                    entry.setSelection(false);
                    return stream;
                }

                protected Stream delegateSet(int index, Stream stream) {
                    throw new UnsupportedOperationException();
                }

                protected int delegateSize() {
                    int size = 0;
                    for (Map.Entry entry : CatalogSelectionImpl.this.defaultStreams) {
                        ProjectToStreamMapEntryImpl projectToStreamMapEntry = (ProjectToStreamMapEntryImpl)((Object)entry);
                        if (!projectToStreamMapEntry.isSelection()) continue;
                        ++size;
                    }
                    return size;
                }

                protected Object[] delegateToArray() {
                    int size = this.delegateSize();
                    Object[] result = new Object[size];
                    int index = 0;
                    Iterator iterator = this.iterator();
                    while (iterator.hasNext()) {
                        Stream stream = (Stream)iterator.next();
                        result[index++] = stream;
                    }
                    return result;
                }

                protected <T> T[] delegateToArray(T[] array) {
                    int size = this.delegateSize();
                    if (array.length < size) {
                        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
                        array = newArray;
                    }
                    if (array.length > size) {
                        array[size] = null;
                    }
                    int index = 0;
                    Iterator iterator = this.iterator();
                    while (iterator.hasNext()) {
                        Stream stream;
                        Stream rawType = stream = (Stream)iterator.next();
                        array[index++] = rawType;
                    }
                    return array;
                }

                protected String delegateToString() {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("[");
                    boolean first = true;
                    Iterator iterator = this.iterator();
                    while (iterator.hasNext()) {
                        Stream stream = (Stream)iterator.next();
                        if (!first) {
                            stringBuffer.append(", ");
                        } else {
                            first = false;
                        }
                        stringBuffer.append(String.valueOf(stream));
                    }
                    stringBuffer.append("]");
                    return stringBuffer.toString();
                }

                protected boolean isInstance(Object object) {
                    return object instanceof Stream;
                }

                public int getFeatureID() {
                    return 10;
                }

                protected boolean useEquals() {
                    return false;
                }

                protected boolean canContainNull() {
                    return false;
                }

                protected boolean isUnique() {
                    return true;
                }

                protected boolean hasInverse() {
                    return false;
                }

                protected boolean hasManyInverse() {
                    return false;
                }

                protected boolean hasNavigableInverse() {
                    return false;
                }

                protected boolean isEObject() {
                    return true;
                }

                protected boolean isContainment() {
                    return false;
                }

                protected boolean hasProxies() {
                    return false;
                }

                protected boolean hasInstanceClass() {
                    return true;
                }

                public boolean isSet() {
                    return !this.isEmpty();
                }

                protected NotificationImpl createNotification(int eventType, Object oldObject, Object newObject, int index, boolean wasSet) {
                    return null;
                }

                protected void dispatchNotification(Notification notification) {
                }
            };
        }
        return this.selectedStreams;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return ((InternalEList)this.getDefaultProductVersions()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getDefaultStreams()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getProductCatalogs();
            }
            case 2: {
                return this.getProjectCatalogs();
            }
            case 3: {
                if (coreType) {
                    return this.getDefaultProductVersions();
                }
                return this.getDefaultProductVersions().map();
            }
            case 4: {
                if (coreType) {
                    return this.getDefaultStreams();
                }
                return this.getDefaultStreams().map();
            }
            case 5: {
                return this.getSelectedStreams();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getProductCatalogs().clear();
                this.getProductCatalogs().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getProjectCatalogs().clear();
                this.getProjectCatalogs().addAll((Collection)newValue);
                return;
            }
            case 3: {
                ((EStructuralFeature.Setting)this.getDefaultProductVersions()).set(newValue);
                return;
            }
            case 4: {
                ((EStructuralFeature.Setting)this.getDefaultStreams()).set(newValue);
                return;
            }
            case 5: {
                this.getSelectedStreams().clear();
                this.getSelectedStreams().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getProductCatalogs().clear();
                return;
            }
            case 2: {
                this.getProjectCatalogs().clear();
                return;
            }
            case 3: {
                this.getDefaultProductVersions().clear();
                return;
            }
            case 4: {
                this.getDefaultStreams().clear();
                return;
            }
            case 5: {
                this.getSelectedStreams().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.productCatalogs != null && !this.productCatalogs.isEmpty();
            }
            case 2: {
                return this.projectCatalogs != null && !this.projectCatalogs.isEmpty();
            }
            case 3: {
                return this.defaultProductVersions != null && !this.defaultProductVersions.isEmpty();
            }
            case 4: {
                return this.defaultStreams != null && !this.defaultStreams.isEmpty();
            }
            case 5: {
                return !this.getSelectedStreams().isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }
}

