/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.SwtCallable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.DefaultExceptionHandler;
import org.eclipse.swt.internal.ExceptionStash;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.ICustomDestinationList;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.HIGHCONTRAST;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.INPUT;
import org.eclipse.swt.internal.win32.KEYBDINPUT;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.MONITORINFO;
import org.eclipse.swt.internal.win32.MOUSEINPUT;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICS;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.STARTUPINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.TouchSource;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device
implements Executor {
    public MSG msg = new MSG();
    static String APP_NAME = "SWT";
    static String APP_VERSION = "";
    String appLocalDir;
    Event[] eventQueue;
    Callback windowCallback;
    long windowProc;
    int threadId;
    TCHAR windowClass;
    TCHAR windowShadowClass;
    TCHAR windowOwnDCClass;
    static int WindowClassCount;
    static final String WindowName = "SWT_Window";
    static final String WindowShadowName = "SWT_WindowShadow";
    static final String WindowOwnDCName = "SWT_WindowOwnDC";
    EventTable eventTable;
    EventTable filterTable;
    boolean useOwnDC;
    boolean externalEventLoop;
    private Map<Long, Control> controlByHandle;
    static final int GROW_SIZE = 1024;
    static STARTUPINFO lpStartupInfo;
    long hButtonTheme;
    long hButtonThemeDark;
    long hEditTheme;
    long hExplorerBarTheme;
    long hScrollBarTheme;
    long hTabTheme;
    static final char[] EXPLORER;
    static final char[] TREEVIEW;
    static final boolean disableCustomThemeTweaks;
    static final String USE_DARKMODE_EXPLORER_THEME_KEY = "org.eclipse.swt.internal.win32.useDarkModeExplorerTheme";
    boolean useDarkModeExplorerTheme;
    static final String USE_SHELL_TITLE_COLORING = "org.eclipse.swt.internal.win32.useShellTitleColoring";
    boolean useShellTitleColoring;
    static final String MENUBAR_FOREGROUND_COLOR_KEY = "org.eclipse.swt.internal.win32.menuBarForegroundColor";
    int menuBarForegroundPixel = -1;
    static final String MENUBAR_BACKGROUND_COLOR_KEY = "org.eclipse.swt.internal.win32.menuBarBackgroundColor";
    int menuBarBackgroundPixel = -1;
    static final String MENUBAR_BORDER_COLOR_KEY = "org.eclipse.swt.internal.win32.menuBarBorderColor";
    long menuBarBorderPen;
    static final String USE_WS_BORDER_ALL_KEY = "org.eclipse.swt.internal.win32.all.use_WS_BORDER";
    boolean useWsBorderAll = false;
    static final String USE_WS_BORDER_CANVAS_KEY = "org.eclipse.swt.internal.win32.Canvas.use_WS_BORDER";
    boolean useWsBorderCanvas = false;
    static final String USE_WS_BORDER_LABEL_KEY = "org.eclipse.swt.internal.win32.Label.use_WS_BORDER";
    boolean useWsBorderLabel = false;
    static final String USE_WS_BORDER_LIST_KEY = "org.eclipse.swt.internal.win32.List.use_WS_BORDER";
    boolean useWsBorderList = false;
    static final String USE_WS_BORDER_TABLE_KEY = "org.eclipse.swt.internal.win32.Table.use_WS_BORDER";
    boolean useWsBorderTable = false;
    static final String USE_WS_BORDER_TEXT_KEY = "org.eclipse.swt.internal.win32.Text.use_WS_BORDER";
    boolean useWsBorderText = false;
    static final String TABLE_HEADER_LINE_COLOR_KEY = "org.eclipse.swt.internal.win32.Table.headerLineColor";
    int tableHeaderLinePixel = -1;
    static final String LABEL_DISABLED_FOREGROUND_COLOR_KEY = "org.eclipse.swt.internal.win32.Label.disabledForegroundColor";
    int disabledLabelForegroundPixel = -1;
    static final String COMBO_USE_DARK_THEME = "org.eclipse.swt.internal.win32.Combo.useDarkTheme";
    boolean comboUseDarkTheme = false;
    static final String PROGRESSBAR_USE_COLORS = "org.eclipse.swt.internal.win32.ProgressBar.useColors";
    boolean progressbarUseColors = false;
    static final String USE_DARKTHEME_TEXT_ICONS = "org.eclipse.swt.internal.win32.Text.useDarkThemeIcons";
    boolean textUseDarkthemeIcons = false;
    long hIconSearch;
    long hIconCancel;
    int focusEvent;
    Control focusControl;
    Menu[] bars;
    Menu[] popups;
    MenuItem[] items;
    static final int ID_START = 108;
    Callback msgFilterCallback;
    long msgFilterProc;
    long filterHook;
    MSG hookMsg = new MSG();
    boolean runDragDrop = true;
    boolean dragCancelled = false;
    Callback foregroundIdleCallback;
    long foregroundIdleProc;
    long idleHook;
    boolean ignoreNextKey;
    Callback getMsgCallback;
    Callback embeddedCallback;
    long getMsgProc;
    long msgHook;
    long embeddedHwnd;
    long embeddedProc;
    static final String AWT_WINDOW_CLASS = "SunAwtWindow";
    static final short[] ACCENTS;
    Synchronizer synchronizer;
    Consumer<RuntimeException> runtimeExceptionHandler = DefaultExceptionHandler.RUNTIME_EXCEPTION_HANDLER;
    Consumer<Error> errorHandler = DefaultExceptionHandler.RUNTIME_ERROR_HANDLER;
    boolean runMessagesInIdle = false;
    boolean runMessagesInMessageProc = true;
    static final String RUN_MESSAGES_IN_IDLE_KEY = "org.eclipse.swt.internal.win32.runMessagesInIdle";
    static final String RUN_MESSAGES_IN_MESSAGE_PROC_KEY = "org.eclipse.swt.internal.win32.runMessagesInMessageProc";
    static final String USE_OWNDC_KEY = "org.eclipse.swt.internal.win32.useOwnDC";
    static final String ACCEL_KEY_HIT = "org.eclipse.swt.internal.win32.accelKeyHit";
    static final String EXTERNAL_EVENT_LOOP_KEY = "org.eclipse.swt.internal.win32.externalEventLoop";
    static final String APPLOCAL_DIR_KEY = "org.eclipse.swt.internal.win32.appLocalDir";
    Thread thread;
    Runnable[] disposeList;
    Composite[] layoutDeferred;
    int layoutDeferredCount;
    Tray tray;
    int nextTrayId;
    TaskBar taskBar;
    static final String TASKBAR_EVENT = "/SWTINTERNAL_ID";
    static final String LAUNCHER_PREFIX = "--launcher.openFile ";
    long[] timerIds;
    Runnable[] timerList;
    long nextTimerId = 101L;
    static final long SETTINGS_ID = 100L;
    static final int SETTINGS_DELAY = 2000;
    RECT clickRect;
    int clickCount;
    int lastTime;
    int lastButton;
    long lastClickHwnd;
    Point scrollRemainderEvt = new Point(0, 0);
    Point scrollRemainderBar = new Point(0, 0);
    int lastKey;
    int lastMouse;
    int lastAscii;
    boolean lastVirtual;
    boolean lastDead;
    byte[] keyboard = new byte[256];
    boolean accelKeyHit;
    boolean mnemonicKeyHit;
    boolean lockActiveWindow;
    boolean captureChanged;
    boolean xMouse;
    double magStartDistance;
    double lastDistance;
    double rotationAngle;
    int lastX;
    int lastY;
    TouchSource[] touchSources;
    int nextToolTipId;
    boolean ignoreRestoreFocus;
    Control lastHittestControl;
    int lastHittest;
    Callback messageCallback;
    long hwndMessage;
    long messageProc;
    LOGFONT lfSystemFont;
    Font systemFont;
    Image errorImage;
    Image infoImage;
    Image questionImage;
    Image warningIcon;
    Cursor[] cursors = new Cursor[22];
    Resource[] resources;
    static final int RESOURCE_SIZE = 27;
    ImageList[] imageList;
    ImageList[] toolImageList;
    ImageList[] toolHotImageList;
    ImageList[] toolDisabledImageList;
    long lpCustColors;
    char[] tableBuffer;
    int resizeCount;
    static final int RESIZE_LIMIT = 4;
    Object data;
    String[] keys;
    Object[] values;
    static final int[][] KeyTable;
    static Display Default;
    static Display[] Displays;
    Monitor[] monitors = null;
    int monitorCount = 0;
    Shell[] modalShells;
    Dialog modalDialog;
    static boolean TrimEnabled;
    static final int SWT_GETACCELCOUNT = 32768;
    static final int SWT_GETACCEL = 32769;
    static final int SWT_KEYMSG = 32770;
    static final int SWT_DESTROY = 32771;
    static final int SWT_TRAYICONMSG = 32772;
    static final int SWT_NULL = 32773;
    static final int SWT_RUNASYNC = 32774;
    static int TASKBARCREATED;
    static int TASKBARBUTTONCREATED;
    static int SWT_RESTORECARET;
    static int DI_GETDRAGIMAGE;
    static int SWT_OPENDOC;
    Widget[] skinList = new Widget[1024];
    int skinCount;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";

    static {
        lpStartupInfo = new STARTUPINFO();
        Display.lpStartupInfo.cb = STARTUPINFO.sizeof;
        OS.GetStartupInfo(lpStartupInfo);
        char[] cArray = new char[9];
        cArray[0] = 69;
        cArray[1] = 88;
        cArray[2] = 80;
        cArray[3] = 76;
        cArray[4] = 79;
        cArray[5] = 82;
        cArray[6] = 69;
        cArray[7] = 82;
        EXPLORER = cArray;
        char[] cArray2 = new char[9];
        cArray2[0] = 84;
        cArray2[1] = 82;
        cArray2[2] = 69;
        cArray2[3] = 69;
        cArray2[4] = 86;
        cArray2[5] = 73;
        cArray2[6] = 69;
        cArray2[7] = 87;
        TREEVIEW = cArray2;
        disableCustomThemeTweaks = Boolean.valueOf(System.getProperty("org.eclipse.swt.internal.win32.disableCustomThemeTweaks"));
        ACCENTS = new short[]{126, 96, 39, 94, 34};
        KeyTable = new int[][]{{18, 65536}, {16, 131072}, {17, 262144}, {38, 0x1000001}, {40, 0x1000002}, {37, 0x1000003}, {39, 0x1000004}, {33, 0x1000005}, {34, 0x1000006}, {36, 0x1000007}, {35, 0x1000008}, {45, 0x1000009}, {8, 8}, {13, 13}, {46, 127}, {27, 27}, {13, 10}, {9, 9}, {112, 0x100000A}, {113, 0x100000B}, {114, 0x100000C}, {115, 0x100000D}, {116, 0x100000E}, {117, 0x100000F}, {118, 0x1000010}, {119, 0x1000011}, {120, 0x1000012}, {121, 0x1000013}, {122, 0x1000014}, {123, 0x1000015}, {124, 0x1000016}, {125, 0x1000017}, {126, 0x1000018}, {127, 0x1000019}, {128, 0x100001A}, {129, 0x100001B}, {130, 0x100001C}, {131, 0x100001D}, {106, 16777258}, {107, 16777259}, {13, 0x1000050}, {109, 16777261}, {110, 16777262}, {111, 16777263}, {96, 0x1000030}, {97, 0x1000031}, {98, 16777266}, {99, 0x1000033}, {100, 16777268}, {101, 16777269}, {102, 16777270}, {103, 16777271}, {104, 16777272}, {105, 16777273}, {20, 16777298}, {144, 16777299}, {145, 16777300}, {19, 0x1000055}, {3, 16777302}, {44, 16777303}};
        Displays = new Display[1];
        TrimEnabled = false;
        DeviceFinder = () -> {
            Display device = Display.getCurrent();
            if (device == null) {
                device = Display.getDefault();
            }
            Display.setDevice(device);
        };
    }

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData data) {
        super(data);
    }

    Control _getFocusControl() {
        return this.findControl(OS.GetFocus());
    }

    void addBar(Menu menu) {
        if (this.bars == null) {
            this.bars = new Menu[4];
        }
        int length = this.bars.length;
        int i = 0;
        while (i < length) {
            if (this.bars[i] == menu) {
                return;
            }
            ++i;
        }
        int index = 0;
        while (index < length) {
            if (this.bars[index] == null) break;
            ++index;
        }
        if (index == length) {
            Menu[] newBars = new Menu[length + 4];
            System.arraycopy(this.bars, 0, newBars, 0, length);
            this.bars = newBars;
        }
        this.bars[index] = menu;
    }

    void addControl(long handle, Control control) {
        if (handle == 0L) {
            return;
        }
        this.controlByHandle.put(handle, control);
    }

    void addSkinnableWidget(Widget widget) {
        if (this.skinCount >= this.skinList.length) {
            Widget[] newSkinWidgets = new Widget[(this.skinList.length + 1) * 3 / 2];
            System.arraycopy(this.skinList, 0, newSkinWidgets, 0, this.skinList.length);
            this.skinList = newSkinWidgets;
        }
        this.skinList[this.skinCount++] = widget;
    }

    public void addFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(eventType, listener);
    }

    void addLayoutDeferred(Composite comp) {
        if (this.layoutDeferred == null) {
            this.layoutDeferred = new Composite[64];
        }
        if (this.layoutDeferredCount == this.layoutDeferred.length) {
            Composite[] temp = new Composite[this.layoutDeferred.length + 64];
            System.arraycopy(this.layoutDeferred, 0, temp, 0, this.layoutDeferred.length);
            this.layoutDeferred = temp;
        }
        this.layoutDeferred[this.layoutDeferredCount++] = comp;
    }

    public void addListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    void addMenuItem(MenuItem item) {
        if (this.items == null) {
            this.items = new MenuItem[64];
        }
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] == null) {
                item.id = i + 108;
                this.items[i] = item;
                return;
            }
            ++i;
        }
        item.id = this.items.length + 108;
        MenuItem[] newItems = new MenuItem[this.items.length + 64];
        newItems[this.items.length] = item;
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        this.items = newItems;
    }

    void addPopup(Menu menu) {
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int length = this.popups.length;
        int i = 0;
        while (i < length) {
            if (this.popups[i] == menu) {
                return;
            }
            ++i;
        }
        int index = 0;
        while (index < length) {
            if (this.popups[index] == null) break;
            ++index;
        }
        if (index == length) {
            Menu[] newPopups = new Menu[length + 4];
            System.arraycopy(this.popups, 0, newPopups, 0, length);
            this.popups = newPopups;
        }
        this.popups[index] = menu;
    }

    int asciiKey(int key) {
        int i = 0;
        while (i < this.keyboard.length) {
            this.keyboard[i] = 0;
            ++i;
        }
        if (!OS.GetKeyboardState(this.keyboard)) {
            return 0;
        }
        char[] buffer = new char[1];
        int len = OS.ToUnicode(key, key, this.keyboard, buffer, 1, 0);
        while (len == -1) {
            len = OS.ToUnicode(key, key, this.keyboard, buffer, 1, 0);
        }
        return len != 0 ? buffer[0] : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            this.synchronizer.asyncExec(runnable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void execute(Runnable runnable) {
        Objects.requireNonNull(runnable);
        if (this.isDisposed()) {
            throw new RejectedExecutionException(new SWTException(24, null));
        }
        if (this.thread == Thread.currentThread()) {
            this.syncExec(runnable);
        } else {
            this.asyncExec(runnable);
        }
    }

    public void beep() {
        this.checkDevice();
        OS.MessageBeep(0);
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    @Override
    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkDisplay(Thread thread, boolean multiple) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            Display[] displayArray = Displays;
            int n = Displays.length;
            int n2 = 0;
            while (n2 < n) {
                Display display = displayArray[n2];
                if (display != null) {
                    if (!multiple) {
                        SWT.error(20, null, " [multiple displays]");
                    }
                    if (display.thread == thread) {
                        SWT.error(22);
                    }
                }
                ++n2;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void clearModal(Shell shell) {
        if (this.modalShells == null) {
            return;
        }
        int index = 0;
        int length = this.modalShells.length;
        while (index < length) {
            if (this.modalShells[index] == shell) break;
            if (this.modalShells[index] == null) {
                return;
            }
            ++index;
        }
        if (index == length) {
            return;
        }
        System.arraycopy(this.modalShells, index + 1, this.modalShells, index, --length - index);
        this.modalShells[length] = null;
        if (index == 0 && this.modalShells[0] == null) {
            this.modalShells = null;
        }
        Shell[] shellArray = this.getShells();
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell activeShell = shellArray[n2];
            activeShell.updateModal();
            ++n2;
        }
    }

    int controlKey(int key) {
        int upper = (int)OS.CharUpper(OS.LOWORD(key));
        if (64 <= upper && upper <= 95) {
            return upper & 0xBF;
        }
        return key;
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    @Override
    protected void create(DeviceData data) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread, true);
        this.createDisplay(data);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData data) {
    }

    static long create32bitDIB(Image image) {
        int transparentPixel = -1;
        int alpha = -1;
        long hMask = 0L;
        long hBitmap = 0L;
        byte[] alphaData = null;
        switch (image.type) {
            case 1: {
                ICONINFO info = new ICONINFO();
                OS.GetIconInfo(image.handle, info);
                hBitmap = info.hbmColor;
                hMask = info.hbmMask;
                break;
            }
            case 0: {
                ImageData data = image.getImageData(DPIUtil.getDeviceZoom());
                hBitmap = image.handle;
                alpha = data.alpha;
                alphaData = data.alphaData;
                transparentPixel = data.transparentPixel;
            }
        }
        BITMAP bm = new BITMAP();
        OS.GetObject(hBitmap, BITMAP.sizeof, bm);
        int imgWidth = bm.bmWidth;
        int imgHeight = bm.bmHeight;
        long hDC = OS.GetDC(0L);
        long srcHdc = OS.CreateCompatibleDC(hDC);
        long oldSrcBitmap = OS.SelectObject(srcHdc, hBitmap);
        long memHdc = OS.CreateCompatibleDC(hDC);
        BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
        bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
        bmiHeader.biWidth = imgWidth;
        bmiHeader.biHeight = -imgHeight;
        bmiHeader.biPlanes = 1;
        bmiHeader.biBitCount = (short)32;
        bmiHeader.biCompression = 0;
        byte[] bmi = new byte[BITMAPINFOHEADER.sizeof];
        OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
        long[] pBits = new long[1];
        long memDib = OS.CreateDIBSection(0L, bmi, 0, pBits, 0L, 0);
        if (memDib == 0L) {
            SWT.error(2);
        }
        long oldMemBitmap = OS.SelectObject(memHdc, memDib);
        BITMAP dibBM = new BITMAP();
        OS.GetObject(memDib, BITMAP.sizeof, dibBM);
        int sizeInBytes = dibBM.bmWidthBytes * dibBM.bmHeight;
        OS.BitBlt(memHdc, 0, 0, imgWidth, imgHeight, srcHdc, 0, 0, 0xCC0020);
        byte red = 0;
        byte green = 0;
        byte blue = 0;
        if (transparentPixel != -1) {
            if (bm.bmBitsPixel <= 8) {
                byte[] color = new byte[4];
                OS.GetDIBColorTable(srcHdc, transparentPixel, 1, color);
                blue = color[0];
                green = color[1];
                red = color[2];
            } else {
                switch (bm.bmBitsPixel) {
                    case 16: {
                        blue = (byte)((transparentPixel & 0x1F) << 3);
                        green = (byte)((transparentPixel & 0x3E0) >> 2);
                        red = (byte)((transparentPixel & 0x7C00) >> 7);
                        break;
                    }
                    case 24: {
                        blue = (byte)((transparentPixel & 0xFF0000) >> 16);
                        green = (byte)((transparentPixel & 0xFF00) >> 8);
                        red = (byte)(transparentPixel & 0xFF);
                        break;
                    }
                    case 32: {
                        blue = (byte)((transparentPixel & 0xFF000000) >>> 24);
                        green = (byte)((transparentPixel & 0xFF0000) >> 16);
                        red = (byte)((transparentPixel & 0xFF00) >> 8);
                    }
                }
            }
        }
        byte[] srcData = new byte[sizeInBytes];
        OS.MoveMemory(srcData, pBits[0], sizeInBytes);
        if (hMask != 0L) {
            OS.SelectObject(srcHdc, hMask);
            int y = 0;
            int dp = 0;
            while (y < imgHeight) {
                int x = 0;
                while (x < imgWidth) {
                    if (OS.GetPixel(srcHdc, x, y) != 0) {
                        srcData[dp + 3] = 0;
                        srcData[dp + 2] = 0;
                        srcData[dp + 1] = 0;
                        srcData[dp + 0] = 0;
                    } else {
                        srcData[dp + 3] = -1;
                    }
                    dp += 4;
                    ++x;
                }
                ++y;
            }
        } else if (transparentPixel != -1) {
            int y = 0;
            int dp = 0;
            while (y < imgHeight) {
                int x = 0;
                while (x < imgWidth) {
                    if (srcData[dp] == blue && srcData[dp + 1] == green && srcData[dp + 2] == red) {
                        srcData[dp + 3] = 0;
                        srcData[dp + 2] = 0;
                        srcData[dp + 1] = 0;
                        srcData[dp + 0] = 0;
                    } else {
                        srcData[dp + 3] = -1;
                    }
                    dp += 4;
                    ++x;
                }
                ++y;
            }
        } else if (alpha == -1 && alphaData == null) {
            int y = 0;
            int dp = 0;
            while (y < imgHeight) {
                int x = 0;
                while (x < imgWidth) {
                    srcData[dp + 3] = -1;
                    dp += 4;
                    ++x;
                }
                ++y;
            }
        }
        OS.MoveMemory(pBits[0], srcData, sizeInBytes);
        OS.SelectObject(srcHdc, oldSrcBitmap);
        OS.SelectObject(memHdc, oldMemBitmap);
        OS.DeleteObject(srcHdc);
        OS.DeleteObject(memHdc);
        OS.ReleaseDC(0L, hDC);
        if (hBitmap != image.handle && hBitmap != 0L) {
            OS.DeleteObject(hBitmap);
        }
        if (hMask != 0L) {
            OS.DeleteObject(hMask);
        }
        return memDib;
    }

    static long create32bitDIB(long hBitmap, int alpha, byte[] alphaData, int transparentPixel) {
        BITMAP bm = new BITMAP();
        OS.GetObject(hBitmap, BITMAP.sizeof, bm);
        int imgWidth = bm.bmWidth;
        int imgHeight = bm.bmHeight;
        long hDC = OS.GetDC(0L);
        long srcHdc = OS.CreateCompatibleDC(hDC);
        long oldSrcBitmap = OS.SelectObject(srcHdc, hBitmap);
        long memHdc = OS.CreateCompatibleDC(hDC);
        BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
        bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
        bmiHeader.biWidth = imgWidth;
        bmiHeader.biHeight = -imgHeight;
        bmiHeader.biPlanes = 1;
        bmiHeader.biBitCount = (short)32;
        bmiHeader.biCompression = 0;
        byte[] bmi = new byte[BITMAPINFOHEADER.sizeof];
        OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
        long[] pBits = new long[1];
        long memDib = OS.CreateDIBSection(0L, bmi, 0, pBits, 0L, 0);
        if (memDib == 0L) {
            SWT.error(2);
        }
        long oldMemBitmap = OS.SelectObject(memHdc, memDib);
        BITMAP dibBM = new BITMAP();
        OS.GetObject(memDib, BITMAP.sizeof, dibBM);
        int sizeInBytes = dibBM.bmWidthBytes * dibBM.bmHeight;
        OS.BitBlt(memHdc, 0, 0, imgWidth, imgHeight, srcHdc, 0, 0, 0xCC0020);
        byte red = 0;
        byte green = 0;
        byte blue = 0;
        if (transparentPixel != -1) {
            if (bm.bmBitsPixel <= 8) {
                byte[] color = new byte[4];
                OS.GetDIBColorTable(srcHdc, transparentPixel, 1, color);
                blue = color[0];
                green = color[1];
                red = color[2];
            } else {
                switch (bm.bmBitsPixel) {
                    case 16: {
                        blue = (byte)((transparentPixel & 0x1F) << 3);
                        green = (byte)((transparentPixel & 0x3E0) >> 2);
                        red = (byte)((transparentPixel & 0x7C00) >> 7);
                        break;
                    }
                    case 24: {
                        blue = (byte)((transparentPixel & 0xFF0000) >> 16);
                        green = (byte)((transparentPixel & 0xFF00) >> 8);
                        red = (byte)(transparentPixel & 0xFF);
                        break;
                    }
                    case 32: {
                        blue = (byte)((transparentPixel & 0xFF000000) >>> 24);
                        green = (byte)((transparentPixel & 0xFF0000) >> 16);
                        red = (byte)((transparentPixel & 0xFF00) >> 8);
                    }
                }
            }
        }
        OS.SelectObject(srcHdc, oldSrcBitmap);
        OS.SelectObject(memHdc, oldMemBitmap);
        OS.DeleteObject(srcHdc);
        OS.DeleteObject(memHdc);
        OS.ReleaseDC(0L, hDC);
        byte[] srcData = new byte[sizeInBytes];
        OS.MoveMemory(srcData, pBits[0], sizeInBytes);
        if (alpha != -1) {
            int y = 0;
            int dp = 0;
            while (y < imgHeight) {
                int x = 0;
                while (x < imgWidth) {
                    if (alpha != 0) {
                        srcData[dp] = (byte)(((srcData[dp] & 0xFF) * 255 + alpha / 2) / alpha);
                        srcData[dp + 1] = (byte)(((srcData[dp + 1] & 0xFF) * 255 + alpha / 2) / alpha);
                        srcData[dp + 2] = (byte)(((srcData[dp + 2] & 0xFF) * 255 + alpha / 2) / alpha);
                    }
                    srcData[dp + 3] = (byte)alpha;
                    dp += 4;
                    ++x;
                }
                ++y;
            }
        } else if (alphaData != null) {
            int y = 0;
            int dp = 0;
            int ap = 0;
            while (y < imgHeight) {
                int x = 0;
                while (x < imgWidth) {
                    int a;
                    if ((a = alphaData[ap++] & 0xFF) != 0) {
                        srcData[dp] = (byte)(((srcData[dp] & 0xFF) * 255 + a / 2) / a);
                        srcData[dp + 1] = (byte)(((srcData[dp + 1] & 0xFF) * 255 + a / 2) / a);
                        srcData[dp + 2] = (byte)(((srcData[dp + 2] & 0xFF) * 255 + a / 2) / a);
                    }
                    srcData[dp + 3] = (byte)a;
                    dp += 4;
                    ++x;
                }
                ++y;
            }
        } else if (transparentPixel != -1) {
            int y = 0;
            int dp = 0;
            while (y < imgHeight) {
                int x = 0;
                while (x < imgWidth) {
                    srcData[dp + 3] = srcData[dp] == blue && srcData[dp + 1] == green && srcData[dp + 2] == red ? 0 : -1;
                    dp += 4;
                    ++x;
                }
                ++y;
            }
        }
        OS.MoveMemory(pBits[0], srcData, sizeInBytes);
        return memDib;
    }

    static Image createIcon(Image image) {
        Device device = image.getDevice();
        ImageData data = image.getImageData(DPIUtil.getDeviceZoom());
        if (data.alpha == -1 && data.alphaData == null) {
            ImageData mask = data.getTransparencyMask();
            return new Image(device, data, mask);
        }
        int width = data.width;
        int height = data.height;
        long hDC = device.internal_new_GC(null);
        long dstHdc = OS.CreateCompatibleDC(hDC);
        long hBitmap = Display.create32bitDIB(image.handle, data.alpha, data.alphaData, data.transparentPixel);
        long hMask = OS.CreateBitmap(width, height, 1, 1, null);
        long oldDstBitmap = OS.SelectObject(dstHdc, hMask);
        OS.PatBlt(dstHdc, 0, 0, width, height, 66);
        OS.SelectObject(dstHdc, oldDstBitmap);
        OS.DeleteDC(dstHdc);
        device.internal_dispose_GC(hDC, null);
        ICONINFO info = new ICONINFO();
        info.fIcon = true;
        info.hbmColor = hBitmap;
        info.hbmMask = hMask;
        long hIcon = OS.CreateIconIndirect(info);
        if (hIcon == 0L) {
            SWT.error(2);
        }
        OS.DeleteObject(hBitmap);
        OS.DeleteObject(hMask);
        return Image.win32_new(device, 1, hIcon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deregister(Display display) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            int i = 0;
            while (i < Displays.length) {
                if (display == Displays[i]) {
                    Display.Displays[i] = null;
                }
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int i = 0;
        while (i < this.disposeList.length) {
            if (this.disposeList[i] == null) {
                this.disposeList[i] = runnable;
                return;
            }
            ++i;
        }
        Runnable[] newDisposeList = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, newDisposeList, 0, this.disposeList.length);
        newDisposeList[this.disposeList.length] = runnable;
        this.disposeList = newDisposeList;
    }

    void drawMenuBars() {
        if (this.bars == null) {
            return;
        }
        Menu[] menuArray = this.bars;
        int n = this.bars.length;
        int n2 = 0;
        while (n2 < n) {
            Menu menu = menuArray[n2];
            if (menu != null && !menu.isDisposed()) {
                menu.update();
            }
            ++n2;
        }
        this.bars = null;
    }

    long embeddedProc(long hwnd, long msg, long wParam, long lParam) {
        switch ((int)msg) {
            case 32770: {
                MSG keyMsg = new MSG();
                OS.MoveMemory(keyMsg, lParam, MSG.sizeof);
                OS.TranslateMessage(keyMsg);
                OS.DispatchMessage(keyMsg);
                long hHeap = OS.GetProcessHeap();
                OS.HeapFree(hHeap, 0, lParam);
                break;
            }
            case 32771: {
                OS.DestroyWindow(hwnd);
                if (this.embeddedCallback != null) {
                    this.embeddedCallback.dispose();
                }
                if (this.getMsgCallback != null) {
                    this.getMsgCallback.dispose();
                }
                this.getMsgCallback = null;
                this.embeddedCallback = null;
                this.getMsgProc = 0L;
                this.embeddedProc = 0L;
            }
        }
        return OS.DefWindowProc(hwnd, (int)msg, wParam, lParam);
    }

    void error(int code) {
        SWT.error(code);
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            int type = event.type;
            this.sendPreEvent(type);
            try {
                this.filterTable.sendEvent(event);
            }
            finally {
                this.sendPostEvent(type);
            }
        }
        return false;
    }

    boolean filters(int eventType) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(eventType);
    }

    boolean filterMessage(MSG msg) {
        Control control;
        int message = msg.message;
        if (256 <= message && message <= 264 && (control = this.findControl(msg.hwnd)) != null && (this.translateAccelerator(msg, control) || this.translateMnemonic(msg, control) || this.translateTraversal(msg, control))) {
            this.lastKey = 0;
            this.lastAscii = 0;
            this.lastDead = false;
            this.lastVirtual = false;
            return true;
        }
        return false;
    }

    Control findControl(long handle) {
        if (handle == 0L) {
            return null;
        }
        long hwndOwner = 0L;
        do {
            Control control;
            if ((control = this.getControl(handle)) != null) {
                return control;
            }
            hwndOwner = OS.GetWindow(handle, 4);
        } while ((handle = OS.GetParent(handle)) != 0L && handle != hwndOwner);
        return null;
    }

    public Widget findWidget(long handle) {
        this.checkDevice();
        return this.getControl(handle);
    }

    public Widget findWidget(long handle, long id) {
        this.checkDevice();
        Control control = this.getControl(handle);
        return control != null ? control.findItem(id) : null;
    }

    public Widget findWidget(Widget widget, long id) {
        this.checkDevice();
        if (widget instanceof Control) {
            return this.findWidget(((Control)widget).handle, id);
        }
        return null;
    }

    long foregroundIdleProc(long code, long wParam, long lParam) {
        if (code >= 0L && !this.synchronizer.isMessagesEmpty()) {
            int flags;
            MSG msg;
            this.sendPostExternalEventDispatchEvent();
            if (this.runMessagesInIdle) {
                if (this.runMessagesInMessageProc) {
                    OS.PostMessage(this.hwndMessage, 32774, 0L, 0L);
                } else {
                    this.runAsyncMessages(false);
                }
            }
            if (!OS.PeekMessage(msg = new MSG(), 0L, 0, 0, flags = 458754)) {
                this.wakeThread();
            }
            this.sendPreExternalEventDispatchEvent();
        }
        return OS.CallNextHookEx(this.idleHook, (int)code, wParam, lParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display findDisplay(Thread thread) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            Display[] displayArray = Displays;
            int n = Displays.length;
            int n2 = 0;
            while (n2 < n) {
                Display display = displayArray[n2];
                if (display != null && display.thread == thread) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return display;
                }
                ++n2;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    TouchSource findTouchSource(long touchDevice, Monitor monitor) {
        if (this.touchSources == null) {
            this.touchSources = new TouchSource[4];
        }
        int length = this.touchSources.length;
        int i = 0;
        while (i < length) {
            if (this.touchSources[i] != null && this.touchSources[i].handle == touchDevice) {
                return this.touchSources[i];
            }
            ++i;
        }
        int index = 0;
        while (index < length) {
            if (this.touchSources[index] == null) break;
            ++index;
        }
        if (index == length) {
            TouchSource[] newTouchSources = new TouchSource[length + 4];
            System.arraycopy(this.touchSources, 0, newTouchSources, 0, length);
            this.touchSources = newTouchSources;
        }
        this.touchSources[index] = new TouchSource(touchDevice, true, monitor.getBounds());
        return this.touchSources[index];
    }

    public Shell getActiveShell() {
        this.checkDevice();
        Control control = this.findControl(OS.GetActiveWindow());
        return control != null ? control.getShell() : null;
    }

    public Menu getMenuBar() {
        this.checkDevice();
        return null;
    }

    @Override
    public Rectangle getBounds() {
        this.checkDevice();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        this.checkDevice();
        if (OS.GetSystemMetrics(80) < 2) {
            int width = OS.GetSystemMetrics(0);
            int height = OS.GetSystemMetrics(1);
            return new Rectangle(0, 0, width, height);
        }
        int x = OS.GetSystemMetrics(76);
        int y = OS.GetSystemMetrics(77);
        int width = OS.GetSystemMetrics(78);
        int height = OS.GetSystemMetrics(79);
        return new Rectangle(x, y, width, height);
    }

    public static Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    int getClickCount(int type, int button, long hwnd, long lParam) {
        switch (type) {
            case 3: {
                int doubleClick = OS.GetDoubleClickTime();
                if (this.clickRect == null) {
                    this.clickRect = new RECT();
                }
                int deltaTime = Math.abs(this.lastTime - this.getLastEventTime());
                POINT pt = new POINT();
                OS.POINTSTOPOINT(pt, lParam);
                this.clickCount = this.lastClickHwnd == hwnd && this.lastButton == button && deltaTime <= doubleClick && OS.PtInRect(this.clickRect, pt) ? ++this.clickCount : 1;
            }
            case 8: {
                this.lastButton = button;
                this.lastClickHwnd = hwnd;
                this.lastTime = this.getLastEventTime();
                int xInset = OS.GetSystemMetrics(36) / 2;
                int yInset = OS.GetSystemMetrics(37) / 2;
                int x = OS.GET_X_LPARAM(lParam);
                int y = OS.GET_Y_LPARAM(lParam);
                OS.SetRect(this.clickRect, x - xInset, y - yInset, x + xInset, y + yInset);
            }
            case 4: {
                return this.clickCount;
            }
        }
        return 0;
    }

    @Override
    public Rectangle getClientArea() {
        this.checkDevice();
        return DPIUtil.autoScaleDown(this.getClientAreaInPixels());
    }

    Rectangle getClientAreaInPixels() {
        this.checkDevice();
        if (OS.GetSystemMetrics(80) < 2) {
            RECT rect = new RECT();
            OS.SystemParametersInfo(48, 0, rect, 0);
            int width = rect.right - rect.left;
            int height = rect.bottom - rect.top;
            return new Rectangle(rect.left, rect.top, width, height);
        }
        int x = OS.GetSystemMetrics(76);
        int y = OS.GetSystemMetrics(77);
        int width = OS.GetSystemMetrics(78);
        int height = OS.GetSystemMetrics(79);
        return new Rectangle(x, y, width, height);
    }

    Control getControl(long handle) {
        Control control = this.controlByHandle.get(handle);
        return control;
    }

    public Control getCursorControl() {
        this.checkDevice();
        POINT pt = new POINT();
        if (!OS.GetCursorPos(pt)) {
            return null;
        }
        return this.findControl(OS.WindowFromPoint(pt));
    }

    public Point getCursorLocation() {
        this.checkDevice();
        return DPIUtil.autoScaleDown(this.getCursorLocationInPixels());
    }

    Point getCursorLocationInPixels() {
        POINT pt = new POINT();
        OS.GetCursorPos(pt);
        return new Point(pt.x, pt.y);
    }

    public Point[] getCursorSizes() {
        this.checkDevice();
        return new Point[]{new Point(OS.GetSystemMetrics(13), OS.GetSystemMetrics(14))};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display getDefault() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (Default == null) {
                Default = new Display();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Default;
        }
    }

    @Override
    protected int getDeviceZoom() {
        return this.getPrimaryMonitor().getZoom();
    }

    static boolean isValidClass(Class<?> clazz) {
        String name = clazz.getName();
        int index = name.lastIndexOf(46);
        return name.substring(0, index + 1).equals(PACKAGE_PREFIX);
    }

    public Object getData(String key) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (key.equals(RUN_MESSAGES_IN_IDLE_KEY)) {
            return this.runMessagesInIdle;
        }
        if (key.equals(RUN_MESSAGES_IN_MESSAGE_PROC_KEY)) {
            return this.runMessagesInMessageProc;
        }
        if (key.equals(USE_OWNDC_KEY)) {
            return this.useOwnDC;
        }
        if (key.equals(ACCEL_KEY_HIT)) {
            return this.accelKeyHit;
        }
        if (key.equals(APPLOCAL_DIR_KEY)) {
            return this.appLocalDir;
        }
        if (this.keys == null) {
            return null;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 16384;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return OS.GetDoubleClickTime();
    }

    public Control getFocusControl() {
        this.checkDevice();
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            return this.focusControl;
        }
        return this._getFocusControl();
    }

    String getFontName(LOGFONT logFont) {
        char[] chars = logFont.lfFaceName;
        int index = 0;
        while (index < chars.length) {
            if (chars[index] == '\u0000') break;
            ++index;
        }
        return new String(chars, 0, index);
    }

    public boolean getHighContrast() {
        this.checkDevice();
        HIGHCONTRAST pvParam = new HIGHCONTRAST();
        pvParam.cbSize = HIGHCONTRAST.sizeof;
        OS.SystemParametersInfo(66, 0, pvParam, 0);
        return (pvParam.dwFlags & 1) != 0;
    }

    public int getIconDepth() {
        TCHAR lpData;
        this.checkDevice();
        if (this.getDepth() >= 24) {
            return 32;
        }
        TCHAR buffer1 = new TCHAR(0, "Control Panel\\Desktop\\WindowMetrics", true);
        long[] phkResult = new long[1];
        int result = OS.RegOpenKeyEx(-2147483647L, buffer1, 0, 131097, phkResult);
        if (result != 0) {
            return 4;
        }
        int depth = 4;
        TCHAR buffer2 = new TCHAR(0, "Shell Icon BPP", true);
        int[] lpcbData = new int[1];
        result = OS.RegQueryValueEx(phkResult[0], buffer2, 0L, null, null, lpcbData);
        if (result == 0 && (result = OS.RegQueryValueEx(phkResult[0], buffer2, 0L, null, lpData = new TCHAR(0, lpcbData[0] / 2), lpcbData)) == 0) {
            try {
                depth = Integer.parseInt(lpData.toString(0, lpData.strlen()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        OS.RegCloseKey(phkResult[0]);
        return depth;
    }

    public Point[] getIconSizes() {
        this.checkDevice();
        return new Point[]{new Point(OS.GetSystemMetrics(49), OS.GetSystemMetrics(50)), new Point(OS.GetSystemMetrics(11), OS.GetSystemMetrics(12))};
    }

    ImageList getImageList(int style, int width, int height) {
        ImageList list;
        if (this.imageList == null) {
            this.imageList = new ImageList[4];
        }
        int i = 0;
        int length = this.imageList.length;
        while (i < length) {
            list = this.imageList[i];
            if (list == null) break;
            Point size = list.getImageSize();
            if (size.x == width && size.y == height && list.getStyle() == style) {
                list.addRef();
                return list;
            }
            ++i;
        }
        if (i == length) {
            ImageList[] newList = new ImageList[length + 4];
            System.arraycopy(this.imageList, 0, newList, 0, length);
            this.imageList = newList;
        }
        this.imageList[i] = list = new ImageList(style, width, height);
        list.addRef();
        return list;
    }

    ImageList getImageListToolBar(int style, int width, int height) {
        ImageList list;
        if (this.toolImageList == null) {
            this.toolImageList = new ImageList[4];
        }
        int i = 0;
        int length = this.toolImageList.length;
        while (i < length) {
            list = this.toolImageList[i];
            if (list == null) break;
            Point size = list.getImageSize();
            if (size.x == width && size.y == height && list.getStyle() == style) {
                list.addRef();
                return list;
            }
            ++i;
        }
        if (i == length) {
            ImageList[] newList = new ImageList[length + 4];
            System.arraycopy(this.toolImageList, 0, newList, 0, length);
            this.toolImageList = newList;
        }
        this.toolImageList[i] = list = new ImageList(style, width, height);
        list.addRef();
        return list;
    }

    ImageList getImageListToolBarDisabled(int style, int width, int height) {
        ImageList list;
        if (this.toolDisabledImageList == null) {
            this.toolDisabledImageList = new ImageList[4];
        }
        int i = 0;
        int length = this.toolDisabledImageList.length;
        while (i < length) {
            list = this.toolDisabledImageList[i];
            if (list == null) break;
            Point size = list.getImageSize();
            if (size.x == width && size.y == height && list.getStyle() == style) {
                list.addRef();
                return list;
            }
            ++i;
        }
        if (i == length) {
            ImageList[] newList = new ImageList[length + 4];
            System.arraycopy(this.toolDisabledImageList, 0, newList, 0, length);
            this.toolDisabledImageList = newList;
        }
        this.toolDisabledImageList[i] = list = new ImageList(style, width, height);
        list.addRef();
        return list;
    }

    ImageList getImageListToolBarHot(int style, int width, int height) {
        ImageList list;
        if (this.toolHotImageList == null) {
            this.toolHotImageList = new ImageList[4];
        }
        int i = 0;
        int length = this.toolHotImageList.length;
        while (i < length) {
            list = this.toolHotImageList[i];
            if (list == null) break;
            Point size = list.getImageSize();
            if (size.x == width && size.y == height && list.getStyle() == style) {
                list.addRef();
                return list;
            }
            ++i;
        }
        if (i == length) {
            ImageList[] newList = new ImageList[length + 4];
            System.arraycopy(this.toolHotImageList, 0, newList, 0, length);
            this.toolHotImageList = newList;
        }
        this.toolHotImageList[i] = list = new ImageList(style, width, height);
        list.addRef();
        return list;
    }

    public static boolean isSystemDarkTheme() {
        int[] result;
        boolean isDarkTheme = false;
        if (OS.WIN32_BUILD >= 17763 && (result = OS.readRegistryDwords(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize", "AppsUseLightTheme")) != null) {
            isDarkTheme = result[0] == 0;
        }
        return isDarkTheme;
    }

    int getLastEventTime() {
        return OS.GetMessageTime();
    }

    MenuItem getMenuItem(int id) {
        if (this.items == null) {
            return null;
        }
        if ((id -= 108) >= 0 && id < this.items.length) {
            return this.items[id];
        }
        return null;
    }

    Shell getModalShell() {
        if (this.modalShells == null) {
            return null;
        }
        int index = this.modalShells.length;
        while (--index >= 0) {
            Shell shell = this.modalShells[index];
            if (shell == null) continue;
            return shell;
        }
        return null;
    }

    Dialog getModalDialog() {
        return this.modalDialog;
    }

    Monitor getMonitor(long hmonitor) {
        MONITORINFO lpmi = new MONITORINFO();
        lpmi.cbSize = MONITORINFO.sizeof;
        OS.GetMonitorInfo(hmonitor, lpmi);
        Monitor monitor = new Monitor();
        monitor.handle = hmonitor;
        Rectangle boundsInPixels = new Rectangle(lpmi.rcMonitor_left, lpmi.rcMonitor_top, lpmi.rcMonitor_right - lpmi.rcMonitor_left, lpmi.rcMonitor_bottom - lpmi.rcMonitor_top);
        monitor.setBounds(DPIUtil.autoScaleDown(boundsInPixels));
        Rectangle clientAreaInPixels = new Rectangle(lpmi.rcWork_left, lpmi.rcWork_top, lpmi.rcWork_right - lpmi.rcWork_left, lpmi.rcWork_bottom - lpmi.rcWork_top);
        monitor.setClientArea(DPIUtil.autoScaleDown(clientAreaInPixels));
        int[] dpiX = new int[1];
        int[] dpiY = new int[1];
        int result = OS.GetDpiForMonitor(monitor.handle, 0, dpiX, dpiY);
        monitor.zoom = result = result == 0 ? DPIUtil.mapDPIToZoom(dpiX[0]) : 100;
        return monitor;
    }

    public Monitor[] getMonitors() {
        this.checkDevice();
        this.monitors = new Monitor[4];
        Callback callback = new Callback(this, "monitorEnumProc", 4);
        OS.EnumDisplayMonitors(0L, null, callback.getAddress(), 0);
        callback.dispose();
        Monitor[] result = new Monitor[this.monitorCount];
        System.arraycopy(this.monitors, 0, result, 0, this.monitorCount);
        this.monitors = null;
        this.monitorCount = 0;
        return result;
    }

    long getMsgProc(long code, long wParam, long lParam) {
        if (this.embeddedHwnd == 0L) {
            long hInstance = OS.GetModuleHandle(null);
            this.embeddedHwnd = OS.CreateWindowEx(0, this.windowClass, null, 0, 0, 0, 0, 0, 0L, 0L, hInstance, null);
            this.embeddedCallback = new Callback(this, "embeddedProc", 4);
            this.embeddedProc = this.embeddedCallback.getAddress();
            OS.SetWindowLongPtr(this.embeddedHwnd, -4, this.embeddedProc);
        }
        if (code >= 0L && (wParam & 1L) != 0L) {
            MSG msg = new MSG();
            OS.MoveMemory(msg, lParam, MSG.sizeof);
            block0 : switch (msg.message) {
                case 256: 
                case 257: 
                case 260: 
                case 261: {
                    Control control = this.findControl(msg.hwnd);
                    if (control == null) break;
                    long hHeap = OS.GetProcessHeap();
                    long keyMsg = OS.HeapAlloc(hHeap, 8, MSG.sizeof);
                    OS.MoveMemory(keyMsg, msg, MSG.sizeof);
                    OS.PostMessage(this.hwndMessage, 32770, wParam, keyMsg);
                    switch ((int)msg.wParam) {
                        case 16: 
                        case 17: 
                        case 18: 
                        case 20: 
                        case 144: 
                        case 145: {
                            break block0;
                        }
                    }
                    msg.message = 0;
                    OS.MoveMemory(lParam, msg, MSG.sizeof);
                }
            }
        }
        return OS.CallNextHookEx(this.msgHook, (int)code, wParam, lParam);
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        long hmonitor = OS.MonitorFromWindow(0L, 1);
        return this.getMonitor(hmonitor);
    }

    public Shell[] getShells() {
        this.checkDevice();
        int index = 0;
        Shell[] result = new Shell[16];
        for (Control control : this.controlByHandle.values()) {
            if (!(control instanceof Shell)) continue;
            int j = 0;
            while (j < index) {
                if (result[j] == control) break;
                ++j;
            }
            if (j != index) continue;
            if (index == result.length) {
                Shell[] newResult = new Shell[index + 16];
                System.arraycopy(result, 0, newResult, 0, index);
                result = newResult;
            }
            result[index++] = (Shell)control;
        }
        if (index == result.length) {
            return result;
        }
        Shell[] newResult = new Shell[index];
        System.arraycopy(result, 0, newResult, 0, index);
        return newResult;
    }

    public Synchronizer getSynchronizer() {
        this.checkDevice();
        return this.synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getSyncThread() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.synchronizer.syncThread;
        }
    }

    @Override
    public Color getSystemColor(int id) {
        this.checkDevice();
        int pixel = 0;
        switch (id) {
            case 17: {
                pixel = OS.GetSysColor(21);
                break;
            }
            case 39: {
                pixel = OS.GetSysColor(17);
                break;
            }
            case 18: {
                pixel = OS.GetSysColor(16);
                break;
            }
            case 19: {
                pixel = OS.GetSysColor(22);
                break;
            }
            case 20: {
                pixel = OS.GetSysColor(20);
                break;
            }
            case 22: 
            case 38: {
                pixel = OS.GetSysColor(15);
                break;
            }
            case 23: {
                pixel = OS.GetSysColor(6);
                break;
            }
            case 21: 
            case 24: {
                pixel = OS.GetSysColor(8);
                break;
            }
            case 25: {
                pixel = OS.GetSysColor(5);
                break;
            }
            case 26: {
                pixel = OS.GetSysColor(13);
                break;
            }
            case 27: {
                pixel = OS.GetSysColor(14);
                break;
            }
            case 36: {
                pixel = OS.GetSysColor(26);
                break;
            }
            case 28: {
                pixel = OS.GetSysColor(23);
                break;
            }
            case 29: {
                pixel = OS.GetSysColor(24);
                break;
            }
            case 30: {
                pixel = OS.GetSysColor(9);
                break;
            }
            case 31: {
                pixel = OS.GetSysColor(2);
                break;
            }
            case 32: {
                pixel = OS.GetSysColor(27);
                if (pixel != 0) break;
                pixel = OS.GetSysColor(2);
                break;
            }
            case 33: {
                pixel = OS.GetSysColor(19);
                break;
            }
            case 34: {
                pixel = OS.GetSysColor(3);
                break;
            }
            case 35: {
                pixel = OS.GetSysColor(28);
                if (pixel != 0) break;
                pixel = OS.GetSysColor(3);
                break;
            }
            default: {
                return super.getSystemColor(id);
            }
        }
        return Color.win32_new(this, pixel);
    }

    public Cursor getSystemCursor(int id) {
        this.checkDevice();
        if (id < 0 || id >= this.cursors.length) {
            return null;
        }
        if (this.cursors[id] == null) {
            this.cursors[id] = new Cursor(this, id);
        }
        return this.cursors[id];
    }

    @Override
    public Font getSystemFont() {
        this.checkDevice();
        if (this.systemFont != null) {
            return this.systemFont;
        }
        long hFont = 0L;
        NONCLIENTMETRICS info = new NONCLIENTMETRICS();
        info.cbSize = NONCLIENTMETRICS.sizeof;
        if (OS.SystemParametersInfo(41, 0, info, 0)) {
            LOGFONT logFont = info.lfMessageFont;
            hFont = OS.CreateFontIndirect(logFont);
            LOGFONT lOGFONT = this.lfSystemFont = hFont != 0L ? logFont : null;
        }
        if (hFont == 0L) {
            hFont = OS.GetStockObject(17);
        }
        if (hFont == 0L) {
            hFont = OS.GetStockObject(13);
        }
        this.systemFont = Font.win32_new(this, hFont);
        return this.systemFont;
    }

    public Image getSystemImage(int id) {
        this.checkDevice();
        switch (id) {
            case 1: {
                if (this.errorImage != null) {
                    return this.errorImage;
                }
                long hIcon = OS.LoadImage(0L, 32513L, 1, 0, 0, 32768);
                this.errorImage = Image.win32_new(this, 1, hIcon);
                return this.errorImage;
            }
            case 2: 
            case 16: {
                if (this.infoImage != null) {
                    return this.infoImage;
                }
                long hIcon = OS.LoadImage(0L, 32516L, 1, 0, 0, 32768);
                this.infoImage = Image.win32_new(this, 1, hIcon);
                return this.infoImage;
            }
            case 4: {
                if (this.questionImage != null) {
                    return this.questionImage;
                }
                long hIcon = OS.LoadImage(0L, 32514L, 1, 0, 0, 32768);
                this.questionImage = Image.win32_new(this, 1, hIcon);
                return this.questionImage;
            }
            case 8: {
                if (this.warningIcon != null) {
                    return this.warningIcon;
                }
                long hIcon = OS.LoadImage(0L, 32515L, 1, 0, 0, 32768);
                this.warningIcon = Image.win32_new(this, 1, hIcon);
                return this.warningIcon;
            }
        }
        return null;
    }

    public Menu getSystemMenu() {
        this.checkDevice();
        return null;
    }

    public TaskBar getSystemTaskBar() {
        this.checkDevice();
        if (this.taskBar != null) {
            return this.taskBar;
        }
        try {
            this.taskBar = new TaskBar(this, 0);
        }
        catch (SWTError e) {
            if (e.code == 20) {
                return null;
            }
            throw e;
        }
        return this.taskBar;
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (this.tray == null) {
            this.tray = new Tray(this, 0);
        }
        return this.tray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.thread;
        }
    }

    public boolean getTouchEnabled() {
        this.checkDevice();
        int value = OS.GetSystemMetrics(94);
        return (value & 0xC0) == 192;
    }

    long hButtonTheme() {
        if (this.hButtonTheme != 0L) {
            return this.hButtonTheme;
        }
        char[] themeName = "BUTTON\u0000".toCharArray();
        this.hButtonTheme = OS.OpenThemeData(this.hwndMessage, themeName);
        return this.hButtonTheme;
    }

    long hButtonThemeDark() {
        if (this.hButtonThemeDark != 0L) {
            return this.hButtonThemeDark;
        }
        char[] themeName = "Darkmode_Explorer::BUTTON\u0000".toCharArray();
        this.hButtonThemeDark = OS.OpenThemeData(this.hwndMessage, themeName);
        return this.hButtonThemeDark;
    }

    long hButtonThemeAuto() {
        if (this.useDarkModeExplorerTheme) {
            return this.hButtonThemeDark();
        }
        return this.hButtonTheme();
    }

    long hEditTheme() {
        if (this.hEditTheme != 0L) {
            return this.hEditTheme;
        }
        char[] themeName = "EDIT\u0000".toCharArray();
        this.hEditTheme = OS.OpenThemeData(this.hwndMessage, themeName);
        return this.hEditTheme;
    }

    long hExplorerBarTheme() {
        if (this.hExplorerBarTheme != 0L) {
            return this.hExplorerBarTheme;
        }
        char[] themeName = "EXPLORERBAR\u0000".toCharArray();
        this.hExplorerBarTheme = OS.OpenThemeData(this.hwndMessage, themeName);
        return this.hExplorerBarTheme;
    }

    long hScrollBarTheme() {
        if (this.hScrollBarTheme != 0L) {
            return this.hScrollBarTheme;
        }
        char[] themeName = "SCROLLBAR\u0000".toCharArray();
        this.hScrollBarTheme = OS.OpenThemeData(this.hwndMessage, themeName);
        return this.hScrollBarTheme;
    }

    long hTabTheme() {
        if (this.hTabTheme != 0L) {
            return this.hTabTheme;
        }
        char[] themeName = "TAB\u0000".toCharArray();
        this.hTabTheme = OS.OpenThemeData(this.hwndMessage, themeName);
        return this.hTabTheme;
    }

    void resetThemes() {
        if (this.hButtonTheme != 0L) {
            OS.CloseThemeData(this.hButtonTheme);
            this.hButtonTheme = 0L;
        }
        if (this.hButtonThemeDark != 0L) {
            OS.CloseThemeData(this.hButtonThemeDark);
            this.hButtonThemeDark = 0L;
        }
        if (this.hEditTheme != 0L) {
            OS.CloseThemeData(this.hEditTheme);
            this.hEditTheme = 0L;
        }
        if (this.hExplorerBarTheme != 0L) {
            OS.CloseThemeData(this.hExplorerBarTheme);
            this.hExplorerBarTheme = 0L;
        }
        if (this.hScrollBarTheme != 0L) {
            OS.CloseThemeData(this.hScrollBarTheme);
            this.hScrollBarTheme = 0L;
        }
        if (this.hTabTheme != 0L) {
            OS.CloseThemeData(this.hTabTheme);
            this.hTabTheme = 0L;
        }
    }

    @Override
    public long internal_new_GC(GCData data) {
        long hDC;
        if (this.isDisposed()) {
            this.error(45);
        }
        if ((hDC = OS.GetDC(0L)) == 0L) {
            this.error(2);
        }
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) != 0) {
                data.layout = (data.style & 0x4000000) != 0 ? 1 : 0;
            } else {
                data.style |= 0x2000000;
            }
            data.device = this;
            data.font = this.getSystemFont();
        }
        return hDC;
    }

    @Override
    protected void init() {
        long[] ppv;
        int hr;
        this.controlByHandle = new HashMap<Long, Control>();
        this.synchronizer = new Synchronizer(this);
        super.init();
        DPIUtil.setDeviceZoom(this.getDeviceZoom());
        char[] appName = null;
        if (APP_NAME != null && !"SWT".equalsIgnoreCase(APP_NAME)) {
            int length = APP_NAME.length();
            appName = new char[length + 1];
            APP_NAME.getChars(0, length, appName, 0);
            long[] appID = new long[1];
            if (OS.GetCurrentProcessExplicitAppUserModelID(appID) != 0) {
                OS.SetCurrentProcessExplicitAppUserModelID(appName);
            }
            if (appID[0] != 0L) {
                OS.CoTaskMemFree(appID[0]);
            }
        }
        this.windowCallback = new Callback(this, "windowProc", 4);
        this.windowProc = this.windowCallback.getAddress();
        this.threadId = OS.GetCurrentThreadId();
        this.windowClass = new TCHAR(0, WindowName + WindowClassCount, true);
        this.windowShadowClass = new TCHAR(0, WindowShadowName + WindowClassCount, true);
        this.windowOwnDCClass = new TCHAR(0, WindowOwnDCName + WindowClassCount, true);
        ++WindowClassCount;
        long hInstance = OS.GetModuleHandle(null);
        WNDCLASS lpWndClass = new WNDCLASS();
        lpWndClass.hInstance = hInstance;
        lpWndClass.lpfnWndProc = this.windowProc;
        lpWndClass.style = 8;
        lpWndClass.hCursor = OS.LoadCursor(0L, 32512L);
        lpWndClass.hIcon = OS.LoadIcon(0L, 32512L);
        OS.RegisterClass(this.windowClass, lpWndClass);
        lpWndClass.style |= 0x20000;
        OS.RegisterClass(this.windowShadowClass, lpWndClass);
        lpWndClass.style |= 0x20;
        OS.RegisterClass(this.windowOwnDCClass, lpWndClass);
        this.hwndMessage = OS.CreateWindowEx(0, this.windowClass, null, 0, 0, 0, 0, 0, 0L, 0L, hInstance, null);
        String title = "SWT_Window_" + APP_NAME;
        OS.SetWindowText(this.hwndMessage, new TCHAR(0, title, true));
        this.messageCallback = new Callback(this, "messageProc", 4);
        this.messageProc = this.messageCallback.getAddress();
        OS.SetWindowLongPtr(this.hwndMessage, -4, this.messageProc);
        this.msgFilterCallback = new Callback(this, "msgFilterProc", 3);
        this.msgFilterProc = this.msgFilterCallback.getAddress();
        this.filterHook = OS.SetWindowsHookEx(-1, this.msgFilterProc, 0L, this.threadId);
        this.foregroundIdleCallback = new Callback(this, "foregroundIdleProc", 3);
        this.foregroundIdleProc = this.foregroundIdleCallback.getAddress();
        this.idleHook = OS.SetWindowsHookEx(11, this.foregroundIdleProc, 0L, this.threadId);
        TASKBARCREATED = OS.RegisterWindowMessage(new TCHAR(0, "TaskbarCreated", true));
        TASKBARBUTTONCREATED = OS.RegisterWindowMessage(new TCHAR(0, "TaskbarButtonCreated", true));
        SWT_RESTORECARET = OS.RegisterWindowMessage(new TCHAR(0, "SWT_RESTORECARET", true));
        DI_GETDRAGIMAGE = OS.RegisterWindowMessage(new TCHAR(0, "ShellGetDragImage", true));
        SWT_OPENDOC = OS.RegisterWindowMessage(new TCHAR(0, "SWT_OPENDOC", true));
        OS.OleInitialize(0L);
        if (appName != null && (hr = COM.CoCreateInstance(COM.CLSID_DestinationList, 0L, 1, COM.IID_ICustomDestinationList, ppv = new long[1])) == 0) {
            ICustomDestinationList pList = new ICustomDestinationList(ppv[0]);
            pList.DeleteList(appName);
            pList.Release();
        }
        this.appLocalDir = String.valueOf(System.getenv("LOCALAPPDATA")) + "\\" + APP_NAME.replaceAll("[\\\\/:*?\"<>|]", "_");
        OS.BufferedPaintInit();
    }

    @Override
    public void internal_dispose_GC(long hDC, GCData data) {
        OS.ReleaseDC(0L, hDC);
    }

    boolean isXMouseActive() {
        boolean xMouseActive = false;
        int[] result = OS.readRegistryDwords(-2147483647, "Control Panel\\Desktop", "UserPreferencesMask");
        if (result != null) {
            xMouseActive = (result[0] & 1) != 0;
        }
        return xMouseActive;
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    public Point map(Control from, Control to, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        point = DPIUtil.autoScaleUp(point);
        return DPIUtil.autoScaleDown(this.mapInPixels(from, to, point));
    }

    Point mapInPixels(Control from, Control to, Point point) {
        return this.mapInPixels(from, to, point.x, point.y);
    }

    public Point map(Control from, Control to, int x, int y) {
        this.checkDevice();
        x = DPIUtil.autoScaleUp(x);
        y = DPIUtil.autoScaleUp(y);
        return DPIUtil.autoScaleDown(this.mapInPixels(from, to, x, y));
    }

    Point mapInPixels(Control from, Control to, int x, int y) {
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        if (from == to) {
            return new Point(x, y);
        }
        long hwndFrom = from != null ? from.handle : 0L;
        long hwndTo = to != null ? to.handle : 0L;
        POINT point = new POINT();
        point.x = x;
        point.y = y;
        OS.MapWindowPoints(hwndFrom, hwndTo, point, 1);
        return new Point(point.x, point.y);
    }

    public Rectangle map(Control from, Control to, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        rectangle = DPIUtil.autoScaleUp(rectangle);
        return DPIUtil.autoScaleDown(this.mapInPixels(from, to, rectangle));
    }

    Rectangle mapInPixels(Control from, Control to, Rectangle rectangle) {
        return this.mapInPixels(from, to, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control from, Control to, int x, int y, int width, int height) {
        this.checkDevice();
        x = DPIUtil.autoScaleUp(x);
        y = DPIUtil.autoScaleUp(y);
        width = DPIUtil.autoScaleUp(width);
        height = DPIUtil.autoScaleUp(height);
        return DPIUtil.autoScaleDown(this.mapInPixels(from, to, x, y, width, height));
    }

    Rectangle mapInPixels(Control from, Control to, int x, int y, int width, int height) {
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        if (from == to) {
            return new Rectangle(x, y, width, height);
        }
        long hwndFrom = from != null ? from.handle : 0L;
        long hwndTo = to != null ? to.handle : 0L;
        RECT rect = new RECT();
        rect.left = x;
        rect.top = y;
        rect.right = x + width;
        rect.bottom = y + height;
        OS.MapWindowPoints(hwndFrom, hwndTo, rect, 2);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    long messageProc(long hwnd, long msg, long wParam, long lParam) {
        switch ((int)msg) {
            case 32774: {
                if (!this.runMessagesInIdle) break;
                this.runAsyncMessages(false);
                break;
            }
            case 32770: {
                boolean consumed = false;
                MSG keyMsg = new MSG();
                OS.MoveMemory(keyMsg, lParam, MSG.sizeof);
                Control control = this.findControl(keyMsg.hwnd);
                if (control != null) {
                    boolean accentKey = false;
                    block12 : switch (keyMsg.message) {
                        case 256: 
                        case 260: {
                            switch ((int)keyMsg.wParam) {
                                case 16: 
                                case 17: 
                                case 18: 
                                case 20: 
                                case 144: 
                                case 145: {
                                    break block12;
                                }
                            }
                            int mapKey = OS.MapVirtualKey((int)keyMsg.wParam, 2);
                            if (mapKey == 0) break;
                            boolean bl = accentKey = (mapKey & Integer.MIN_VALUE) != 0;
                            if (accentKey) break;
                            short[] sArray = ACCENTS;
                            int n = ACCENTS.length;
                            int n2 = 0;
                            while (n2 < n) {
                                short accent = sArray[n2];
                                short value = OS.VkKeyScan(accent);
                                if (value != -1 && (long)(value & 0xFF) == keyMsg.wParam) {
                                    int state = value >> 8;
                                    if (OS.GetKeyState(16) < 0 == ((state & 1) != 0) && OS.GetKeyState(17) < 0 == ((state & 2) != 0) && OS.GetKeyState(18) < 0 == ((state & 4) != 0)) {
                                        if ((state & 7) == 0) break block12;
                                        accentKey = true;
                                        break block12;
                                    }
                                }
                                ++n2;
                            }
                            break;
                        }
                    }
                    if (!accentKey && !this.ignoreNextKey) {
                        keyMsg.hwnd = control.handle;
                        int flags = 10420227;
                        do {
                            if (consumed |= this.filterMessage(keyMsg)) continue;
                            OS.TranslateMessage(keyMsg);
                            consumed |= OS.DispatchMessage(keyMsg) == 1L;
                        } while (OS.PeekMessage(keyMsg, keyMsg.hwnd, 256, 264, flags));
                    }
                    block18 : switch (keyMsg.message) {
                        case 256: 
                        case 260: {
                            switch ((int)keyMsg.wParam) {
                                case 16: 
                                case 17: 
                                case 18: 
                                case 20: 
                                case 144: 
                                case 145: {
                                    break block18;
                                }
                            }
                            this.ignoreNextKey = accentKey;
                        }
                    }
                }
                switch ((int)keyMsg.wParam) {
                    case 16: 
                    case 17: 
                    case 18: 
                    case 20: 
                    case 144: 
                    case 145: {
                        consumed = true;
                    }
                }
                if (consumed) {
                    long hHeap = OS.GetProcessHeap();
                    OS.HeapFree(hHeap, 0, lParam);
                } else {
                    OS.PostMessage(this.embeddedHwnd, 32770, wParam, lParam);
                }
                return 0L;
            }
            case 32772: {
                if (this.tray != null) {
                    TrayItem[] hHeap = this.tray.items;
                    int control = this.tray.items.length;
                    int keyMsg = 0;
                    while (keyMsg < control) {
                        TrayItem item = hHeap[keyMsg];
                        if (item != null && (long)item.id == wParam) {
                            return item.messageProc(hwnd, (int)msg, wParam, lParam);
                        }
                        ++keyMsg;
                    }
                }
                return 0L;
            }
            case 28: {
                long hwndPopup;
                Shell modal;
                long hwndActive;
                if (wParam == 0L || this.isXMouseActive() || (hwndActive = OS.GetActiveWindow()) != 0L && OS.IsWindowEnabled(hwndActive)) break;
                Shell shell = modal = this.modalDialog != null ? this.modalDialog.parent : this.getModalShell();
                if (modal == null || modal.isDisposed()) break;
                long hwndModal = modal.handle;
                if (OS.IsWindowEnabled(hwndModal)) {
                    modal.bringToTop();
                    if (modal.isDisposed()) break;
                }
                if ((hwndPopup = OS.GetLastActivePopup(hwndModal)) == 0L || hwndPopup == modal.handle || this.getControl(hwndPopup) != null || !OS.IsWindowEnabled(hwndPopup)) break;
                OS.SetActiveWindow(hwndPopup);
                break;
            }
            case 22: {
                if (wParam == 0L) break;
                this.dispose();
                break;
            }
            case 17: {
                Event event = new Event();
                this.sendEvent(21, event);
                if (event.doit) break;
                return 0L;
            }
            case 26: 
            case 800: {
                OS.SetTimer(this.hwndMessage, 100L, 2000, 0L);
                break;
            }
            case 794: {
                this.resetThemes();
                break;
            }
            case 275: {
                if (wParam == 100L) {
                    OS.KillTimer(this.hwndMessage, 100L);
                    this.runSettings();
                    break;
                }
                this.runTimer(wParam);
                break;
            }
            default: {
                String filename;
                if ((int)msg == TASKBARCREATED && this.tray != null) {
                    TrayItem[] hwndModal = this.tray.items;
                    int modal = this.tray.items.length;
                    int keyMsg = 0;
                    while (keyMsg < modal) {
                        TrayItem item = hwndModal[keyMsg];
                        if (item != null) {
                            item.recreate();
                        }
                        ++keyMsg;
                    }
                }
                if ((int)msg != SWT_OPENDOC || (filename = this.getSharedData((int)wParam, (int)lParam)) == null) break;
                if (filename.startsWith(TASKBAR_EVENT)) {
                    String text = filename.substring(TASKBAR_EVENT.length());
                    int id = Integer.parseInt(text);
                    MenuItem item = this.getMenuItem(id);
                    if (item != null) {
                        item.sendSelectionEvent(13);
                    }
                } else {
                    Event event = new Event();
                    event.text = filename;
                    try {
                        new URI(filename);
                        this.sendEvent(54, event);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        this.sendEvent(46, event);
                    }
                }
                this.wakeThread();
            }
        }
        return OS.DefWindowProc(hwnd, (int)msg, wParam, lParam);
    }

    String getSharedData(int pid, int handle) {
        long[] mapHandle = new long[1];
        if (pid == OS.GetCurrentProcessId()) {
            mapHandle[0] = handle;
        } else {
            long processHandle = OS.OpenProcess(80, false, pid);
            if (processHandle == 0L) {
                return null;
            }
            OS.DuplicateHandle(processHandle, handle, OS.GetCurrentProcess(), mapHandle, 2, false, 2);
            OS.CloseHandle(processHandle);
        }
        long sharedData = OS.MapViewOfFile(mapHandle[0], 4, 0, 0, 0);
        if (sharedData == 0L) {
            return null;
        }
        int length = OS.wcslen(sharedData);
        TCHAR buffer = new TCHAR(0, length);
        int byteCount = buffer.length() * 2;
        OS.MoveMemory(buffer, sharedData, byteCount);
        String result = buffer.toString(0, length);
        OS.UnmapViewOfFile(sharedData);
        if ((long)handle != mapHandle[0]) {
            OS.CloseHandle(mapHandle[0]);
        }
        return result;
    }

    long monitorEnumProc(long hmonitor, long hdc, long lprcMonitor, long dwData) {
        if (this.monitorCount >= this.monitors.length) {
            Monitor[] newMonitors = new Monitor[this.monitors.length + 4];
            System.arraycopy(this.monitors, 0, newMonitors, 0, this.monitors.length);
            this.monitors = newMonitors;
        }
        this.monitors[this.monitorCount++] = this.getMonitor(hmonitor);
        return 1L;
    }

    long msgFilterProc(long code, long wParam, long lParam) {
        switch ((int)code) {
            case 16896: {
                if (this.runDragDrop || this.dragCancelled) break;
                OS.MoveMemory(this.hookMsg, lParam, MSG.sizeof);
                if (this.hookMsg.message != 512) break;
                this.dragCancelled = true;
                OS.SendMessage(this.hookMsg.hwnd, 31, 0L, 0L);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                int flags;
                MSG msg;
                OS.MoveMemory(this.hookMsg, lParam, MSG.sizeof);
                if (this.hookMsg.message != 0 || OS.PeekMessage(msg = new MSG(), 0L, 0, 0, flags = 10420226) || !this.runAsyncMessages(false)) break;
                this.wakeThread();
            }
        }
        return OS.CallNextHookEx(this.filterHook, (int)code, wParam, lParam);
    }

    int numpadKey(int key) {
        switch (key) {
            case 96: {
                return 48;
            }
            case 97: {
                return 49;
            }
            case 98: {
                return 50;
            }
            case 99: {
                return 51;
            }
            case 100: {
                return 52;
            }
            case 101: {
                return 53;
            }
            case 102: {
                return 54;
            }
            case 103: {
                return 55;
            }
            case 104: {
                return 56;
            }
            case 105: {
                return 57;
            }
            case 106: {
                return 42;
            }
            case 107: {
                return 43;
            }
            case 108: {
                return 0;
            }
            case 109: {
                return 45;
            }
            case 110: {
                return 46;
            }
            case 111: {
                return 47;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean post(Event event) {
        var2_2 = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (event == null) {
                this.error(4);
            }
            type = event.type;
            switch (type) {
                case 1: 
                case 2: {
                    inputs = new KEYBDINPUT();
                    inputs.wVk = (short)Display.untranslateKey(event.keyCode);
                    if (inputs.wVk == 0) {
                        key = event.character;
                        switch (key) {
                            case '\b': {
                                inputs.wVk = (short)8;
                                break;
                            }
                            case '\r': {
                                inputs.wVk = (short)13;
                                break;
                            }
                            case '\u007f': {
                                inputs.wVk = (short)46;
                                break;
                            }
                            case '\u001b': {
                                inputs.wVk = (short)27;
                                break;
                            }
                            case '\t': {
                                inputs.wVk = (short)9;
                                break;
                            }
                            case '\n': {
                                // ** MonitorExit[var2_2] (shouldn't be in output)
                                return false;
                            }
                            default: {
                                inputs.wVk = OS.VkKeyScan((short)key);
                                if (inputs.wVk == -1) {
                                    // ** MonitorExit[var2_2] (shouldn't be in output)
                                    return false;
                                }
                                inputs.wVk = (short)(inputs.wVk & 255);
                            }
                        }
                    }
                    inputs.dwFlags = type == 2 ? 2 : 0;
                    switch (inputs.wVk) {
                        case 3: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 37: 
                        case 38: 
                        case 39: 
                        case 40: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 111: 
                        case 144: {
                            inputs.dwFlags |= 1;
                            break;
                        }
                    }
                    pInputs = new INPUT();
                    pInputs.type = 1;
                    pInputs.ki = inputs;
                    if (OS.SendInput(1, pInputs, INPUT.sizeof) == 0) return false;
                    return true;
                }
                case 3: 
                case 4: 
                case 5: 
                case 37: {
                    inputs = new MOUSEINPUT();
                    if (type != 5) ** GOTO lbl62
                    inputs.dwFlags = 49153;
                    x = OS.GetSystemMetrics(76);
                    y = OS.GetSystemMetrics(77);
                    width = OS.GetSystemMetrics(78);
                    height = OS.GetSystemMetrics(79);
                    loc = event.getLocationInPixels();
                    inputs.dx = ((loc.x - x) * 65535 + width - 2) / (width - 1);
                    inputs.dy = ((loc.y - y) * 65535 + height - 2) / (height - 1);
                    ** GOTO lbl98
lbl62:
                    // 1 sources

                    if (type != 37) ** GOTO lbl77
                    inputs.dwFlags = 2048;
                    switch (event.detail) {
                        case 2: {
                            inputs.mouseData = event.count * 120;
                            ** GOTO lbl98
                        }
                        case 1: {
                            value = new int[1];
                            OS.SystemParametersInfo(104, 0, value, 0);
                            inputs.mouseData = event.count * 120 / value[0];
                            ** GOTO lbl98
                        }
                        default: {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return false;
                        }
                    }
lbl77:
                    // 1 sources

                    switch (event.button) {
                        case 1: {
                            inputs.dwFlags = type == 3 ? 2 : 4;
                            break;
                        }
                        case 2: {
                            inputs.dwFlags = type == 3 ? 32 : 64;
                            break;
                        }
                        case 3: {
                            inputs.dwFlags = type == 3 ? 8 : 16;
                            break;
                        }
                        case 4: {
                            inputs.dwFlags = type == 3 ? 128 : 256;
                            inputs.mouseData = 1;
                            break;
                        }
                        case 5: {
                            inputs.dwFlags = type == 3 ? 128 : 256;
                            inputs.mouseData = 2;
                            break;
                        }
                        default: {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return false;
                        }
                    }
lbl98:
                    // 8 sources

                    pInputs = new INPUT();
                    pInputs.type = 0;
                    pInputs.mi = inputs;
                    if (OS.SendInput(1, pInputs, INPUT.sizeof) == 0) return false;
                    return true;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    void postEvent(Event event) {
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int index = 0;
        int length = this.eventQueue.length;
        while (index < length) {
            if (this.eventQueue[index] == null) break;
            ++index;
        }
        if (index == length) {
            Event[] newQueue = new Event[length + 4];
            System.arraycopy(this.eventQueue, 0, newQueue, 0, length);
            this.eventQueue = newQueue;
        }
        this.eventQueue[index] = event;
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        lpStartupInfo = null;
        this.drawMenuBars();
        this.runSkin();
        this.runDeferredLayouts();
        this.runPopups();
        if (OS.PeekMessage(this.msg, 0L, 0, 0, 1)) {
            if (!this.filterMessage(this.msg)) {
                OS.TranslateMessage(this.msg);
                OS.DispatchMessage(this.msg);
            }
            this.runDeferredEvents();
            return true;
        }
        return this.isDisposed() || this.runAsyncMessages(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Display display) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            int i = 0;
            while (i < Displays.length) {
                if (Displays[i] == null) {
                    Display.Displays[i] = display;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                ++i;
            }
            Display[] newDisplays = new Display[Displays.length + 4];
            System.arraycopy(Displays, 0, newDisplays, 0, Displays.length);
            newDisplays[Display.Displays.length] = display;
            Displays = newDisplays;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected void release() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ExceptionStash exceptions = new ExceptionStash();){
            try {
                this.sendEvent(12, new Event());
            }
            catch (Error | RuntimeException ex) {
                exceptions.stash(ex);
            }
            Object[] objectArray = this.getShells();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = objectArray[n2];
                try {
                    if (!shell.isDisposed()) {
                        shell.dispose();
                    }
                }
                catch (Error | RuntimeException ex) {
                    exceptions.stash(ex);
                }
                ++n2;
            }
            try {
                if (this.tray != null) {
                    this.tray.dispose();
                }
            }
            catch (Error | RuntimeException ex) {
                exceptions.stash(ex);
            }
            this.tray = null;
            try {
                if (this.taskBar != null) {
                    this.taskBar.dispose();
                }
            }
            catch (Error | RuntimeException ex) {
                exceptions.stash(ex);
            }
            this.taskBar = null;
            while (true) {
                try {
                    while (this.readAndDispatch()) {
                    }
                }
                catch (Error | RuntimeException ex) {
                    exceptions.stash(ex);
                    continue;
                }
                break;
            }
            if (this.disposeList != null) {
                objectArray = this.disposeList;
                n = this.disposeList.length;
                n2 = 0;
                while (n2 < n) {
                    Object next = objectArray[n2];
                    if (next != null) {
                        try {
                            next.run();
                        }
                        catch (Error | RuntimeException ex) {
                            exceptions.stash(ex);
                        }
                    }
                    ++n2;
                }
            }
            this.disposeList = null;
            this.synchronizer.releaseSynchronizer();
            this.synchronizer = null;
            this.releaseDisplay();
            super.release();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    void releaseDisplay() {
        if (this.embeddedHwnd != 0L) {
            OS.PostMessage(this.embeddedHwnd, 32771, 0L, 0L);
        }
        if (this.hIconSearch != 0L) {
            OS.DestroyIcon(this.hIconSearch);
        }
        if (this.hIconCancel != 0L) {
            OS.DestroyIcon(this.hIconCancel);
        }
        this.resetThemes();
        if (this.menuBarBorderPen != 0L) {
            OS.DeleteObject(this.menuBarBorderPen);
        }
        this.menuBarBorderPen = 0L;
        if (this.msgHook != 0L) {
            OS.UnhookWindowsHookEx(this.msgHook);
        }
        this.msgHook = 0L;
        if (this.filterHook != 0L) {
            OS.UnhookWindowsHookEx(this.filterHook);
        }
        this.filterHook = 0L;
        this.msgFilterCallback.dispose();
        this.msgFilterCallback = null;
        this.msgFilterProc = 0L;
        if (this.idleHook != 0L) {
            OS.UnhookWindowsHookEx(this.idleHook);
        }
        this.idleHook = 0L;
        this.foregroundIdleCallback.dispose();
        this.foregroundIdleCallback = null;
        this.foregroundIdleProc = 0L;
        OS.KillTimer(this.hwndMessage, 100L);
        if (this.hwndMessage != 0L) {
            OS.DestroyWindow(this.hwndMessage);
        }
        this.hwndMessage = 0L;
        this.messageCallback.dispose();
        this.messageCallback = null;
        this.messageProc = 0L;
        long hHeap = OS.GetProcessHeap();
        long hInstance = OS.GetModuleHandle(null);
        OS.UnregisterClass(this.windowClass, hInstance);
        OS.UnregisterClass(this.windowShadowClass, hInstance);
        OS.UnregisterClass(this.windowOwnDCClass, hInstance);
        this.windowOwnDCClass = null;
        this.windowShadowClass = null;
        this.windowClass = null;
        this.windowCallback.dispose();
        this.windowCallback = null;
        this.windowProc = 0L;
        if (this.systemFont != null) {
            this.systemFont.dispose();
        }
        this.systemFont = null;
        this.lfSystemFont = null;
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        if (this.infoImage != null) {
            this.infoImage.dispose();
        }
        if (this.questionImage != null) {
            this.questionImage.dispose();
        }
        if (this.warningIcon != null) {
            this.warningIcon.dispose();
        }
        this.warningIcon = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        Resource[] resourceArray = this.cursors;
        int n = this.cursors.length;
        int n2 = 0;
        while (n2 < n) {
            Cursor cursor = resourceArray[n2];
            if (cursor != null) {
                cursor.dispose();
            }
            ++n2;
        }
        this.cursors = null;
        if (this.resources != null) {
            resourceArray = this.resources;
            n = this.resources.length;
            n2 = 0;
            while (n2 < n) {
                Resource resource = resourceArray[n2];
                if (resource != null) {
                    resource.dispose();
                }
                ++n2;
            }
            this.resources = null;
        }
        if (this.lpCustColors != 0L) {
            OS.HeapFree(hHeap, 0, this.lpCustColors);
        }
        this.lpCustColors = 0L;
        OS.OleUninitialize();
        OS.BufferedPaintUnInit();
        this.thread = null;
        this.hookMsg = null;
        this.msg = null;
        this.keyboard = null;
        this.modalDialog = null;
        this.modalShells = null;
        this.data = null;
        this.keys = null;
        this.values = null;
        this.popups = null;
        this.bars = null;
        this.timerIds = null;
        this.lastHittestControl = null;
        this.toolDisabledImageList = null;
        this.toolHotImageList = null;
        this.toolImageList = null;
        this.imageList = null;
        this.timerList = null;
        this.tableBuffer = null;
        this.filterTable = null;
        this.eventTable = null;
        this.items = null;
        this.clickRect = null;
        this.monitors = null;
        this.touchSources = null;
        this.threadId = 0;
    }

    void releaseImageList(ImageList list) {
        int i = 0;
        int length = this.imageList.length;
        while (i < length) {
            if (this.imageList[i] == list) {
                if (list.removeRef() > 0) {
                    return;
                }
                list.dispose();
                System.arraycopy(this.imageList, i + 1, this.imageList, i, --length - i);
                this.imageList[length] = null;
                int j = 0;
                while (j < length) {
                    if (this.imageList[j] != null) {
                        return;
                    }
                    ++j;
                }
                this.imageList = null;
                return;
            }
            ++i;
        }
    }

    void releaseToolImageList(ImageList list) {
        int i = 0;
        int length = this.toolImageList.length;
        while (i < length) {
            if (this.toolImageList[i] == list) {
                if (list.removeRef() > 0) {
                    return;
                }
                list.dispose();
                System.arraycopy(this.toolImageList, i + 1, this.toolImageList, i, --length - i);
                this.toolImageList[length] = null;
                int j = 0;
                while (j < length) {
                    if (this.toolImageList[j] != null) {
                        return;
                    }
                    ++j;
                }
                this.toolImageList = null;
                return;
            }
            ++i;
        }
    }

    void releaseToolHotImageList(ImageList list) {
        int i = 0;
        int length = this.toolHotImageList.length;
        while (i < length) {
            if (this.toolHotImageList[i] == list) {
                if (list.removeRef() > 0) {
                    return;
                }
                list.dispose();
                System.arraycopy(this.toolHotImageList, i + 1, this.toolHotImageList, i, --length - i);
                this.toolHotImageList[length] = null;
                int j = 0;
                while (j < length) {
                    if (this.toolHotImageList[j] != null) {
                        return;
                    }
                    ++j;
                }
                this.toolHotImageList = null;
                return;
            }
            ++i;
        }
    }

    void releaseToolDisabledImageList(ImageList list) {
        int i = 0;
        int length = this.toolDisabledImageList.length;
        while (i < length) {
            if (this.toolDisabledImageList[i] == list) {
                if (list.removeRef() > 0) {
                    return;
                }
                list.dispose();
                System.arraycopy(this.toolDisabledImageList, i + 1, this.toolDisabledImageList, i, --length - i);
                this.toolDisabledImageList[length] = null;
                int j = 0;
                while (j < length) {
                    if (this.toolDisabledImageList[j] != null) {
                        return;
                    }
                    ++j;
                }
                this.toolDisabledImageList = null;
                return;
            }
            ++i;
        }
    }

    public void removeFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(eventType, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    void removeBar(Menu menu) {
        if (this.bars == null) {
            return;
        }
        int i = 0;
        while (i < this.bars.length) {
            if (this.bars[i] == menu) {
                this.bars[i] = null;
                return;
            }
            ++i;
        }
    }

    Control removeControl(long handle) {
        Control control = this.controlByHandle.remove(handle);
        return control;
    }

    void removeMenuItem(MenuItem item) {
        if (this.items == null) {
            return;
        }
        this.items[item.id - 108] = null;
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        int i = 0;
        while (i < this.popups.length) {
            if (this.popups[i] == menu) {
                this.popups[i] = null;
                return;
            }
            ++i;
        }
    }

    boolean runAsyncMessages(boolean all) {
        return this.synchronizer.runAsyncMessages(all);
    }

    boolean runDeferredEvents() {
        boolean run = false;
        while (this.eventQueue != null) {
            Widget item;
            Event event = this.eventQueue[0];
            if (event == null) break;
            int length = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --length);
            this.eventQueue[length] = null;
            Widget widget = event.widget;
            if (widget == null || widget.isDisposed() || (item = event.item) != null && item.isDisposed()) continue;
            run = true;
            widget.sendEvent(event);
        }
        this.eventQueue = null;
        return run;
    }

    boolean runDeferredLayouts() {
        if (this.layoutDeferredCount != 0) {
            Composite[] temp = this.layoutDeferred;
            int count = this.layoutDeferredCount;
            this.layoutDeferred = null;
            this.layoutDeferredCount = 0;
            int i = 0;
            while (i < count) {
                Composite comp = temp[i];
                if (!comp.isDisposed()) {
                    comp.setLayoutDeferred(false);
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    boolean runPopups() {
        if (this.popups == null) {
            return false;
        }
        boolean result = false;
        while (this.popups != null) {
            Menu menu = this.popups[0];
            if (menu == null) break;
            int length = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --length);
            this.popups[length] = null;
            this.runDeferredEvents();
            if (!menu.isDisposed()) {
                menu._setVisible(true);
            }
            result = true;
        }
        this.popups = null;
        return result;
    }

    void runSettings() {
        Font oldFont = this.getSystemFont();
        this.saveResources();
        this.sendEvent(39, null);
        Font newFont = this.getSystemFont();
        boolean sameFont = oldFont.equals(newFont);
        Shell[] shellArray = this.getShells();
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            if (!shell.isDisposed()) {
                if (!sameFont) {
                    shell.updateFont(oldFont, newFont);
                }
                shell.layout(true, true);
            }
            ++n2;
        }
    }

    boolean runSkin() {
        if (this.skinCount > 0) {
            Widget[] oldSkinWidgets = this.skinList;
            int count = this.skinCount;
            this.skinList = new Widget[1024];
            this.skinCount = 0;
            if (this.eventTable != null && this.eventTable.hooks(45)) {
                int i = 0;
                while (i < count) {
                    Widget widget = oldSkinWidgets[i];
                    if (widget != null && !widget.isDisposed()) {
                        widget.state &= 0xFFDFFFFF;
                        oldSkinWidgets[i] = null;
                        Event event = new Event();
                        event.widget = widget;
                        this.sendEvent(45, event);
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    boolean runTimer(long id) {
        if (this.timerList != null && this.timerIds != null) {
            int index = 0;
            while (index < this.timerIds.length) {
                if (this.timerIds[index] == id) {
                    OS.KillTimer(this.hwndMessage, this.timerIds[index]);
                    this.timerIds[index] = 0L;
                    Runnable runnable = this.timerList[index];
                    this.timerList[index] = null;
                    if (runnable != null) {
                        try {
                            runnable.run();
                        }
                        catch (RuntimeException exception) {
                            this.runtimeExceptionHandler.accept(exception);
                        }
                        catch (Error exception) {
                            this.errorHandler.accept(exception);
                        }
                    }
                    return true;
                }
                ++index;
            }
        }
        return false;
    }

    void saveResources() {
        int resourceCount = 0;
        if (this.resources == null) {
            this.resources = new Resource[27];
        } else {
            resourceCount = this.resources.length;
            Resource[] newResources = new Resource[resourceCount + 27];
            System.arraycopy(this.resources, 0, newResources, 0, resourceCount);
            this.resources = newResources;
        }
        if (this.systemFont != null) {
            NONCLIENTMETRICS info = new NONCLIENTMETRICS();
            info.cbSize = NONCLIENTMETRICS.sizeof;
            if (OS.SystemParametersInfo(41, 0, info, 0)) {
                LOGFONT logFont = info.lfMessageFont;
                if (this.lfSystemFont == null || logFont.lfCharSet != this.lfSystemFont.lfCharSet || logFont.lfHeight != this.lfSystemFont.lfHeight || logFont.lfWidth != this.lfSystemFont.lfWidth || logFont.lfEscapement != this.lfSystemFont.lfEscapement || logFont.lfOrientation != this.lfSystemFont.lfOrientation || logFont.lfWeight != this.lfSystemFont.lfWeight || logFont.lfItalic != this.lfSystemFont.lfItalic || logFont.lfUnderline != this.lfSystemFont.lfUnderline || logFont.lfStrikeOut != this.lfSystemFont.lfStrikeOut || logFont.lfCharSet != this.lfSystemFont.lfCharSet || logFont.lfOutPrecision != this.lfSystemFont.lfOutPrecision || logFont.lfClipPrecision != this.lfSystemFont.lfClipPrecision || logFont.lfQuality != this.lfSystemFont.lfQuality || logFont.lfPitchAndFamily != this.lfSystemFont.lfPitchAndFamily || !this.getFontName(logFont).equals(this.getFontName(this.lfSystemFont))) {
                    this.resources[resourceCount++] = this.systemFont;
                    this.lfSystemFont = logFont;
                    this.systemFont = null;
                }
            }
        }
        if (this.errorImage != null) {
            this.resources[resourceCount++] = this.errorImage;
        }
        if (this.infoImage != null) {
            this.resources[resourceCount++] = this.infoImage;
        }
        if (this.questionImage != null) {
            this.resources[resourceCount++] = this.questionImage;
        }
        if (this.warningIcon != null) {
            this.resources[resourceCount++] = this.warningIcon;
        }
        this.warningIcon = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        int i = 0;
        while (i < this.cursors.length) {
            if (this.cursors[i] != null) {
                this.resources[resourceCount++] = this.cursors[i];
            }
            this.cursors[i] = null;
            ++i;
        }
        if (resourceCount < 27) {
            Resource[] newResources = new Resource[resourceCount];
            System.arraycopy(this.resources, 0, newResources, 0, resourceCount);
            this.resources = newResources;
        }
    }

    private void sendJDKInternalEvent(int eventType) {
        this.sendJDKInternalEvent(eventType, 0);
    }

    private void sendJDKInternalEvent(int eventType, int detail) {
        if (this.eventTable == null || !this.eventTable.hooks(eventType)) {
            return;
        }
        Event event = new Event();
        event.detail = detail;
        event.display = this;
        event.type = eventType;
        event.time = (int)(System.nanoTime() / 1000000L);
        if (!this.filterEvent(event)) {
            this.sendEvent(this.eventTable, event);
        }
    }

    void sendEvent(int eventType, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = eventType;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.sendEvent(this.eventTable, event);
        }
    }

    void sendEvent(EventTable eventTable, Event event) {
        int type = event.type;
        this.sendPreEvent(type);
        try {
            eventTable.sendEvent(event);
        }
        finally {
            this.sendPostEvent(type);
        }
    }

    void sendPreEvent(int eventType) {
        if (eventType != 50 && eventType != 51 && eventType != 52 && eventType != 53) {
            this.sendJDKInternalEvent(50, eventType);
        }
    }

    void sendPostEvent(int eventType) {
        if (eventType != 50 && eventType != 51 && eventType != 52 && eventType != 53) {
            this.sendJDKInternalEvent(51, eventType);
        }
    }

    public void sendPreExternalEventDispatchEvent() {
        this.sendJDKInternalEvent(52);
    }

    public void sendPostExternalEventDispatchEvent() {
        this.sendJDKInternalEvent(53);
    }

    public void setCursorLocation(int x, int y) {
        this.checkDevice();
        this.setCursorLocationInPixels(DPIUtil.autoScaleUp(x), DPIUtil.autoScaleUp(y));
    }

    void setCursorLocationInPixels(int x, int y) {
        OS.SetCursorPos(x, y);
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    boolean _toBoolean(Object value) {
        return value != null && (Boolean)value != false;
    }

    int _toColorPixel(Object value) {
        if (value == null) {
            return -1;
        }
        return ((Color)value).handle;
    }

    public void setData(String key, Object value) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        switch (key) {
            case "org.eclipse.swt.internal.win32.runMessagesInIdle": {
                this.runMessagesInIdle = this._toBoolean(value);
                return;
            }
            case "org.eclipse.swt.internal.win32.runMessagesInMessageProc": {
                this.runMessagesInMessageProc = this._toBoolean(value);
                return;
            }
            case "org.eclipse.swt.internal.win32.useOwnDC": {
                this.useOwnDC = this._toBoolean(value);
                return;
            }
            case "org.eclipse.swt.internal.win32.accelKeyHit": {
                this.accelKeyHit = this._toBoolean(value);
                return;
            }
            case "org.eclipse.swt.internal.win32.externalEventLoop": {
                this.externalEventLoop = this._toBoolean(value);
                return;
            }
            case "org.eclipse.swt.internal.win32.useDarkModeExplorerTheme": {
                boolean bl = this.useDarkModeExplorerTheme = this._toBoolean(value) && !disableCustomThemeTweaks && OS.IsDarkModeAvailable();
                if (this.useDarkModeExplorerTheme) {
                    OS.SetPreferredAppMode(2);
                } else {
                    OS.SetPreferredAppMode(0);
                }
                return;
            }
            case "org.eclipse.swt.internal.win32.useShellTitleColoring": {
                this.useShellTitleColoring = !disableCustomThemeTweaks && this._toBoolean(value);
                return;
            }
            case "org.eclipse.swt.internal.win32.menuBarForegroundColor": {
                this.menuBarForegroundPixel = disableCustomThemeTweaks ? -1 : this._toColorPixel(value);
                return;
            }
            case "org.eclipse.swt.internal.win32.menuBarBackgroundColor": {
                this.menuBarBackgroundPixel = disableCustomThemeTweaks ? -1 : this._toColorPixel(value);
                return;
            }
            case "org.eclipse.swt.internal.win32.menuBarBorderColor": {
                if (this.menuBarBorderPen != 0L) {
                    OS.DeleteObject(this.menuBarBorderPen);
                }
                int pixel = this._toColorPixel(value);
                this.menuBarBorderPen = disableCustomThemeTweaks || pixel == -1 ? 0L : OS.CreatePen(0, 1, pixel);
                return;
            }
            case "org.eclipse.swt.internal.win32.all.use_WS_BORDER": {
                this.useWsBorderAll = !disableCustomThemeTweaks && this._toBoolean(value);
                return;
            }
            case "org.eclipse.swt.internal.win32.Canvas.use_WS_BORDER": {
                this.useWsBorderCanvas = !disableCustomThemeTweaks && this._toBoolean(value);
                return;
            }
            case "org.eclipse.swt.internal.win32.Label.use_WS_BORDER": {
                this.useWsBorderLabel = !disableCustomThemeTweaks && this._toBoolean(value);
                return;
            }
            case "org.eclipse.swt.internal.win32.List.use_WS_BORDER": {
                this.useWsBorderList = !disableCustomThemeTweaks && this._toBoolean(value);
                return;
            }
            case "org.eclipse.swt.internal.win32.Table.use_WS_BORDER": {
                this.useWsBorderTable = !disableCustomThemeTweaks && this._toBoolean(value);
                return;
            }
            case "org.eclipse.swt.internal.win32.Text.use_WS_BORDER": {
                this.useWsBorderText = !disableCustomThemeTweaks && this._toBoolean(value);
                return;
            }
            case "org.eclipse.swt.internal.win32.Table.headerLineColor": {
                this.tableHeaderLinePixel = disableCustomThemeTweaks ? -1 : this._toColorPixel(value);
                return;
            }
            case "org.eclipse.swt.internal.win32.Label.disabledForegroundColor": {
                this.disabledLabelForegroundPixel = disableCustomThemeTweaks ? -1 : this._toColorPixel(value);
                break;
            }
            case "org.eclipse.swt.internal.win32.Combo.useDarkTheme": {
                this.comboUseDarkTheme = this._toBoolean(value) && !disableCustomThemeTweaks && OS.IsDarkModeAvailable();
                break;
            }
            case "org.eclipse.swt.internal.win32.ProgressBar.useColors": {
                this.progressbarUseColors = !disableCustomThemeTweaks && this._toBoolean(value);
                break;
            }
            case "org.eclipse.swt.internal.win32.Text.useDarkThemeIcons": {
                boolean bl = this.textUseDarkthemeIcons = !disableCustomThemeTweaks && this._toBoolean(value);
            }
        }
        if (value == null) {
            if (this.keys == null) {
                return;
            }
            int index = 0;
            while (index < this.keys.length && !this.keys[index].equals(key)) {
                ++index;
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                this.values[i] = value;
                return;
            }
            ++i;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    public void setData(Object data) {
        this.checkDevice();
        this.data = data;
    }

    public static String getAppName() {
        return APP_NAME;
    }

    public static String getAppVersion() {
        return APP_VERSION;
    }

    public static void setAppName(String name) {
        APP_NAME = name;
    }

    public static void setAppVersion(String version) {
        APP_VERSION = version;
    }

    void setModalDialog(Dialog modalDailog) {
        this.modalDialog = modalDailog;
        Shell[] shellArray = this.getShells();
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            shell.updateModal();
            ++n2;
        }
    }

    void setModalShell(Shell shell) {
        if (this.modalShells == null) {
            this.modalShells = new Shell[4];
        }
        int index = 0;
        int length = this.modalShells.length;
        while (index < length) {
            if (this.modalShells[index] == shell) {
                return;
            }
            if (this.modalShells[index] == null) break;
            ++index;
        }
        if (index == length) {
            Shell[] newModalShells = new Shell[length + 4];
            System.arraycopy(this.modalShells, 0, newModalShells, 0, length);
            this.modalShells = newModalShells;
        }
        this.modalShells[index] = shell;
        Shell[] shellArray = this.getShells();
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell activeShell = shellArray[n2];
            activeShell.updateModal();
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (synchronizer == this.synchronizer) {
            return;
        }
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            Synchronizer oldSynchronizer = this.synchronizer;
            this.synchronizer = synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (oldSynchronizer != null) {
                oldSynchronizer.moveAllEventsTo(synchronizer);
            }
            return;
        }
    }

    public final void setRuntimeExceptionHandler(Consumer<RuntimeException> runtimeExceptionHandler) {
        this.checkDevice();
        this.runtimeExceptionHandler = Objects.requireNonNull(runtimeExceptionHandler);
    }

    public final Consumer<RuntimeException> getRuntimeExceptionHandler() {
        return this.runtimeExceptionHandler;
    }

    public final void setErrorHandler(Consumer<Error> errorHandler) {
        this.checkDevice();
        this.errorHandler = Objects.requireNonNull(errorHandler);
    }

    public final Consumer<Error> getErrorHandler() {
        return this.errorHandler;
    }

    int shiftedKey(int key) {
        int i = 0;
        while (i < this.keyboard.length) {
            this.keyboard[i] = 0;
            ++i;
        }
        this.keyboard[16] = (byte)(this.keyboard[16] | 0x80);
        char[] result = new char[1];
        if (OS.ToUnicode(key, key, this.keyboard, result, 1, 0) == 1) {
            return result[0];
        }
        return 0;
    }

    public boolean sleep() {
        this.checkDevice();
        if (!this.synchronizer.isMessagesEmpty()) {
            return true;
        }
        this.sendPreExternalEventDispatchEvent();
        boolean result = OS.WaitMessage();
        this.sendPostExternalEventDispatchEvent();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable runnable) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Synchronizer synchronizer = this.synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            synchronizer.syncExec(runnable);
            return;
        }
    }

    public <T, E extends Exception> T syncCall(SwtCallable<T, E> callable) throws E {
        Objects.nonNull(callable);
        Object[] t = new Object[1];
        Object[] ex = new Object[1];
        this.syncExec(() -> {
            try {
                objectArray[0] = callable.call();
            }
            catch (Exception e) {
                objectArray2[0] = e;
            }
        });
        if (ex[0] != null) {
            Exception e = (Exception)ex[0];
            throw e;
        }
        return (T)t[0];
    }

    public void timerExec(int milliseconds, Runnable runnable) {
        long newTimerID;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerIds == null) {
            this.timerIds = new long[4];
        }
        int index = 0;
        while (index < this.timerList.length) {
            if (this.timerList[index] == runnable) break;
            ++index;
        }
        long timerId = 0L;
        if (index != this.timerList.length) {
            timerId = this.timerIds[index];
            if (milliseconds < 0) {
                OS.KillTimer(this.hwndMessage, timerId);
                this.timerList[index] = null;
                this.timerIds[index] = 0L;
                return;
            }
        } else {
            if (milliseconds < 0) {
                return;
            }
            index = 0;
            while (index < this.timerList.length) {
                if (this.timerList[index] == null) break;
                ++index;
            }
            timerId = this.nextTimerId++;
            if (index == this.timerList.length) {
                Runnable[] newTimerList = new Runnable[this.timerList.length + 4];
                System.arraycopy(this.timerList, 0, newTimerList, 0, this.timerList.length);
                this.timerList = newTimerList;
                long[] newTimerIds = new long[this.timerIds.length + 4];
                System.arraycopy(this.timerIds, 0, newTimerIds, 0, this.timerIds.length);
                this.timerIds = newTimerIds;
            }
        }
        if ((newTimerID = OS.SetTimer(this.hwndMessage, timerId, milliseconds, 0L)) != 0L) {
            this.timerList[index] = runnable;
            this.timerIds[index] = newTimerID;
        }
    }

    boolean translateAccelerator(MSG msg, Control control) {
        this.accelKeyHit = true;
        boolean result = control.translateAccelerator(msg);
        this.accelKeyHit = false;
        return result;
    }

    static int translateKey(int key) {
        int[][] nArray = KeyTable;
        int n = KeyTable.length;
        int n2 = 0;
        while (n2 < n) {
            int[] element = nArray[n2];
            if (element[0] == key) {
                return element[1];
            }
            ++n2;
        }
        return 0;
    }

    boolean translateMnemonic(MSG msg, Control control) {
        switch (msg.message) {
            case 258: 
            case 262: {
                return control.translateMnemonic(msg);
            }
        }
        return false;
    }

    boolean translateTraversal(MSG msg, Control control) {
        switch (msg.message) {
            case 256: {
                switch ((int)msg.wParam) {
                    case 9: 
                    case 13: 
                    case 27: 
                    case 33: 
                    case 34: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        return control.translateTraversal(msg);
                    }
                }
                break;
            }
            case 260: {
                switch ((int)msg.wParam) {
                    case 18: {
                        return control.translateTraversal(msg);
                    }
                }
            }
        }
        return false;
    }

    static int untranslateKey(int key) {
        int[][] nArray = KeyTable;
        int n = KeyTable.length;
        int n2 = 0;
        while (n2 < n) {
            int[] element = nArray[n2];
            if (element[1] == key) {
                return element[0];
            }
            ++n2;
        }
        return 0;
    }

    public void update() {
        this.checkDevice();
        if (OS.IsHungAppWindow(this.hwndMessage)) {
            MSG msg = new MSG();
            int flags = 3;
            OS.PeekMessage(msg, this.hwndMessage, 32773, 32773, flags);
        }
        Shell[] shellArray = this.getShells();
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            if (!shell.isDisposed()) {
                shell.update(true);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (this.thread == Thread.currentThread()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.wakeThread();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void wakeThread() {
        OS.PostThreadMessage(this.threadId, 0, 0L, 0L);
    }

    long windowProc(long hwnd, long msg, long wParam, long lParam) {
        Control control = this.getControl(hwnd);
        if (control != null) {
            return control.windowProc(hwnd, (int)msg, wParam, lParam);
        }
        return OS.DefWindowProc(hwnd, (int)msg, wParam, lParam);
    }

    int textWidth(String text, long handle) {
        long oldFont = 0L;
        RECT rect = new RECT();
        long hDC = OS.GetDC(handle);
        long newFont = OS.SendMessage(handle, 49, 0L, 0L);
        if (newFont != 0L) {
            oldFont = OS.SelectObject(hDC, newFont);
        }
        int flags = 3104;
        char[] buffer = text.toCharArray();
        OS.DrawText(hDC, buffer, buffer.length, rect, flags);
        if (newFont != 0L) {
            OS.SelectObject(hDC, oldFont);
        }
        OS.ReleaseDC(handle, hDC);
        return rect.right - rect.left;
    }

    String wrapText(String text, long handle, int width) {
        String Lf = "\r\n";
        text = Display.withCrLf(text);
        int length = text.length();
        if (width <= 0 || length == 0 || length == 1) {
            return text;
        }
        StringBuilder result = new StringBuilder();
        int lineStart = 0;
        int lineEnd = 0;
        while (lineStart < length) {
            boolean noLf;
            lineEnd = text.indexOf(Lf, lineStart);
            boolean bl = noLf = lineEnd == -1;
            if (noLf) {
                lineEnd = length;
            }
            int nextStart = lineEnd + Lf.length();
            while (lineEnd > lineStart + 1 && Character.isWhitespace(text.charAt(lineEnd - 1))) {
                --lineEnd;
            }
            int wordStart = lineStart;
            int wordEnd = lineStart;
            int i = lineStart;
            while (i < lineEnd) {
                int lastStart = wordStart;
                int lastEnd = wordEnd;
                wordStart = i;
                while (i < lineEnd && !Character.isWhitespace(text.charAt(i))) {
                    ++i;
                }
                wordEnd = i - 1;
                String line = text.substring(lineStart, wordEnd + 1);
                int lineWidth = this.textWidth(line, handle);
                while (i < lineEnd && Character.isWhitespace(text.charAt(i))) {
                    ++i;
                }
                if (lineWidth <= width) continue;
                if (lastStart == wordStart) {
                    while (wordStart < wordEnd) {
                        line = text.substring(lineStart, wordStart + 1);
                        lineWidth = this.textWidth(line, handle);
                        if (lineWidth >= width) break;
                        ++wordStart;
                    }
                    if (wordStart == lastStart) {
                        ++wordStart;
                    }
                    lastEnd = wordStart - 1;
                }
                line = text.substring(lineStart, lastEnd + 1);
                result.append(line);
                result.append(Lf);
                i = wordStart;
                lineStart = wordStart;
                wordEnd = wordStart;
            }
            if (lineStart < lineEnd) {
                result.append(text.substring(lineStart, lineEnd));
            }
            if (!noLf) {
                result.append(Lf);
            }
            lineStart = nextStart;
        }
        return result.toString();
    }

    static String withCrLf(String string) {
        int length = string.length();
        if (length == 0) {
            return string;
        }
        int i = string.indexOf(10, 0);
        if (i == -1) {
            return string;
        }
        if (i > 0 && string.charAt(i - 1) == '\r') {
            return string;
        }
        ++i;
        int count = 1;
        while (i < length) {
            if ((i = string.indexOf(10, i)) == -1) break;
            ++count;
            ++i;
        }
        i = 0;
        StringBuilder result = new StringBuilder(count += length);
        while (i < length) {
            int j = string.indexOf(10, i);
            if (j == -1) {
                j = length;
            }
            result.append(string.substring(i, j));
            i = j;
            if (i >= length) continue;
            result.append("\r\n");
            ++i;
        }
        return result.toString();
    }

    static char[] withCrLf(char[] string) {
        int length = string.length;
        if (length == 0) {
            return string;
        }
        int count = 0;
        int i = 0;
        while (i < string.length) {
            if (string[i] == '\n' && ++count == 1 && i > 0 && string[i - 1] == '\r') {
                return string;
            }
            ++i;
        }
        if (count == 0) {
            return string;
        }
        char[] result = new char[count += length];
        int i2 = 0;
        int j = 0;
        while (i2 < length && j < count) {
            if (string[i2] == '\n') {
                result[j++] = 13;
            }
            result[j++] = string[i2];
            ++i2;
        }
        return result;
    }
}

