/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import java.util.Map;
import org.eclipse.core.databinding.beans.IBeanMapProperty;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.map.IMapProperty;
import org.eclipse.core.databinding.property.map.MapProperty;
import org.eclipse.core.internal.databinding.beans.BeanObservableMapDecorator;

public class BeanMapPropertyDecorator<S, K, V>
extends MapProperty<S, K, V>
implements IBeanMapProperty<S, K, V> {
    private final IMapProperty<S, K, V> delegate;
    private final PropertyDescriptor propertyDescriptor;

    public BeanMapPropertyDecorator(IMapProperty<S, K, V> delegate, PropertyDescriptor propertyDescriptor) {
        this.delegate = delegate;
        this.propertyDescriptor = propertyDescriptor;
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public Object getKeyType() {
        return this.delegate.getKeyType();
    }

    public Object getValueType() {
        return this.delegate.getValueType();
    }

    protected Map<K, V> doGetMap(S source) {
        return this.delegate.getMap(source);
    }

    protected void doSetMap(S source, Map<K, V> map) {
        this.delegate.setMap(source, map);
    }

    protected void doUpdateMap(S source, MapDiff<K, V> diff) {
        this.delegate.updateMap(source, diff);
    }

    @Override
    public <V2> IBeanMapProperty<S, K, V2> values(String propertyName) {
        return this.values(propertyName, null);
    }

    @Override
    public <V2> IBeanMapProperty<S, K, V2> values(String propertyName, Class<V2> valueType) {
        Class beanClass = (Class)this.delegate.getValueType();
        return this.values(BeanProperties.value(beanClass, propertyName, valueType));
    }

    @Override
    public <V2> IBeanMapProperty<S, K, V2> values(IBeanValueProperty<? super V, V2> property) {
        return new BeanMapPropertyDecorator<S, K, V>(super.values(property), property.getPropertyDescriptor());
    }

    public IObservableMap<K, V> observe(S source) {
        return new BeanObservableMapDecorator(this.delegate.observe(source), this.propertyDescriptor);
    }

    public IObservableMap<K, V> observe(Realm realm, S source) {
        return new BeanObservableMapDecorator(this.delegate.observe(realm, source), this.propertyDescriptor);
    }

    public <U extends S> IObservableMap<K, V> observeDetail(IObservableValue<U> master) {
        return new BeanObservableMapDecorator(this.delegate.observeDetail(master), this.propertyDescriptor);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

