/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.win32.CHOOSEFONT;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;
    boolean effectsVisible = true;

    public FontDialog(Shell parent) {
        this(parent, 65536);
    }

    public FontDialog(Shell parent, int style) {
        super(parent, FontDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    public boolean getEffectsVisible() {
        return this.effectsVisible;
    }

    @Deprecated
    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] result = new FontData[]{this.fontData};
        return result;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        long hwndOwner = this.parent.handle;
        long hwndParent = this.parent.handle;
        boolean enabled = false;
        int dialogOrientation = this.style & 0x6000000;
        int parentOrientation = this.parent.style & 0x6000000;
        if (dialogOrientation != parentOrientation) {
            int exStyle = 0x100000;
            if (dialogOrientation == 0x4000000) {
                exStyle |= 0x400000;
            }
            hwndOwner = OS.CreateWindowEx(exStyle, Shell.DialogClass, null, 0, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, hwndParent, 0L, OS.GetModuleHandle(null), null);
            enabled = OS.IsWindowEnabled(hwndParent);
            if (enabled) {
                OS.EnableWindow(hwndParent, false);
            }
        }
        long hHeap = OS.GetProcessHeap();
        CHOOSEFONT lpcf = new CHOOSEFONT();
        lpcf.lStructSize = CHOOSEFONT.sizeof;
        lpcf.hwndOwner = hwndOwner;
        lpcf.Flags = 1;
        if (this.effectsVisible) {
            lpcf.Flags |= 0x100;
        }
        long lpLogFont = OS.HeapAlloc(hHeap, 8, LOGFONT.sizeof);
        if (this.fontData != null && this.fontData.data != null) {
            LOGFONT logFont = this.fontData.data;
            int lfHeight = logFont.lfHeight;
            long hDC = OS.GetDC(0L);
            int pixels = -((int)(0.5f + this.fontData.height * (float)OS.GetDeviceCaps(hDC, 90) / 72.0f));
            OS.ReleaseDC(0L, hDC);
            logFont.lfHeight = pixels;
            lpcf.Flags |= 0x40;
            OS.MoveMemory(lpLogFont, logFont, LOGFONT.sizeof);
            logFont.lfHeight = lfHeight;
        }
        lpcf.lpLogFont = lpLogFont;
        if (this.rgb != null) {
            int red = this.rgb.red & 0xFF;
            int green = this.rgb.green << 8 & 0xFF00;
            int blue = this.rgb.blue << 16 & 0xFF0000;
            lpcf.rgbColors = red | green | blue;
        }
        Dialog oldModal = null;
        Display display = this.parent.getDisplay();
        if ((this.style & 0x30000) != 0) {
            oldModal = display.getModalDialog();
            display.setModalDialog(this);
        }
        display.externalEventLoop = true;
        display.sendPreExternalEventDispatchEvent();
        long currentDpiAwarenessContext = OS.GetThreadDpiAwarenessContext();
        boolean success = false;
        try {
            if (display.isRescalingAtRuntime()) {
                currentDpiAwarenessContext = OS.SetThreadDpiAwarenessContext(1073766416L);
            }
            success = OS.ChooseFont(lpcf);
            display.externalEventLoop = false;
            display.sendPostExternalEventDispatchEvent();
            if ((this.style & 0x30000) != 0) {
                display.setModalDialog(oldModal);
            }
            if (success) {
                LOGFONT logFont = new LOGFONT();
                OS.MoveMemory(logFont, lpLogFont, LOGFONT.sizeof);
                long hDC = OS.GetDC(0L);
                int logPixelsY = OS.GetDeviceCaps(hDC, 90);
                int pixels = 0;
                if (logFont.lfHeight > 0) {
                    long hFont = OS.CreateFontIndirect(logFont);
                    long oldFont = OS.SelectObject(hDC, hFont);
                    TEXTMETRIC lptm = new TEXTMETRIC();
                    OS.GetTextMetrics(hDC, lptm);
                    OS.SelectObject(hDC, oldFont);
                    OS.DeleteObject(hFont);
                    pixels = logFont.lfHeight - lptm.tmInternalLeading;
                } else {
                    pixels = -logFont.lfHeight;
                }
                OS.ReleaseDC(0L, hDC);
                float points = (float)pixels * 72.0f / (float)logPixelsY;
                this.fontData = FontData.win32_new(logFont, points);
                if (this.effectsVisible) {
                    int red = lpcf.rgbColors & 0xFF;
                    int green = lpcf.rgbColors >> 8 & 0xFF;
                    int blue = lpcf.rgbColors >> 16 & 0xFF;
                    this.rgb = new RGB(red, green, blue);
                }
            }
        }
        finally {
            if (display.isRescalingAtRuntime()) {
                OS.SetThreadDpiAwarenessContext(currentDpiAwarenessContext);
            }
            if (lpLogFont != 0L) {
                OS.HeapFree(hHeap, 0, lpLogFont);
            }
            if (hwndParent != hwndOwner) {
                if (enabled) {
                    OS.EnableWindow(hwndParent, true);
                }
                OS.SetActiveWindow(hwndParent);
                OS.DestroyWindow(hwndOwner);
            }
            if (!success) {
                return null;
            }
        }
        return this.fontData;
    }

    public void setEffectsVisible(boolean visible) {
        this.effectsVisible = visible;
    }

    @Deprecated
    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontData) {
        this.fontData = fontData != null && fontData.length > 0 ? fontData[0] : null;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }
}

