/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.garbagecollector.MarkSet;
import org.eclipse.equinox.internal.p2.garbagecollector.MarkSetProvider;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.WhatIsRunning;
import org.eclipse.equinox.internal.p2.update.Configuration;
import org.eclipse.equinox.internal.p2.update.Feature;
import org.eclipse.equinox.internal.p2.update.Site;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;

public class EclipseMarkSetProvider
extends MarkSetProvider {
    private static final String ARTIFACT_CLASSIFIER_OSGI_BUNDLE = "osgi.bundle";
    private static final String ARTIFACT_CLASSIFIER_FEATURE = "org.eclipse.update.feature";
    private Collection<IArtifactKey> artifactKeyList = null;

    public MarkSet[] getMarkSets(IProvisioningAgent agent, IProfile inProfile) {
        this.artifactKeyList = new HashSet<IArtifactKey>();
        IFileArtifactRepository repositoryToGC = Util.getBundlePoolRepository(agent, inProfile);
        if (repositoryToGC == null) {
            return new MarkSet[0];
        }
        this.addArtifactKeys(inProfile);
        IProfile currentProfile = EclipseMarkSetProvider.getCurrentProfile(agent);
        if (currentProfile != null && inProfile.getProfileId().equals(currentProfile.getProfileId())) {
            this.addRunningBundles((IArtifactRepository)repositoryToGC);
            this.addRunningFeatures(inProfile, (IArtifactRepository)repositoryToGC);
        }
        return new MarkSet[]{new MarkSet(this.artifactKeyList.toArray(new IArtifactKey[this.artifactKeyList.size()]), (IArtifactRepository)repositoryToGC)};
    }

    private void addRunningFeatures(IProfile profile, IArtifactRepository repositoryToGC) {
        try {
            List<Feature> allFeatures = EclipseMarkSetProvider.getAllFeatures(Configuration.load(new File(Util.getConfigurationFolder(profile), "org.eclipse.update/platform.xml"), null));
            for (Feature f : allFeatures) {
                IArtifactKey match = EclipseMarkSetProvider.searchArtifact(f.getId(), Version.create((String)f.getVersion()), ARTIFACT_CLASSIFIER_FEATURE, repositoryToGC);
                if (match == null) continue;
                this.artifactKeyList.add(match);
            }
        }
        catch (ProvisionException provisionException) {
            // empty catch block
        }
    }

    private static List<Feature> getAllFeatures(Configuration cfg) {
        if (cfg == null) {
            return Collections.emptyList();
        }
        List<Site> sites = cfg.getSites();
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (Site object : sites) {
            Feature[] features;
            Feature[] featureArray = features = object.getFeatures();
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                Feature feature = featureArray[n2];
                result.add(feature);
                ++n2;
            }
        }
        return result;
    }

    private static IProfile getCurrentProfile(IProvisioningAgent agent) {
        IProfileRegistry pr = (IProfileRegistry)agent.getService(IProfileRegistry.class);
        if (pr == null) {
            return null;
        }
        return pr.getProfile("_SELF_");
    }

    private void addArtifactKeys(IProfile aProfile) {
        Iterator installableUnits = aProfile.query(QueryUtil.createIUAnyQuery(), null).iterator();
        while (installableUnits.hasNext()) {
            Collection keys = ((IInstallableUnit)installableUnits.next()).getArtifacts();
            if (keys == null) continue;
            this.artifactKeyList.addAll(keys);
        }
    }

    public IArtifactRepository getRepository(IProvisioningAgent agent, IProfile aProfile) {
        return Util.getBundlePoolRepository(agent, aProfile);
    }

    private void addRunningBundles(IArtifactRepository repo) {
        this.artifactKeyList.addAll(EclipseMarkSetProvider.findCorrespondinArtifacts(new WhatIsRunning().getBundlesBeingRun(), repo));
    }

    private static IArtifactKey searchArtifact(String searchedId, Version searchedVersion, String classifier, IArtifactRepository repo) {
        VersionRange range = searchedVersion != null ? new VersionRange(searchedVersion, true, searchedVersion, true) : null;
        ArtifactKeyQuery query = new ArtifactKeyQuery(classifier, searchedId, range);
        IQueryResult keys = repo.query((IQuery)query, null);
        if (!keys.isEmpty()) {
            return (IArtifactKey)keys.iterator().next();
        }
        return null;
    }

    private static List<IArtifactKey> findCorrespondinArtifacts(BundleInfo[] bis, IArtifactRepository repo) {
        ArrayList<IArtifactKey> toRetain = new ArrayList<IArtifactKey>();
        BundleInfo[] bundleInfoArray = bis;
        int n = bis.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo bi = bundleInfoArray[n2];
            Version version = "0.0.0".equals(bi.getVersion()) ? null : Version.create((String)bi.getVersion());
            IArtifactKey match = EclipseMarkSetProvider.searchArtifact(bi.getSymbolicName(), version, ARTIFACT_CLASSIFIER_OSGI_BUNDLE, repo);
            if (match != null) {
                toRetain.add(match);
            }
            ++n2;
        }
        return toRetain;
    }
}

