/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.dialogs.filteredtree;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.ui.dialogs.filteredtree.BasicUIJob;
import org.eclipse.e4.ui.dialogs.filteredtree.PatternFilter;
import org.eclipse.e4.ui.dialogs.textbundles.E4DialogMessages;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.AbstractFilteredViewerComposite;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class FilteredTree
extends AbstractFilteredViewerComposite<PatternFilter> {
    private TreeViewer treeViewer;
    private Job refreshJob;
    private Composite treeComposite;
    private static final long SOFT_MAX_EXPAND_TIME = 200L;
    private static final long DEFAULT_REFRESH_TIME = 200L;
    private String previousFilterText;
    private boolean narrowingDown;

    public FilteredTree(Composite parent, int treeStyle, PatternFilter filter, long refreshDelayTime) {
        super(parent, 0, refreshDelayTime);
        this.parent = this.getParent();
        this.init(treeStyle, filter);
    }

    public FilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
        this(parent, treeStyle, filter, 200L);
    }

    protected FilteredTree(Composite parent) {
        super(parent, 0, 200L);
    }

    protected void init(int treeStyle, PatternFilter filter) {
        this.setShowFilterControls(true);
        super.init(treeStyle, (ViewerFilter)filter);
        this.createRefreshJob();
        this.setInitialText(E4DialogMessages.FilteredTree_FilterMessage);
    }

    protected void createControl(Composite parent, int treeStyle) {
        super.createControl(parent, treeStyle);
        this.treeComposite = new Composite((Composite)this, 0);
        GridLayout treeCompositeLayout = new GridLayout();
        treeCompositeLayout.marginHeight = 0;
        treeCompositeLayout.marginWidth = 0;
        this.treeComposite.setLayout((Layout)treeCompositeLayout);
        GridData data = new GridData(4, 4, true, true);
        this.treeComposite.setLayoutData((Object)data);
        this.createTreeControl(this.treeComposite, treeStyle);
    }

    protected Control createTreeControl(Composite parent, int style) {
        this.treeViewer = this.doCreateTreeViewer(parent, style);
        this.treeViewer.setUseHashlookup(true);
        GridData data = new GridData(4, 4, true, true);
        this.treeViewer.getControl().setLayoutData((Object)data);
        this.treeViewer.getControl().addDisposeListener(e -> {
            boolean bl = this.refreshJob.cancel();
        });
        if (this.treeViewer instanceof NotifyingTreeViewer) {
            this.getPatternFilter().setUseCache(true);
        }
        this.treeViewer.addFilter((ViewerFilter)this.getPatternFilter());
        return this.treeViewer.getControl();
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new NotifyingTreeViewer(parent, style);
    }

    private TreeItem getFirstMatchingItem(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (this.getPatternFilter().isLeafMatch((Viewer)this.treeViewer, item.getData()) && this.getPatternFilter().isElementSelectable(item.getData())) {
                return item;
            }
            TreeItem treeItem = this.getFirstMatchingItem(item.getItems());
            if (treeItem != null) {
                return treeItem;
            }
            ++n2;
        }
        return null;
    }

    private void createRefreshJob() {
        this.refreshJob = this.doCreateRefreshJob();
        this.refreshJob.setSystem(true);
    }

    protected BasicUIJob doCreateRefreshJob() {
        return new BasicUIJob("Refresh Filter", this.getDisplay()){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                boolean initial;
                if (FilteredTree.this.treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                String text = FilteredTree.this.getFilterString();
                if (text == null) {
                    return Status.OK_STATUS;
                }
                boolean bl = initial = FilteredTree.this.initialText != null && FilteredTree.this.initialText.equals(text);
                if (initial) {
                    FilteredTree.this.getPatternFilter().setPattern(null);
                } else if (text != null) {
                    FilteredTree.this.getPatternFilter().setPattern(text);
                }
                Composite redrawFalseControl = FilteredTree.this.treeComposite != null ? FilteredTree.this.treeComposite : FilteredTree.this.treeViewer.getControl();
                try {
                    redrawFalseControl.setRedraw(false);
                    if (!FilteredTree.this.narrowingDown) {
                        TreeItem[] is;
                        TreeItem[] treeItemArray = is = FilteredTree.this.treeViewer.getTree().getItems();
                        int n = is.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem item = treeItemArray[n2];
                            if (item.getExpanded()) {
                                FilteredTree.this.treeViewer.setExpandedState(item.getData(), false);
                            }
                            ++n2;
                        }
                    }
                    FilteredTree.this.treeViewer.refresh(true);
                    if (text.length() > 0 && !initial) {
                        TreeItem[] items = FilteredTree.this.getViewer().getTree().getItems();
                        int treeHeight = FilteredTree.this.getViewer().getTree().getBounds().height;
                        int numVisibleItems = treeHeight / FilteredTree.this.getViewer().getTree().getItemHeight();
                        long stopTime = 200L + System.currentTimeMillis();
                        FilteredTree.this.updateToolbar(true);
                        if (items.length > 0 && this.recursiveExpand(items, monitor, stopTime, new int[]{numVisibleItems})) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                    } else {
                        FilteredTree.this.updateToolbar(false);
                    }
                }
                finally {
                    TreeItem[] items = FilteredTree.this.getViewer().getTree().getItems();
                    if (items.length > 0 && FilteredTree.this.getViewer().getTree().getSelectionCount() == 0) {
                        FilteredTree.this.treeViewer.getTree().setTopItem(items[0]);
                    }
                    redrawFalseControl.setRedraw(true);
                }
                return Status.OK_STATUS;
            }

            private boolean recursiveExpand(TreeItem[] items, IProgressMonitor monitor, long cancelTime, int[] numItemsLeft) {
                boolean canceled = false;
                int i = 0;
                while (!canceled && i < items.length) {
                    boolean visible;
                    TreeItem item = items[i];
                    int n = numItemsLeft[0];
                    numItemsLeft[0] = n - 1;
                    boolean bl = visible = n >= 0;
                    if (monitor.isCanceled() || !visible && System.currentTimeMillis() > cancelTime) {
                        canceled = true;
                    } else {
                        Object itemData = item.getData();
                        if (itemData != null) {
                            if (!item.getExpanded()) {
                                FilteredTree.this.treeViewer.setExpandedState(itemData, true);
                            }
                            TreeItem[] children = item.getItems();
                            if (items.length > 0) {
                                canceled = this.recursiveExpand(children, monitor, cancelTime, numItemsLeft);
                            }
                        }
                    }
                    ++i;
                }
                return canceled;
            }
        };
    }

    protected void updateToolbar(boolean visible) {
    }

    protected void createFilterText(Composite parent) {
        super.createFilterText(parent);
        this.filterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String filterTextString = FilteredTree.this.filterText.getText();
                e.result = filterTextString.isEmpty() || filterTextString.equals(FilteredTree.this.initialText) ? FilteredTree.this.initialText : NLS.bind((String)E4DialogMessages.FilteredTree_AccessibleListenerFiltered, (Object[])new String[]{filterTextString, String.valueOf(this.getFilteredItemsCount())});
            }

            private int getFilteredItemsCount() {
                TreeItem[] items;
                int total = 0;
                TreeItem[] treeItemArray = items = FilteredTree.this.getViewer().getTree().getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    total += this.itemCount(item);
                    ++n2;
                }
                return total;
            }

            private int itemCount(TreeItem treeItem) {
                TreeItem[] children;
                int count = 1;
                TreeItem[] treeItemArray = children = treeItem.getItems();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem element = treeItemArray[n2];
                    count += this.itemCount(element);
                    ++n2;
                }
                return count;
            }
        });
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean hasItems;
                boolean bl = hasItems = FilteredTree.this.getViewer().getTree().getItemCount() > 0;
                if (hasItems && e.keyCode == 0x1000002) {
                    FilteredTree.this.treeViewer.getTree().setFocus();
                    return;
                }
            }
        });
        this.filterText.addTraverseListener(e -> {
            if (e.detail == 4) {
                Tree tree;
                TreeItem item;
                boolean textChanged;
                e.doit = false;
                if (this.getViewer().getTree().getItemCount() == 0) {
                    return;
                }
                boolean hasFocus = this.getViewer().getTree().setFocus();
                boolean bl = textChanged = !this.getInitialText().equals(this.filterText.getText().trim());
                if (hasFocus && textChanged && this.filterText.getText().trim().length() > 0 && (item = (tree = this.getViewer().getTree()).getSelectionCount() > 0 ? this.getFirstMatchingItem(tree.getSelection()) : this.getFirstMatchingItem(tree.getItems())) != null) {
                    tree.setSelection(new TreeItem[]{item});
                    ISelection sel = this.getViewer().getSelection();
                    this.getViewer().setSelection(sel, true);
                }
            }
        });
    }

    protected Text doCreateFilterText(Composite parent) {
        return new Text(parent, 2948);
    }

    protected void textChanged() {
        this.narrowingDown = this.previousFilterText == null || this.previousFilterText.equals(E4DialogMessages.FilteredTree_FilterMessage) || this.getFilterString().startsWith(this.previousFilterText);
        this.previousFilterText = this.getFilterString();
        this.refreshJob.cancel();
        this.refreshJob.schedule(this.getRefreshJobDelay());
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        if (this.filterComposite != null) {
            this.filterComposite.setBackground(background);
        }
    }

    public final PatternFilter getPatternFilter() {
        return (PatternFilter)super.getPatternFilter();
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public static Font getBoldFont(Object element, FilteredTree tree, PatternFilter filter) {
        String filterText = tree.getFilterString();
        if (filterText == null) {
            return null;
        }
        String initialText = tree.getInitialText();
        if (!filterText.isEmpty() && !filterText.equals(initialText)) {
            if (tree.getPatternFilter() != filter) {
                boolean initial;
                boolean bl = initial = initialText != null && initialText.equals(filterText);
                if (initial) {
                    filter.setPattern(null);
                } else if (filterText != null) {
                    filter.setPattern(filterText);
                }
            }
            if (filter.isElementVisible((Viewer)tree.getViewer(), element) && filter.isLeafMatch((Viewer)tree.getViewer(), element)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
        }
        return null;
    }

    public boolean isShowFilterControls() {
        return this.showFilterControls;
    }

    public void setShowFilterControls(boolean showFilterControls) {
        this.showFilterControls = showFilterControls;
        if (this.filterComposite != null) {
            Object filterCompositeLayoutData = this.filterComposite.getLayoutData();
            if (filterCompositeLayoutData instanceof GridData) {
                ((GridData)filterCompositeLayoutData).exclude = !this.isShowFilterControls();
            } else if (filterCompositeLayoutData instanceof RowData) {
                ((RowData)filterCompositeLayoutData).exclude = !this.isShowFilterControls();
            }
            this.filterComposite.setVisible(this.isShowFilterControls());
            this.layout();
        }
    }

    class NotifyingTreeViewer
    extends TreeViewer {
        public NotifyingTreeViewer(Composite parent, int style) {
            super(parent, style);
        }

        public void add(Object parentElementOrTreePath, Object childElement) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.add(parentElementOrTreePath, childElement);
        }

        public void add(Object parentElementOrTreePath, Object ... childElements) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.add(parentElementOrTreePath, childElements);
        }

        protected void inputChanged(Object input, Object oldInput) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.inputChanged(input, oldInput);
        }

        public void insert(Object parentElementOrTreePath, Object element, int position) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.insert(parentElementOrTreePath, element, position);
        }

        public void refresh() {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.refresh();
        }

        public void refresh(boolean updateLabels) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.refresh(updateLabels);
        }

        public void refresh(Object element) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.refresh(element);
        }

        public void refresh(Object element, boolean updateLabels) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.refresh(element, updateLabels);
        }

        public void remove(Object elementsOrTreePaths) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.remove(elementsOrTreePaths);
        }

        public void remove(Object parent, Object ... elements) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.remove(parent, elements);
        }

        public void remove(Object ... elementsOrTreePaths) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.remove(elementsOrTreePaths);
        }

        public void replace(Object parentElementOrTreePath, int index, Object element) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.replace(parentElementOrTreePath, index, element);
        }

        public void setChildCount(Object elementOrTreePath, int count) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.setChildCount(elementOrTreePath, count);
        }

        public void setContentProvider(IContentProvider provider) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.setContentProvider(provider);
        }

        public void setHasChildren(Object elementOrTreePath, boolean hasChildren) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.setHasChildren(elementOrTreePath, hasChildren);
        }
    }
}

