/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.ImportExportPage;
import org.eclipse.ui.wizards.IWizardCategory;

public class ImportPage
extends ImportExportPage {
    private static final String STORE_SELECTED_IMPORT_WIZARD_ID = "ImportExportPage.STORE_SELECTED_IMPORT_WIZARD_ID";
    private static final String STORE_EXPANDED_IMPORT_CATEGORIES = "ImportExportPage.STORE_EXPANDED_IMPORT_CATEGORIES";
    protected ImportExportPage.CategorizedWizardSelectionTree importTree;

    public ImportPage(IWorkbench aWorkbench, IStructuredSelection currentSelection) {
        super(aWorkbench, currentSelection);
    }

    @Override
    protected void initialize() {
        this.workbench.getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.import_wizard_selection_wizard_page_context");
    }

    @Override
    protected Composite createTreeViewer(Composite parent) {
        IWizardCategory root = WorkbenchPlugin.getDefault().getImportWizardRegistry().getRootCategory();
        this.importTree = new ImportExportPage.CategorizedWizardSelectionTree(root, WorkbenchMessages.ImportWizard_selectWizard);
        Composite importComp = this.importTree.createControl(parent);
        this.importTree.getViewer().addSelectionChangedListener(event -> this.listSelectionChanged(event.getSelection()));
        this.importTree.getViewer().addDoubleClickListener(this::treeDoubleClicked);
        this.setTreeViewer(this.importTree.getViewer());
        return importComp;
    }

    @Override
    public void saveWidgetValues() {
        this.storeExpandedCategories(STORE_EXPANDED_IMPORT_CATEGORIES, this.importTree.getViewer());
        this.storeSelectedCategoryAndWizard(STORE_SELECTED_IMPORT_WIZARD_ID, this.importTree.getViewer());
        super.saveWidgetValues();
    }

    @Override
    protected void restoreWidgetValues() {
        IWizardCategory importRoot = WorkbenchPlugin.getDefault().getImportWizardRegistry().getRootCategory();
        this.expandPreviouslyExpandedCategories(STORE_EXPANDED_IMPORT_CATEGORIES, importRoot, this.importTree.getViewer());
        this.selectPreviouslySelected(STORE_SELECTED_IMPORT_WIZARD_ID, importRoot, this.importTree.getViewer());
        super.restoreWidgetValues();
    }

    @Override
    protected ITriggerPoint getTriggerPoint() {
        return this.getWorkbench().getActivitySupport().getTriggerPointManager().getTriggerPoint("org.eclipse.ui.importWizards");
    }

    @Override
    protected void updateMessage() {
        this.setMessage(WorkbenchMessages.ImportExportPage_chooseImportWizard);
        super.updateMessage();
    }
}

