/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.url.jndi;

import com.sun.jndi.url.jndi.jndiDNSClient;
import com.sun.jndi.url.jndi.jndiURLContext;
import java.util.Hashtable;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.directory.InitialDirContext;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ResolveResult;

public class jndiURLContextFactory
implements ObjectFactory {
    private static String jndiURLPrefix = "jndi:";
    private static String dnsNNSPrefix = "service:j-";

    static Context createDNSContext(String string, String string2, boolean bl, Hashtable hashtable) throws NamingException {
        if (bl) {
            return jndiURLContextFactory.findDNSNNSCtx(string, string2, hashtable);
        }
        return null;
    }

    static Context findDNSNNSCtx(String string, String string2, Hashtable hashtable) throws NamingException {
        Object object;
        Cloneable cloneable;
        Object object2;
        Object object3;
        String[] stringArray = jndiDNSClient.getTXTRR(string, hashtable);
        Hashtable<Object, Cloneable> hashtable2 = new Hashtable<Object, Cloneable>();
        if (stringArray == null) {
            CompositeName compositeName = new CompositeName();
            compositeName.add(string);
            compositeName.add(string2);
            NameNotFoundException nameNotFoundException = new NameNotFoundException();
            nameNotFoundException.setRemainingName(compositeName);
            throw nameNotFoundException;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string3 = stringArray[n].trim();
            if (string3.startsWith(dnsNNSPrefix)) {
                object3 = string3.substring(dnsNNSPrefix.length());
                object2 = jndiURLContextFactory.getURLScheme((String)object3);
                cloneable = (Reference)hashtable2.get(object2);
                if (cloneable == null) {
                    cloneable = new Reference("javax.naming.Context");
                    hashtable2.put(object2, cloneable);
                }
                ((Reference)cloneable).add(new StringRefAddr("URL", (String)object3));
            }
            ++n;
        }
        object3 = null;
        object2 = hashtable2.elements();
        while (object2.hasMoreElements()) {
            cloneable = (Reference)object2.nextElement();
            object = null;
            try {
                object = NamingManager.getObjectInstance(cloneable, null, null, hashtable);
            }
            catch (Exception exception) {
                object3 = exception;
            }
            if (!(object instanceof Context)) continue;
            return (Context)object;
        }
        cloneable = new CompositeName();
        ((CompositeName)cloneable).add(string);
        ((CompositeName)cloneable).add(string2);
        object = new CannotProceedException();
        ((NamingException)object).setRemainingName((Name)cloneable);
        if (object3 != null) {
            ((NamingException)object).setRootCause((Throwable)object3);
        }
        throw object;
    }

    static ResolveResult getJNDIURLContext(String string, Hashtable hashtable) throws NamingException {
        if (!string.startsWith(jndiURLPrefix)) {
            throw new IllegalArgumentException("Can only get object instance of jndi URLs");
        }
        String string2 = string.substring(jndiURLPrefix.length());
        if (string2.startsWith("///")) {
            return new ResolveResult((Object)new InitialDirContext(hashtable), string.substring(jndiURLPrefix.length() + 3));
        }
        if (string2.startsWith("//")) {
            String string3;
            String string4;
            boolean bl = true;
            int n = string2.indexOf(47, 2);
            if (n == -1) {
                bl = false;
                string4 = string2.substring(2);
                string3 = "";
            } else {
                string4 = string2.substring(2, n);
                string3 = string2.substring(n + 1);
            }
            return new ResolveResult((Object)jndiURLContextFactory.createDNSContext(string4, string3, bl, hashtable), string3);
        }
        if (string2.startsWith("/")) {
            return new ResolveResult((Object)new InitialDirContext(hashtable), string.substring(jndiURLPrefix.length() + 1));
        }
        return new ResolveResult((Object)new InitialDirContext(hashtable), string.substring(jndiURLPrefix.length()));
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        if (object == null) {
            return new jndiURLContext(hashtable);
        }
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        }
        if (object instanceof String[] && ((String[])object).length > 0) {
            string = ((String[])object)[0];
        }
        if (string == null) {
            throw new IllegalArgumentException("Can only get object instance of jndi URLs");
        }
        ResolveResult resolveResult = jndiURLContextFactory.getJNDIURLContext(string, hashtable);
        Context context2 = (Context)resolveResult.getResolvedObj();
        String string2 = resolveResult.getRemainingName().toString();
        if (string2 == null || string2 == "") {
            return context2;
        }
        return context2.lookup(string2);
    }

    protected static String getURLScheme(String string) {
        int n = string.indexOf(58);
        int n2 = string.indexOf(47);
        if (n > 0 && (n2 == -1 || n < n2)) {
            return string.substring(0, n);
        }
        return null;
    }
}

