/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.base.actions;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.passage.lbc.base.BaseComponent;
import org.eclipse.passage.lbc.base.condition.ServerConditionsDistributor;
import org.eclipse.passage.lbc.runtime.ServerRequestAction;
import org.eclipse.passage.lic.base.LicensingConfigurations;
import org.eclipse.passage.lic.runtime.LicensingConfiguration;
import org.eclipse.passage.lic.runtime.access.FeaturePermission;
import org.eclipse.passage.lic.runtime.access.PermissionEmitter;
import org.eclipse.passage.lic.runtime.access.PermissionTransport;
import org.eclipse.passage.lic.runtime.conditions.ConditionTransport;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.log.LoggerFactory;

@Component
public class ConditionCheckoutRequestAction
extends BaseComponent
implements ServerRequestAction {
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static final String APPLICATION_JSON = "application/json";
    private static final String CONDITIONS_FOR_EVALUATE_NOT_DEFINED_ERROR = "Conditions for evaluate not defined.";
    private static final String PASSAGE_EXECUTE_TXT = "[Passage] Execute action: %s ";
    private static final String LICENSING_CONDITION_TYPE_SERVER = "server";
    private static final String LICENSING_CONTENT_TYPE = "licensing.content.type";
    ServerConditionsDistributor conditionEvaluator;
    private Map<String, PermissionTransport> mapPermission2Transport = new HashMap<String, PermissionTransport>();
    private Map<String, ConditionTransport> mapCondition2Transport = new HashMap<String, ConditionTransport>();

    public boolean execute(HttpServletRequest request, HttpServletResponse response) {
        PermissionTransport transportPermission;
        Iterable<FeaturePermission> evaluatePermissions;
        block7: {
            Iterable descriptors;
            String contentType;
            block6: {
                ConditionTransport transport;
                block5: {
                    this.logger.info(String.format(PASSAGE_EXECUTE_TXT, this.getClass().getName()));
                    try {
                        contentType = request.getContentType();
                        transport = this.mapCondition2Transport.get(contentType);
                        if (transport != null) break block5;
                        this.logger.error(String.format("LicensingConditionTransport not defined for contentType: %s", contentType));
                        return false;
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Object)e);
                        return false;
                    }
                }
                descriptors = transport.readConditions((InputStream)request.getInputStream());
                if (descriptors != null) break block6;
                response.getWriter().println(CONDITIONS_FOR_EVALUATE_NOT_DEFINED_ERROR);
                this.logger.error(CONDITIONS_FOR_EVALUATE_NOT_DEFINED_ERROR);
                return false;
            }
            String productId = request.getParameter("product");
            String productVersion = request.getParameter("version");
            LicensingConfiguration configuration = LicensingConfigurations.create((String)productId, (String)productVersion);
            evaluatePermissions = this.conditionEvaluator.emitPermissions(configuration, descriptors);
            transportPermission = this.mapPermission2Transport.get(contentType);
            if (transportPermission != null) break block7;
            this.logger.error(String.format("FeaturePermissionTransport not defined for contentType: %s", contentType));
            return false;
        }
        transportPermission.writePermissions(evaluatePermissions, (OutputStream)response.getOutputStream());
        response.setContentType(APPLICATION_JSON);
        response.setCharacterEncoding(CHARSET_UTF_8);
        PrintWriter printerWriter = response.getWriter();
        printerWriter.flush();
        return true;
    }

    @Override
    @Reference
    protected void bindLogger(LoggerFactory loggerFactory) {
        super.bindLogger(loggerFactory);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void bindServerConditionEvaluator(PermissionEmitter evaluator, Map<String, String> context) {
        String conditionType = context.get(LICENSING_CONTENT_TYPE);
        if (conditionType != null && conditionType.equals(LICENSING_CONDITION_TYPE_SERVER) && evaluator instanceof ServerConditionsDistributor) {
            this.conditionEvaluator = (ServerConditionsDistributor)evaluator;
        }
    }

    public void unbindServerConditionEvaluator(PermissionEmitter evaluator, Map<String, String> context) {
        String conditionType = context.get(LICENSING_CONTENT_TYPE);
        if (conditionType != null && conditionType.equals(LICENSING_CONDITION_TYPE_SERVER) && evaluator instanceof ServerConditionsDistributor) {
            this.conditionEvaluator = null;
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void bindPermissionTransport(PermissionTransport transport, Map<String, String> context) {
        String conditionType = context.get(LICENSING_CONTENT_TYPE);
        if (conditionType != null) {
            this.mapPermission2Transport.put(conditionType, transport);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void bindLicensingConditionTransport(ConditionTransport transport, Map<String, String> context) {
        String conditionType = context.get(LICENSING_CONTENT_TYPE);
        if (conditionType != null) {
            this.mapCondition2Transport.put(conditionType, transport);
        }
    }
}

