/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.restrictions;

import java.util.Comparator;
import org.eclipse.passage.lic.runtime.restrictions.RestrictionVerdict;

public class RestrictionVerdictComparator
implements Comparator<RestrictionVerdict> {
    private static final Integer VALUE_INFO = 1;
    private static final Integer VALUE_WARN = 2;
    private static final Integer VALUE_ERROR = 4;
    private static final Integer VALUE_FATAL = 8;
    private static final Integer VALUE_DEFAULT = VALUE_WARN;

    @Override
    public int compare(RestrictionVerdict o1, RestrictionVerdict o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        String level1 = o1.getRestrictionLevel();
        String level2 = o2.getRestrictionLevel();
        return RestrictionVerdictComparator.compareLevels(level1, level2);
    }

    public static int compareLevels(String level1, String level2) {
        Integer resolved1 = RestrictionVerdictComparator.resolveLevel(level1);
        Integer resolved2 = RestrictionVerdictComparator.resolveLevel(level2);
        return resolved1.compareTo(resolved2);
    }

    private static Integer resolveLevel(String level) {
        if (level == null) {
            return VALUE_DEFAULT;
        }
        switch (level) {
            case "info": {
                return VALUE_INFO;
            }
            case "warn": {
                return VALUE_WARN;
            }
            case "error": {
                return VALUE_ERROR;
            }
            case "fatal": {
                return VALUE_FATAL;
            }
        }
        return VALUE_DEFAULT;
    }
}

