/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.passage.lic.emf.ecore.DomainContentAdapter;
import org.eclipse.passage.lic.emf.ecore.EditingDomainRegistry;
import org.eclipse.passage.lic.emf.edit.BaseDomainRegistry;
import org.eclipse.passage.lic.emf.edit.ComposedAdapterFactoryProvider;
import org.eclipse.passage.lic.licenses.LicensePackDescriptor;
import org.eclipse.passage.lic.licenses.model.meta.LicensesPackage;
import org.eclipse.passage.lic.licenses.registry.LicenseRegistry;
import org.eclipse.passage.loc.internal.licenses.core.LicensesDomainRegistryTracker;
import org.eclipse.passage.loc.runtime.OperatorEvents;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;

@Component(property={"org.eclipse.passage.lic.emf.edit.domain.name=licenses", "org.eclipse.passage.lic.emf.edit.file.extension=licenses_xmi"})
public class LicenseDomainRegistry
extends BaseDomainRegistry<LicensePackDescriptor>
implements LicenseRegistry,
EditingDomainRegistry<LicensePackDescriptor> {
    private final Map<String, LicensePackDescriptor> licensePackIndex = new HashMap<String, LicensePackDescriptor>();
    private final Map<String, List<LicensePackDescriptor>> userPackIndex = new HashMap<String, List<LicensePackDescriptor>>();
    private final Map<String, Map<String, List<LicensePackDescriptor>>> productVersionPackIndex = new HashMap<String, Map<String, List<LicensePackDescriptor>>>();

    @Reference
    public void bindEventAdmin(EventAdmin admin) {
        super.bindEventAdmin(admin);
    }

    public void unbindEventAdmin(EventAdmin admin) {
        super.unbindEventAdmin(admin);
    }

    @Reference
    public void bindFactoryProvider(ComposedAdapterFactoryProvider factoryProvider) {
        super.bindFactoryProvider(factoryProvider);
    }

    public void unbindFactoryProvider(ComposedAdapterFactoryProvider factoryProvider) {
        super.unbindFactoryProvider(factoryProvider);
    }

    @Activate
    public void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    @Deactivate
    public void deactivate(Map<String, Object> properties) {
        Collection<Map<String, List<LicensePackDescriptor>>> productPacks = this.productVersionPackIndex.values();
        for (Map<String, List<LicensePackDescriptor>> versionPacks : productPacks) {
            Collection<List<LicensePackDescriptor>> packs = versionPacks.values();
            for (List<LicensePackDescriptor> list : packs) {
                list.clear();
            }
            versionPacks.clear();
        }
        productPacks.clear();
        Collection<List<LicensePackDescriptor>> packs = this.userPackIndex.values();
        for (List<LicensePackDescriptor> list : packs) {
            list.clear();
        }
        this.userPackIndex.clear();
        this.licensePackIndex.clear();
        super.deactivate(properties);
    }

    public String getFileExtension() {
        return "licenses_xmi";
    }

    public Class<LicensePackDescriptor> getContentClass() {
        return LicensePackDescriptor.class;
    }

    public String resolveIdentifier(LicensePackDescriptor content) {
        return content.getIdentifier();
    }

    public LicensePackDescriptor getLicensePack(String identifier) {
        return this.licensePackIndex.get(identifier);
    }

    public Iterable<LicensePackDescriptor> getLicensePacks() {
        return new ArrayList<LicensePackDescriptor>(this.licensePackIndex.values());
    }

    public Iterable<LicensePackDescriptor> getUserLicensePacks(String userId) {
        List<LicensePackDescriptor> list = this.userPackIndex.get(userId);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public Iterable<LicensePackDescriptor> getProductVersionLicensePacks(String productId, String version) {
        Map<String, List<LicensePackDescriptor>> map = this.productVersionPackIndex.get(productId);
        if (map == null) {
            return Collections.emptyList();
        }
        List<LicensePackDescriptor> list = map.get(version);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    protected DomainContentAdapter<LicensePackDescriptor, LicenseDomainRegistry> createContentAdapter() {
        return new LicensesDomainRegistryTracker(this);
    }

    public void registerLicensePack(LicensePackDescriptor licensePack) {
        String identifier = licensePack.getIdentifier();
        LicensePackDescriptor existing = this.licensePackIndex.put(identifier, licensePack);
        this.eventAdmin.postEvent(OperatorEvents.create((String)"org/eclipse/passage/lic/licenses/registry/LicensePack/create", (Object)licensePack));
        String userIdentifier = licensePack.getUserIdentifier();
        List userPackList = this.userPackIndex.computeIfAbsent(userIdentifier, key -> new ArrayList());
        userPackList.add(licensePack);
        String productIdentifier = licensePack.getProductIdentifier();
        Map map = this.productVersionPackIndex.computeIfAbsent(productIdentifier, key -> new HashMap());
        String productVersion = licensePack.getProductVersion();
        List list = map.computeIfAbsent(productVersion, key -> new ArrayList());
        list.add(licensePack);
    }

    public void unregisterLicensePack(String identifier) {
        LicensePackDescriptor removed = this.licensePackIndex.remove(identifier);
        if (removed != null) {
            String productIdentifier;
            Map<String, List<LicensePackDescriptor>> map;
            this.eventAdmin.postEvent(OperatorEvents.create((String)"org/eclipse/passage/lic/licenses/registry/LicensePack/delete", (Object)removed));
            String userIdentifier = removed.getUserIdentifier();
            List<LicensePackDescriptor> userPackList = this.userPackIndex.get(userIdentifier);
            if (userPackList != null) {
                userPackList.remove(removed);
                if (userPackList.isEmpty()) {
                    this.userPackIndex.remove(userIdentifier);
                }
            }
            if ((map = this.productVersionPackIndex.get(productIdentifier = removed.getProductIdentifier())) != null) {
                String productVersion = removed.getProductVersion();
                List<LicensePackDescriptor> list = map.get(productVersion);
                if (list != null) {
                    list.remove(removed);
                    if (list.isEmpty()) {
                        map.remove(productVersion);
                    }
                }
                if (map.isEmpty()) {
                    this.productVersionPackIndex.remove(productIdentifier);
                }
            }
        }
    }

    public EClass getContentClassifier() {
        return LicensesPackage.eINSTANCE.getLicensePack();
    }

    public EStructuralFeature getContentIdentifierAttribute() {
        return LicensesPackage.eINSTANCE.getLicensePack_Identifier();
    }

    public EStructuralFeature getContentNameAttribute() {
        return null;
    }

    public void registerContent(LicensePackDescriptor content) {
        this.registerLicensePack(content);
    }

    public void unregisterContent(String identifier) {
        this.unregisterLicensePack(identifier);
    }
}

