/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.workbench;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.passage.lic.base.restrictions.RestrictionVerdicts;
import org.eclipse.passage.lic.jface.dialogs.LicensingStatusDialog;
import org.eclipse.passage.lic.jface.resource.LicensingImages;
import org.eclipse.passage.lic.jface.viewers.LicensingLabelProvider;
import org.eclipse.passage.lic.jface.viewers.RestrictionRepresenters;
import org.eclipse.passage.lic.runtime.restrictions.RestrictionVerdict;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class LicensingStatusToolControl {
    private Button button;
    private LicensingLabelProvider labelProvider;

    @Inject
    @Optional
    public void restrictionsExecuted(@UIEventTopic(value="org/eclipse/passage/lic/runtime/AccessEvents/restrictionsExecuted") Iterable<RestrictionVerdict> actions) {
        RestrictionVerdict last = RestrictionVerdicts.resolveLastVerdict(actions);
        this.updateButton(last);
    }

    @PostConstruct
    public void createGui(Composite parent) {
        this.button = new Button(parent, 0);
        this.button.setFont(JFaceResources.getDefaultFont());
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell activeShell = LicensingStatusToolControl.this.button.getDisplay().getActiveShell();
                LicensingStatusDialog dialog = new LicensingStatusDialog(activeShell, new String[0]);
                dialog.open();
            }
        });
        this.button.setImage(LicensingImages.getImage((String)"IMG_LEVEL_OK"));
        this.button.setText("Undefined");
        this.labelProvider = new LicensingLabelProvider();
    }

    protected void updateButton(RestrictionVerdict last) {
        this.button.setImage(this.labelProvider.getImage((Object)last));
        this.button.setText(this.labelProvider.getText((Object)last));
        this.button.setToolTipText(RestrictionRepresenters.resolveSummary((RestrictionVerdict)last));
    }
}

