/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.jface.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ObjectSelectionDialog
extends TrayDialog {
    private final List<Object> result = new ArrayList<Object>();
    private final List<Object> initial = new ArrayList<Object>();
    private String title;
    private Image image;
    private String message = "";

    protected ObjectSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.image != null) {
            shell.setImage(this.image);
        }
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Label createMessageArea(Composite composite) {
        Label label = new Label(composite, 0);
        if (this.message != null) {
            label.setText(this.message);
        }
        label.setFont(composite.getFont());
        return label;
    }

    protected List<Object> getInitial() {
        return this.initial;
    }

    public Object getFirstResult() {
        if (this.result.isEmpty()) {
            return null;
        }
        return this.result.get(0);
    }

    protected void setResult(int position, Object element) {
        this.result.set(position, element);
    }

    public Iterable<Object> getResult() {
        return this.result;
    }

    public void setInitial(Object ... objects) {
        this.initial.clear();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.initial.add(object);
            ++n2;
        }
    }

    public void setInitial(Iterable<?> objects) {
        this.initial.clear();
        objects.forEach(this.initial::add);
    }

    protected void setResult(Iterable<?> objects) {
        this.result.clear();
        objects.forEach(this.result::add);
    }

    protected void setResult(Object ... objects) {
        this.result.clear();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.result.add(object);
            ++n2;
        }
    }

    protected boolean isResizable() {
        return true;
    }
}

