/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.jface;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class ImageFinder {
    private static final ImageDescriptor[] NO_IMAGE_DESCRIPTORS = new ImageDescriptor[0];

    public static URL getUrl(String value, Bundle definingBundle) {
        block3: {
            try {
                if (value != null) {
                    return new URL(value);
                }
            }
            catch (MalformedURLException e) {
                if (definingBundle == null) break block3;
                return FileLocator.find((Bundle)definingBundle, (IPath)new Path(value));
            }
        }
        return null;
    }

    public static List<URL> getUrls(String value, Bundle definingBundle, String separator) {
        if (value == null) {
            return Collections.emptyList();
        }
        StringTokenizer tokens = new StringTokenizer(value, separator);
        ArrayList<URL> list = new ArrayList<URL>(10);
        while (tokens.hasMoreTokens()) {
            String segment = tokens.nextToken().trim();
            URL url = ImageFinder.getUrl(segment, definingBundle);
            if (url == null) continue;
            list.add(url);
        }
        return list;
    }

    public static ImageDescriptor getImage(String value, Bundle definingBundle) {
        URL url = ImageFinder.getUrl(value, definingBundle);
        return url == null ? null : ImageDescriptor.createFromURL((URL)url);
    }

    public static ImageDescriptor[] getImages(String value, Bundle definingBundle) {
        List<URL> urls = ImageFinder.getUrls(value, definingBundle, ",");
        if (urls.isEmpty()) {
            return NO_IMAGE_DESCRIPTORS;
        }
        ImageDescriptor[] images = new ImageDescriptor[urls.size()];
        int i = 0;
        while (i < images.length) {
            images[i] = ImageDescriptor.createFromURL((URL)urls.get(i));
            ++i;
        }
        return images;
    }
}

