/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.io;

import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.passage.lic.api.LicensingConfiguration;

public class LicensingPaths {
    public static String FOLDER_LICENSING_BASE = ".passage";
    public static String EXTENSION_LICENSE_DECRYPTED = ".lic";
    public static String EXTENSION_LICENSE_ENCRYPTED = ".licen";
    public static String EXTENSION_PRODUCT_PUBLIC = ".pub";

    public static Path resolveBasePath(URL url) {
        File file = new File(url.getPath());
        Path path = Paths.get(file.getPath(), new String[0]);
        return path.resolve(FOLDER_LICENSING_BASE);
    }

    public static Path resolveConfigurationPath(URL url, LicensingConfiguration configuration) {
        Path base = LicensingPaths.resolveBasePath(url);
        return LicensingPaths.resolveConfigurationPath(base, configuration);
    }

    public static Path resolveConfigurationPath(Path from, LicensingConfiguration configuration) {
        Path basePath = from;
        if (configuration == null) {
            return basePath;
        }
        String product = configuration.getProductIdentifier();
        if (product == null) {
            return basePath;
        }
        Path productPath = basePath.resolve(product);
        String version = configuration.getProductVersion();
        if (version == null) {
            return productPath;
        }
        return productPath.resolve(version);
    }

    public static String composeFileName(LicensingConfiguration configuration, String extension) {
        String product = null;
        String version = null;
        if (configuration != null) {
            product = configuration.getProductIdentifier();
            version = configuration.getProductVersion();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(product).append('_').append(version).append(extension);
        return sb.toString();
    }
}

