/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core.request;

import java.time.LocalDate;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.products.ProductVersionDescriptor;
import org.eclipse.passage.lic.users.UserDescriptor;
import org.eclipse.passage.loc.internal.api.PersonalLicenseRequest;
import org.eclipse.passage.loc.internal.licenses.core.request.GeneralLicenseData;

public final class PersonalLicenseData
extends GeneralLicenseData
implements PersonalLicenseRequest {
    private final Supplier<UserDescriptor> user;

    public PersonalLicenseData(Supplier<UserDescriptor> user, Supplier<LicensePlanDescriptor> plan, Supplier<ProductVersionDescriptor> product, Supplier<LocalDate> from, Supplier<LocalDate> until) {
        super(plan, product, from, until);
        Objects.requireNonNull(user, "PersonalLicenseData::user");
        this.user = user;
    }

    public String user() {
        return this.user.get().getEmail();
    }

    public String userFullName() {
        return this.user.get().getFullName();
    }

    public String conditionType() {
        return this.user.get().getPreferredConditionType();
    }

    public String conditionExpression() {
        return this.user.get().getPreferredConditionExpression();
    }
}

