/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.restrictions;

import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.Permission;
import org.eclipse.passage.lic.internal.api.requirements.Requirement;
import org.eclipse.passage.lic.internal.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.internal.api.restrictions.Restriction;

public final class BaseExaminationCertificate
implements ExaminationCertificate {
    private final Map<Requirement, Permission> satisfied;
    private final Collection<Restriction> restrictions;
    private final ZonedDateTime stamp;

    public BaseExaminationCertificate(Map<Requirement, Permission> satisfied, Collection<Restriction> restrictions) {
        Objects.requireNonNull(satisfied, "BaseExaminationCertificate::satisfied");
        Objects.requireNonNull(restrictions, "BaseExaminationCertificate::restrictions");
        this.satisfied = satisfied;
        this.restrictions = restrictions;
        this.stamp = ZonedDateTime.now();
    }

    public Collection<Restriction> restrictions() {
        return this.restrictions;
    }

    public ZonedDateTime stamp() {
        return this.stamp;
    }

    public Collection<Requirement> satisfied() {
        return new HashSet<Requirement>(this.satisfied.keySet());
    }

    public Permission satisfaction(Requirement requirement) {
        if (!this.satisfied.containsKey(requirement)) {
            throw new IllegalArgumentException("The requirement has not been satisifed");
        }
        return this.satisfied.get(requirement);
    }
}

