/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.base.io.FileNameFromLicensedProduct;
import org.eclipse.passage.lic.internal.base.io.PassageFileExtension;
import org.eclipse.passage.lic.internal.base.io.UserHomeProductResidence;
import org.eclipse.passage.loc.internal.licenses.core.i18n.LicensesCoreMessages;

final class ProductKeyFile {
    private final LicensedProduct product;

    ProductKeyFile(LicensedProduct product) {
        this.product = product;
    }

    Path scr() throws LicensingException {
        return this.get((PassageFileExtension)new PassageFileExtension.PrivateKey(), LicensesCoreMessages.LicenseOperatorServiceImpl_private_key_not_found);
    }

    Path pub() throws LicensingException {
        return this.get((PassageFileExtension)new PassageFileExtension.PublicKey(), LicensesCoreMessages.LicenseOperatorServiceImpl_public_key_not_found);
    }

    private Path get(PassageFileExtension ext, String error) throws LicensingException {
        Path key = new UserHomeProductResidence(this.product).get().resolve(new FileNameFromLicensedProduct(this.product, ext).get());
        if (!Files.exists(key, new LinkOption[0])) {
            throw new LicensingException(String.format(error, key.toAbsolutePath()));
        }
        return key;
    }
}

