/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.net.handle;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.passage.lic.internal.api.LicensingException;
import org.eclipse.passage.lic.internal.api.conditions.mining.ContentType;
import org.eclipse.passage.lic.internal.api.io.Hashes;
import org.eclipse.passage.lic.internal.api.io.KeyKeeper;
import org.eclipse.passage.lic.internal.emf.EObjectToBytes;
import org.eclipse.passage.lic.internal.net.api.handle.NetResponse;
import org.eclipse.passage.lic.internal.net.io.SafePayload;

public final class EObjectTransfer
implements NetResponse {
    private final EObject payload;
    private final KeyKeeper key;
    private final Hashes hashes;

    public EObjectTransfer(EObject payload, KeyKeeper key, Hashes hashes) {
        this.payload = payload;
        this.key = key;
        this.hashes = hashes;
    }

    @Override
    public boolean failed() {
        return false;
    }

    @Override
    public boolean carriesPayload() {
        return true;
    }

    @Override
    public NetResponse.Error error() {
        throw new IllegalStateException("Successful response does not possess error information");
    }

    @Override
    public byte[] payload() throws LicensingException {
        return this.encode(new EObjectToBytes(this.payload, XMIResourceImpl::new).get());
    }

    @Override
    public ContentType contentType() {
        return new ContentType.Xml();
    }

    private byte[] encode(byte[] plain) throws LicensingException {
        return new SafePayload(this.key, this.hashes).encode(plain);
    }
}

