/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards;

import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.passage.lic.emf.validation.ErrorMessages;
import org.eclipse.passage.lic.licenses.PersonalLicensePackDescriptor;
import org.eclipse.passage.lic.licenses.model.api.PersonalFeatureGrant;
import org.eclipse.passage.lic.licenses.model.api.PersonalLicensePack;
import org.eclipse.passage.lic.licenses.model.api.ValidityPeriodClosed;
import org.eclipse.passage.loc.internal.api.OperatorLicenseService;
import org.eclipse.passage.loc.internal.api.PersonalLicenseRequest;
import org.eclipse.passage.loc.internal.dashboard.ui.i18n.IssueLicensePageMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

class IssueLicensePackPage
extends WizardPage {
    private final IEclipseContext context;
    private final Supplier<PersonalLicenseRequest> data;
    private final ErrorMessages validate;
    private PersonalLicensePack license;
    private VViewModelProperties properties;
    private Composite base;

    protected IssueLicensePackPage(String name, Supplier<PersonalLicenseRequest> data, IEclipseContext context) {
        super(name);
        this.context = context;
        this.data = data;
        this.validate = new ErrorMessages();
        this.setTitle(IssueLicensePageMessages.IssueLicensePackPage_page_title);
        this.setDescription(IssueLicensePageMessages.IssueLicensePackPage_page_description);
    }

    void init() {
        PersonalLicenseRequest request = this.data.get();
        if (this.license != null) {
            this.refillFormRequest(request);
        } else {
            this.createFormRequest(request);
        }
        this.buildPage();
    }

    private void createFormRequest(PersonalLicenseRequest request) {
        OperatorLicenseService service = (OperatorLicenseService)this.context.get(OperatorLicenseService.class);
        PersonalLicensePackDescriptor descriptor = service.createLicensePack(request);
        if (descriptor instanceof PersonalLicensePack) {
            this.license = (PersonalLicensePack)descriptor;
            this.license.eAdapters().add((Object)new EContentAdapter(){

                public void notifyChanged(Notification notification) {
                    IssueLicensePackPage.this.setPageComplete(IssueLicensePackPage.this.validatePage());
                }
            });
        }
    }

    private void refillFormRequest(PersonalLicenseRequest request) {
        this.license.getLicense().setPlan(request.plan());
        this.license.getLicense().getProduct().setIdentifier(request.productIdentifier());
        this.license.getLicense().getProduct().setVersion(request.productVersion());
        this.license.getLicense().getUser().setIdentifier(request.user());
        EList grants = this.license.getGrants();
        for (PersonalFeatureGrant grant : grants) {
            ValidityPeriodClosed valid = (ValidityPeriodClosed)grant.getValid();
            valid.setFrom(request.validFrom());
            valid.setUntil(request.validUntil());
        }
        ValidityPeriodClosed valid = (ValidityPeriodClosed)this.license.getLicense().getValid();
        valid.setFrom(request.validFrom());
        valid.setUntil(request.validUntil());
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        this.setControl((Control)composite);
        this.base = new Composite(composite, 0);
        this.base.setLayout((Layout)new GridLayout(1, false));
        this.base.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.properties = VViewFactory.eINSTANCE.createViewModelLoadingProperties();
        this.properties.addInheritableProperty("useOnModifyDatabinding", (Object)"true");
        this.buildPage();
        Dialog.applyDialogFont((Control)composite);
    }

    private void buildPage() {
        if (this.base == null || this.base.isDisposed()) {
            this.setPageComplete(false);
            return;
        }
        if (this.license != null) {
            Control[] children;
            Control[] controlArray = children = this.base.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
            try {
                ECPSWTViewRenderer.INSTANCE.render(this.base, (EObject)this.license, this.properties);
                this.base.layout();
            }
            catch (ECPRendererException eCPRendererException) {
                // empty catch block
            }
        }
        this.setPageComplete(this.validatePage());
    }

    protected boolean validatePage() {
        Optional errors = this.validate.apply((EObject)this.license);
        this.setErrorMessage(errors.orElse(null));
        return errors.isEmpty();
    }

    PersonalLicensePackDescriptor pack() {
        return this.license;
    }
}

