/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.agreements;

import java.io.InputStream;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.agreements.AgreementAcceptanceService;
import org.eclipse.passage.lic.api.agreements.AgreementState;
import org.eclipse.passage.lic.api.agreements.AgreementToAccept;
import org.eclipse.passage.lic.api.agreements.ResolvedAgreement;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.api.requirements.Requirement;
import org.eclipse.passage.lic.base.agreements.Assessment;
import org.eclipse.passage.lic.base.agreements.BaseAgreementAcceptanceService;
import org.eclipse.passage.lic.base.agreements.BaseAgreementToAccept;
import org.eclipse.passage.lic.base.diagnostic.code.ServiceFailedOnMorsel;

public final class AgreementAssessmentService {
    private final Collection<Requirement> requirements;
    private final BaseAgreementAcceptanceService.Smart acceptance;

    public AgreementAssessmentService(Collection<Requirement> requirements, AgreementAcceptanceService acceptance) {
        this.requirements = requirements;
        this.acceptance = new BaseAgreementAcceptanceService.Smart(acceptance);
    }

    public Collection<AgreementToAccept> assessment() {
        return this.requirements.stream().map(this::assessment).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Collection<AgreementToAccept> assessment(Requirement requirement) {
        return requirement.agreements().stream().map(agreement -> new BaseAgreementToAccept(requirement, (ResolvedAgreement)agreement, this.assessment((ResolvedAgreement)agreement, requirement))).collect(Collectors.toList());
    }

    private AgreementState assessment(ResolvedAgreement agreement, Requirement requirement) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream content = agreement.content();){
                return this.contentAssessment(content, agreement, requirement);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            String name = this.origin(agreement, requirement);
            return new Assessment(name, this.cannotBeRead(e, name));
        }
    }

    private AgreementState contentAssessment(InputStream content, ResolvedAgreement agreement, Requirement requirement) {
        return this.acceptance.accepted(content, this.origin(agreement, requirement));
    }

    private String origin(ResolvedAgreement agreement, Requirement requirement) {
        return String.valueOf(requirement.source().toString()) + ':' + agreement.path();
    }

    private Trouble cannotBeRead(Exception e, String location) {
        return new Trouble((TroubleCode)new ServiceFailedOnMorsel(), String.format("Failed to read content of agreement [%s]", location), e);
    }
}

