/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.hqc;

import org.bouncycastle.util.Pack;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class Utils {
    Utils() {
    }

    static byte[] removeLast0Bits(byte[] byArray) {
        int n = 0;
        for (int i = byArray.length - 1; i >= 0; --i) {
            if (byArray[i] != 1) continue;
            n = i;
            break;
        }
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    static void fromBitArrayToByteArray(byte[] byArray, byte[] byArray2) {
        int n = 0;
        int n2 = 0;
        long l = byArray2.length;
        while ((long)n < l) {
            int n3;
            int n4;
            if (n + 8 >= byArray2.length) {
                n4 = byArray2[n];
                for (n3 = byArray2.length - n - 1; n3 >= 1; --n3) {
                    n4 |= byArray2[n + n3] << n3;
                }
                byArray[n2] = (byte)n4;
            } else {
                n4 = byArray2[n];
                for (n3 = 7; n3 >= 1; --n3) {
                    n4 |= byArray2[n + n3] << n3;
                }
                byArray[n2] = (byte)n4;
            }
            n += 8;
            ++n2;
        }
    }

    static void fromBitArrayToLongArray(long[] lArray, byte[] byArray) {
        int n = 0;
        int n2 = 0;
        long l = byArray.length;
        while ((long)n < l) {
            int n3;
            long l2;
            if (n + 64 >= byArray.length) {
                l2 = byArray[n];
                for (n3 = byArray.length - n - 1; n3 >= 1; --n3) {
                    l2 |= (long)byArray[n + n3] << n3;
                }
                lArray[n2] = l2;
            } else {
                l2 = byArray[n];
                for (n3 = 63; n3 >= 1; --n3) {
                    l2 |= (long)byArray[n + n3] << n3;
                }
                lArray[n2] = l2;
            }
            n += 64;
            ++n2;
        }
    }

    static void resizeArray(long[] lArray, int n, long[] lArray2, int n2, int n3, int n4) {
        long l = Long.MAX_VALUE;
        int n5 = 0;
        if (n < n2) {
            if (n % 64 != 0) {
                n5 = 64 - n % 64;
            }
            System.arraycopy(lArray2, 0, lArray, 0, n3);
            for (int i = 0; i < n5; ++i) {
                int n6 = n4 - 1;
                lArray[n6] = lArray[n6] & l >> i;
            }
        } else {
            System.arraycopy(lArray2, 0, lArray, 0, (n2 + 7) / 8);
        }
    }

    static void fromByteArrayToBitArray(byte[] byArray, byte[] byArray2) {
        int n;
        int n2;
        int n3 = byArray.length / 8;
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n != 8; ++n) {
                byArray[n2 * 8 + n] = (byte)((byArray2[n2] & 1 << n) >>> n);
            }
        }
        if (byArray.length % 8 != 0) {
            n2 = n3 * 8;
            n = 0;
            while (n2 < byArray.length) {
                byArray[n2++] = (byte)((byArray2[n3] & 1 << n) >>> n);
                ++n;
            }
        }
    }

    static void fromLongArrayToBitArray(byte[] byArray, long[] lArray) {
        int n;
        int n2;
        int n3 = byArray.length / 64;
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n != 64; ++n) {
                byArray[n2 * 64 + n] = (byte)((lArray[n2] & 1L << n) >>> n);
            }
        }
        if (byArray.length % 64 != 0) {
            n2 = n3 * 64;
            n = 0;
            while (n2 < byArray.length) {
                byArray[n2++] = (byte)((lArray[n3] & 1L << n) >>> n);
                ++n;
            }
        }
    }

    static void fromLongArrayToByteArray(byte[] byArray, long[] lArray, int n) {
        int n2;
        int n3 = byArray.length / 8;
        for (n2 = 0; n2 != n3; ++n2) {
            Pack.longToLittleEndian(lArray[n2], byArray, n2 * 8);
        }
        if (byArray.length % 8 != 0) {
            n2 = n3 * 8;
            int n4 = 0;
            while (n2 < byArray.length) {
                byArray[n2++] = (byte)(lArray[n3] >>> n4++ * 8);
            }
        }
    }

    static long bitMask(long l, long l2) {
        return (1L << (int)(l % l2)) - 1L;
    }

    static byte[] fromListOfPos1ToBitArray(int[] nArray, int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[nArray[i]] = 1;
        }
        return byArray;
    }

    static void fromByteArrayToLongArray(long[] lArray, byte[] byArray) {
        byte[] byArray2 = byArray;
        if (byArray.length % 8 != 0) {
            byArray2 = new byte[(byArray.length + 7) / 8 * 8];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        int n = 0;
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = Pack.littleEndianToLong(byArray2, n);
            n += 8;
        }
    }

    static void fromByte32ArrayToLongArray(long[] lArray, int[] nArray) {
        for (int i = 0; i != nArray.length; i += 2) {
            lArray[i / 2] = (long)nArray[i] & 0xFFFFFFFFL;
            int n = i / 2;
            lArray[n] = lArray[n] | (long)nArray[i + 1] << 32;
        }
    }

    static void fromLongArrayToByte32Array(int[] nArray, long[] lArray) {
        for (int i = 0; i != lArray.length; ++i) {
            nArray[2 * i] = (int)lArray[i];
            nArray[2 * i + 1] = (int)(lArray[i] >> 32);
        }
    }

    static void copyBytes(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        System.arraycopy(nArray, n, nArray2, n2, n3 / 2);
    }

    static int getByteSizeFromBitSize(int n) {
        return (n + 7) / 8;
    }

    static int getByte64SizeFromBitSize(int n) {
        return (n + 63) / 64;
    }

    static int toUnsigned8bits(int n) {
        return n & 0xFF;
    }

    static int toUnsigned16Bits(int n) {
        return n & 0xFFFF;
    }
}

