/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workbench.emfforms.renderers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.passage.lic.api.EvaluationType;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.registry.Registry;
import org.eclipse.passage.lic.api.registry.Service;
import org.eclipse.passage.loc.internal.api.OperatorGear;
import org.eclipse.passage.loc.internal.equinox.OperatorGearAware;
import org.eclipse.passage.loc.internal.workbench.emfforms.i18n.WorkbenchEmfformsMessages;
import org.eclipse.passage.loc.workbench.emfforms.renderers.ComboControlRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionTypeRenderer
extends ComboControlRenderer {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final List<String> environments;

    @Inject
    public ConditionTypeRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        Optional found = Optional.empty();
        try {
            found = new OperatorGearAware().withGear(this::names);
        }
        catch (LicensingException e) {
            this.log.error("Failed to resolve condition types", (Throwable)e);
        }
        this.environments = found.orElseGet(Collections::emptyList);
    }

    protected String getUnsetText() {
        return WorkbenchEmfformsMessages.ConditionTypeRenderer_not_set;
    }

    @Override
    protected List<String> getDefinedValues() {
        return new ArrayList<String>(this.environments);
    }

    private Optional<List<String>> names(OperatorGear gear) {
        return Optional.of(((Registry)gear.environments().get()).services().stream().map(Service::id).map(EvaluationType::identifier).collect(Collectors.toList()));
    }
}

