/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.conditions.evaluation;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionParsingException;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionParsingService;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ExpressionProtocol;
import org.eclipse.passage.lic.internal.api.conditions.evaluation.ParsedExpression;
import org.eclipse.passage.lic.internal.base.conditions.evaluation.SimpleMapExpression;
import org.eclipse.passage.lic.internal.base.i18n.ConditionsEvaluationMessages;

public final class BerlinProtocolExpressionParseService
implements ExpressionParsingService {
    private final ExpressionProtocol protocol = new ExpressionProtocol.Berlin();
    private final String separator = ";";
    private final String mediator = "=";

    public ExpressionProtocol id() {
        return this.protocol;
    }

    public ParsedExpression parsed(String expression) throws ExpressionParsingException {
        Objects.requireNonNull(expression);
        HashMap<String, String> couples = new HashMap<String, String>();
        String[] stringArray = expression.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            this.addCouple(segment, couples);
            ++n2;
        }
        if (couples.isEmpty()) {
            throw new ExpressionParsingException(String.format(ConditionsEvaluationMessages.getString("BerlinProtocolExpressionParseService.no_checks"), expression));
        }
        return new SimpleMapExpression(this.protocol, couples);
    }

    private void addCouple(String segment, Map<String, String> couples) throws ExpressionParsingException {
        String[] couple = segment.split("=");
        if (this.coupleIsInvalid(couple)) {
            throw new ExpressionParsingException(String.format(ConditionsEvaluationMessages.getString("BerlinProtocolExpressionParseService.invalid_format"), segment));
        }
        couples.put(couple[0].trim(), couple[1].trim());
    }

    private boolean coupleIsInvalid(String[] couple) {
        return couple.length != 2 || couple[0].trim().isEmpty() || couple[1].trim().isEmpty();
    }
}

