/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.solaris;

import oshi.hardware.common.AbstractComputerSystem;
import oshi.hardware.platform.unix.solaris.SolarisBaseboard;
import oshi.hardware.platform.unix.solaris.SolarisFirmware;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

final class SolarisComputerSystem
extends AbstractComputerSystem {
    private static final long serialVersionUID = 1L;
    private static final String UNKNOWN = "unknown";

    SolarisComputerSystem() {
        this.init();
    }

    private void init() {
        String vendor = "";
        String vendorMarker = "Vendor:";
        String biosDate = "";
        String biosDateMarker = "Release Date:";
        String biosVersion = "";
        String biosVersionMarker = "VersionString:";
        String manufacturer = "";
        String boardManufacturer = "";
        String manufacturerMarker = "Manufacturer:";
        String product = "";
        String model = "";
        String productMarker = "Product:";
        String version = "";
        String versionMarker = "Version:";
        String serialNumber = "";
        String boardSerialNumber = "";
        String serialNumMarker = "Serial Number:";
        SolarisFirmware firmware = new SolarisFirmware();
        SolarisBaseboard baseboard = new SolarisBaseboard();
        boolean smbTypeBIOS = false;
        boolean smbTypeSystem = false;
        boolean smbTypeBaseboard = false;
        for (String checkLine : ExecutingCommand.runNative("smbios")) {
            if (checkLine.contains("SMB_TYPE_")) {
                if (checkLine.contains("SMB_TYPE_BIOS")) {
                    smbTypeBIOS = true;
                    smbTypeSystem = false;
                    smbTypeBaseboard = false;
                } else if (checkLine.contains("SMB_TYPE_SYSTEM")) {
                    smbTypeBIOS = false;
                    smbTypeSystem = true;
                    smbTypeBaseboard = false;
                } else {
                    if (!checkLine.contains("SMB_TYPE_BASEBOARD")) break;
                    smbTypeBIOS = false;
                    smbTypeSystem = false;
                    smbTypeBaseboard = true;
                }
            }
            if (smbTypeBIOS) {
                if (checkLine.contains("Vendor:")) {
                    vendor = checkLine.split("Vendor:")[1].trim();
                    continue;
                }
                if (checkLine.contains("VersionString:")) {
                    biosVersion = checkLine.split("VersionString:")[1].trim();
                    continue;
                }
                if (!checkLine.contains("Release Date:")) continue;
                biosDate = checkLine.split("Release Date:")[1].trim();
                continue;
            }
            if (smbTypeSystem) {
                if (checkLine.contains("Manufacturer:")) {
                    manufacturer = checkLine.split("Manufacturer:")[1].trim();
                    continue;
                }
                if (checkLine.contains("Product:")) {
                    product = checkLine.split("Product:")[1].trim();
                    continue;
                }
                if (!checkLine.contains("Serial Number:")) continue;
                serialNumber = checkLine.split("Serial Number:")[1].trim();
                continue;
            }
            if (!smbTypeBaseboard) continue;
            if (checkLine.contains("Manufacturer:")) {
                boardManufacturer = checkLine.split("Manufacturer:")[1].trim();
                continue;
            }
            if (checkLine.contains("Product:")) {
                model = checkLine.split("Product:")[1].trim();
                continue;
            }
            if (checkLine.contains("Version:")) {
                version = checkLine.split("Version:")[1].trim();
                continue;
            }
            if (!checkLine.contains("Serial Number:")) continue;
            boardSerialNumber = checkLine.split("Serial Number:")[1].trim();
        }
        if (!vendor.isEmpty()) {
            firmware.setManufacturer(vendor);
        }
        if (!biosVersion.isEmpty()) {
            firmware.setVersion(biosVersion);
        }
        if (!biosDate.isEmpty()) {
            try {
                firmware.setReleaseDate(String.format("%s-%s-%s", biosDate.substring(6, 10), biosDate.substring(0, 2), biosDate.substring(3, 5)));
            }
            catch (StringIndexOutOfBoundsException e) {
                firmware.setReleaseDate(biosDate);
            }
        }
        if (!manufacturer.isEmpty()) {
            this.setManufacturer(manufacturer);
        }
        if (!product.isEmpty()) {
            this.setModel(product);
        }
        if (serialNumber.isEmpty()) {
            serialNumber = this.getSystemSerialNumber();
        }
        this.setSerialNumber(serialNumber);
        if (!boardManufacturer.isEmpty()) {
            baseboard.setManufacturer(boardManufacturer);
        }
        if (!model.isEmpty()) {
            baseboard.setModel(model);
        }
        if (!version.isEmpty()) {
            baseboard.setVersion(version);
        }
        if (!boardSerialNumber.isEmpty()) {
            baseboard.setSerialNumber(boardSerialNumber);
        }
        this.setFirmware(firmware);
        this.setBaseboard(baseboard);
    }

    private String getSystemSerialNumber() {
        String serialNumber = ExecutingCommand.getFirstAnswer("sneep");
        if (serialNumber.isEmpty()) {
            String marker = "chassis-sn:";
            for (String checkLine : ExecutingCommand.runNative("prtconf -pv")) {
                if (!checkLine.contains(marker)) continue;
                serialNumber = ParseUtil.getSingleQuoteStringValue(checkLine);
                break;
            }
        }
        if (serialNumber.isEmpty()) {
            serialNumber = UNKNOWN;
        }
        return serialNumber;
    }
}

