/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.reviews.frame.core.model.CommentType;
import org.eclipse.mylyn.reviews.frame.core.model.ReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomaly;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomalyState;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomalyTextPosition;
import org.eclipse.mylyn.reviews.r4e.core.model.R4ECommentType;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EContent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EDecision;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EPosition;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewType;
import org.eclipse.mylyn.reviews.r4e.core.model.RModelFactory;
import org.eclipse.mylyn.reviews.r4e.core.model.drules.R4EDesignRule;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IAnomalyInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EUIDialogFactory;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyExtended;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUITextPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.CommandUtils;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class R4EUIAnomalyContainer
extends R4EUIModelElement {
    public static final String ANOMALY_CONTAINER_ICON_FILE = "icons/obj16/anmlycont_obj.gif";
    private static final String NEW_CHILD_ELEMENT_COMMAND_NAME = "New Anomaly...";
    private static final String NEW_CHILD_ELEMENT_COMMAND_TOOLTIP = "Add a New Global Anomaly to the Current Review Item";
    public static final String CREATE_ANOMALY_MESSAGE = "Creating New Anomaly...";
    private final List<R4EUIAnomalyBasic> fAnomalies;

    public R4EUIAnomalyContainer(IR4EUIModelElement aParent, String aName) {
        super(aParent, aName);
        this.fReadOnly = aParent.isReadOnly();
        this.fAnomalies = new ArrayList<R4EUIAnomalyBasic>();
        this.setImage(ANOMALY_CONTAINER_ICON_FILE);
    }

    public static R4EAnomaly createDetachedAnomaly() {
        R4EAnomaly tempAnomaly = null;
        final IAnomalyInputDialog dialog = R4EUIDialogFactory.getInstance().getAnomalyInputDialog();
        final int[] result = new int[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                result[0] = dialog.open();
            }
        });
        if (result[0] == 0) {
            tempAnomaly = RModelFactory.eINSTANCE.createR4EAnomaly();
            R4ECommentType tempCommentType = RModelFactory.eINSTANCE.createR4ECommentType();
            tempAnomaly.setTitle(dialog.getAnomalyTitleValue());
            tempAnomaly.setDescription(dialog.getAnomalyDescriptionValue());
            tempAnomaly.setDueDate(dialog.getDueDate());
            tempAnomaly.getAssignedTo().add((Object)dialog.getAssigned());
            if (dialog.getRuleReferenceValue() != null) {
                R4EDesignRule rule = dialog.getRuleReferenceValue().getRule();
                tempCommentType.setType(rule.getClass_());
                tempAnomaly.setType((CommentType)tempCommentType);
                tempAnomaly.setRank(rule.getRank());
                tempAnomaly.setRuleID(rule.getId());
            } else {
                if (dialog.getClass_() != null) {
                    R4ECommentType commentType = RModelFactory.eINSTANCE.createR4ECommentType();
                    commentType.setType(dialog.getClass_());
                    tempAnomaly.setType((CommentType)commentType);
                }
                if (dialog.getRank() != null) {
                    tempAnomaly.setRank(dialog.getRank());
                }
            }
        }
        return tempAnomaly;
    }

    @Override
    public List<ReviewComponent> createChildModelDataElement() {
        ArrayList<ReviewComponent> tempAnomalies = new ArrayList<ReviewComponent>();
        R4EUIModelController.setJobInProgress(true);
        IAnomalyInputDialog dialog = R4EUIDialogFactory.getInstance().getAnomalyInputDialog();
        int result = dialog.open();
        if (result == 0) {
            R4EAnomaly tempAnomaly = RModelFactory.eINSTANCE.createR4EAnomaly();
            this.setAnomalyWithDialogValues(tempAnomaly, dialog);
            tempAnomalies.add((ReviewComponent)tempAnomaly);
        }
        R4EUIModelController.setJobInProgress(false);
        return tempAnomalies;
    }

    @Override
    public IR4EUIModelElement[] getChildren() {
        return this.fAnomalies.toArray(new R4EUIAnomalyBasic[this.fAnomalies.size()]);
    }

    @Override
    public boolean hasChildren() {
        return this.fAnomalies.size() > 0;
    }

    @Override
    public void close() {
        R4EUIAnomalyBasic anomaly = null;
        int anomaliesSize = this.fAnomalies.size();
        int i = 0;
        while (i < anomaliesSize) {
            anomaly = this.fAnomalies.get(i);
            anomaly.close();
            ++i;
        }
        this.fAnomalies.clear();
        this.fOpen = false;
    }

    @Override
    public void open() {
        EList anomalies;
        R4EUIAnomalyBasic uiAnomaly = null;
        IR4EUIModelElement parentElement = this.getParent();
        if (parentElement instanceof R4EUIFileContext) {
            List<R4EAnomaly> anomalies2 = ((R4EUIFileContext)parentElement).getAnomalies();
            R4EUITextPosition position = null;
            int anomaliesSize = anomalies2.size();
            R4EAnomaly anomaly = null;
            int i = 0;
            while (i < anomaliesSize) {
                anomaly = anomalies2.get(i);
                if (anomaly.getInfoAtt().get((Object)"originalAnomalyId") == null && (anomaly.isEnabled() || R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled"))) {
                    position = null;
                    EList locations = anomalies2.get(i).getLocation();
                    if (locations != null) {
                        if (locations.get(0) != null) {
                            int locationsSize = locations.size();
                            int j = 0;
                            while (j < locationsSize) {
                                position = new R4EUITextPosition(((R4EContent)anomalies2.get(i).getLocation().get(j)).getLocation());
                                if (((R4EUIReviewBasic)this.getParent().getParent().getParent()).getReview().getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_BASIC)) {
                                    uiAnomaly = new R4EUIAnomalyBasic(this, anomalies2.get(i), position);
                                } else {
                                    uiAnomaly = new R4EUIAnomalyExtended(this, anomalies2.get(i), position);
                                    uiAnomaly.setName(String.valueOf(R4EUIAnomalyExtended.getStateString(anomalies2.get(i).getState())) + ": " + uiAnomaly.getName());
                                }
                                this.addChildren(uiAnomaly);
                                if (uiAnomaly.isEnabled()) {
                                    uiAnomaly.open();
                                }
                                ++j;
                            }
                        } else {
                            uiAnomaly = new R4EUIAnomalyBasic(this, anomalies2.get(i), null);
                            this.addChildren(uiAnomaly);
                            if (uiAnomaly.isEnabled()) {
                                uiAnomaly.open();
                            }
                        }
                    }
                }
                ++i;
            }
        } else if (parentElement instanceof R4EUIReviewBasic && (anomalies = ((R4EUIReviewBasic)parentElement).getReview().getTopics()) != null) {
            int anomaliesSize = anomalies.size();
            R4EAnomaly anomaly = null;
            int i = 0;
            while (i < anomaliesSize) {
                anomaly = (R4EAnomaly)anomalies.get(i);
                if ((anomaly.isEnabled() || R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) && anomaly.getLocation().size() == 0) {
                    if (((R4EUIReviewBasic)this.getParent()).getReview().getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_BASIC)) {
                        uiAnomaly = new R4EUIAnomalyBasic(this, anomaly, null);
                    } else {
                        uiAnomaly = new R4EUIAnomalyExtended(this, anomaly, null);
                        uiAnomaly.setName(String.valueOf(R4EUIAnomalyExtended.getStateString(anomaly.getState())) + ": " + uiAnomaly.getName());
                    }
                    this.addChildren(uiAnomaly);
                    if (uiAnomaly.isEnabled()) {
                        uiAnomaly.open();
                    }
                }
                ++i;
            }
        }
        this.fOpen = true;
    }

    @Override
    public boolean isEnabled() {
        if (this.getParent().isEnabled()) {
            if (this.fAnomalies.size() == 0) {
                return true;
            }
            for (R4EUIAnomalyBasic anomaly : this.fAnomalies) {
                if (!anomaly.isEnabled()) continue;
                return true;
            }
        }
        return false;
    }

    public void setReadOnly(boolean aReadOnly) {
        this.fReadOnly = aReadOnly;
    }

    @Override
    public void addChildren(IR4EUIModelElement aChildToAdd) {
        this.fAnomalies.add((R4EUIAnomalyBasic)aChildToAdd);
    }

    @Override
    public IR4EUIModelElement createChildren(ReviewComponent aModelComponent) throws ResourceHandlingException, OutOfSyncException {
        String user = R4EUIModelController.getReviewer();
        R4EAnomaly anomaly = R4EUIModelController.FModelExt.createR4EAnomaly(R4EUIModelController.getActiveReview().getParticipant(user, true));
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)anomaly, R4EUIModelController.getReviewer());
        anomaly.setTitle(((R4EAnomaly)aModelComponent).getTitle());
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        R4EUIAnomalyBasic addedChild = null;
        if (R4EUIModelController.getActiveReview().getReview().getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_BASIC)) {
            addedChild = new R4EUIAnomalyBasic(this, anomaly, null);
        } else {
            addedChild = new R4EUIAnomalyExtended(this, anomaly, null);
            if (R4EUIModelController.getActiveReview().getReview().getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_FORMAL)) {
                ((R4EUIAnomalyExtended)addedChild).updateState(R4EAnomalyState.R4E_ANOMALY_STATE_CREATED);
            } else {
                ((R4EUIAnomalyExtended)addedChild).updateState(R4EAnomalyState.R4E_ANOMALY_STATE_ASSIGNED);
            }
        }
        addedChild.setModelData(aModelComponent);
        this.addChildren(addedChild);
        return addedChild;
    }

    public void createAnomaly(final R4EFileVersion aAnomalyTempFileVersion, final R4EUITextPosition aUiPosition) {
        final IAnomalyInputDialog dialog = R4EUIDialogFactory.getInstance().getAnomalyInputDialog();
        final int[] result = new int[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                result[0] = dialog.open();
            }
        });
        if (result[0] == 0) {
            Job job = new Job(CREATE_ANOMALY_MESSAGE){
                public String familyName;
                {
                    super($anonymous0);
                    this.familyName = R4EUIConstants.R4E_UI_JOB_FAMILY;
                }

                public boolean belongsTo(Object family) {
                    return this.familyName.equals(family);
                }

                public IStatus run(IProgressMonitor monitor) {
                    try {
                        R4EUIReviewBasic uiReview = R4EUIModelController.getActiveReview();
                        R4EParticipant participant = uiReview.getParticipant(R4EUIModelController.getReviewer(), true);
                        R4EAnomaly anomaly = R4EUIModelController.FModelExt.createR4EAnomaly(participant);
                        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)anomaly, R4EUIModelController.getReviewer());
                        R4EUIAnomalyContainer.this.setAnomalyWithDialogValues(anomaly, dialog);
                        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
                        R4EUIAnomalyBasic uiAnomaly = R4EUIAnomalyContainer.this.createAnomalyDetails(anomaly, aAnomalyTempFileVersion, aUiPosition);
                        R4EUIModelController.setJobInProgress(false);
                        UIUtils.setNavigatorViewFocus(uiAnomaly, -1);
                    }
                    catch (ResourceHandlingException e) {
                        UIUtils.displayResourceErrorDialog(e);
                    }
                    catch (OutOfSyncException e) {
                        UIUtils.displaySyncErrorDialog(e);
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    private void setAnomalyWithDialogValues(R4EAnomaly aAnomaly, IAnomalyInputDialog aDialog) {
        aAnomaly.setTitle(aDialog.getAnomalyTitleValue());
        aAnomaly.setDescription(aDialog.getAnomalyDescriptionValue());
        aAnomaly.setDueDate(aDialog.getDueDate());
        aAnomaly.getAssignedTo().clear();
        aAnomaly.getAssignedTo().add((Object)aDialog.getAssigned());
        if (aDialog.getRuleReferenceValue() != null) {
            R4EDesignRule rule = aDialog.getRuleReferenceValue().getRule();
            R4ECommentType commentType = RModelFactory.eINSTANCE.createR4ECommentType();
            commentType.setType(rule.getClass_());
            aAnomaly.setType((CommentType)commentType);
            aAnomaly.setRank(rule.getRank());
            aAnomaly.setRuleID(rule.getId());
        } else {
            if (aDialog.getClass_() != null) {
                R4ECommentType commentType = RModelFactory.eINSTANCE.createR4ECommentType();
                commentType.setType(aDialog.getClass_());
                aAnomaly.setType((CommentType)commentType);
            }
            if (aDialog.getRank() != null) {
                aAnomaly.setRank(aDialog.getRank());
            }
        }
    }

    public R4EUIAnomalyBasic createAnomalyFromDetached(R4EFileVersion aAnomalyTempFileVersion, R4EAnomaly aModelComponent, R4EUITextPosition aUiPosition) throws ResourceHandlingException, OutOfSyncException {
        String user = R4EUIModelController.getReviewer();
        R4EAnomaly anomaly = R4EUIModelController.FModelExt.createR4EAnomaly(R4EUIModelController.getActiveReview().getParticipant(user, true));
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)anomaly, R4EUIModelController.getReviewer());
        anomaly.setTitle(aModelComponent.getTitle());
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        R4EUIAnomalyBasic uiAnomaly = this.createAnomalyDetails(anomaly, aAnomalyTempFileVersion, aUiPosition);
        uiAnomaly.setModelData((ReviewComponent)aModelComponent);
        return uiAnomaly;
    }

    public R4EUIAnomalyBasic createAnomalyDetails(R4EAnomaly aAnomaly, R4EFileVersion aAnomalyTempFileVersion, R4EUITextPosition aUiPosition) throws ResourceHandlingException, OutOfSyncException {
        R4EUIAnomalyBasic uiAnomaly = null;
        R4EUIReviewBasic uiReview = R4EUIModelController.getActiveReview();
        R4EAnomalyTextPosition position = R4EUIModelController.FModelExt.createR4EAnomalyTextPosition((R4EContent)R4EUIModelController.FModelExt.createR4ETextContent(aAnomaly));
        R4EFileVersion anomalyFileVersion = R4EUIModelController.FModelExt.createR4EFileVersion(position);
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)anomalyFileVersion, R4EUIModelController.getReviewer());
        CommandUtils.copyFileVersionData(anomalyFileVersion, aAnomalyTempFileVersion);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        if (uiReview.getReview().getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_BASIC)) {
            uiAnomaly = new R4EUIAnomalyBasic(this, aAnomaly, aUiPosition);
        } else {
            uiAnomaly = new R4EUIAnomalyExtended(this, aAnomaly, aUiPosition);
            if (uiReview.getReview().getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_FORMAL)) {
                ((R4EUIAnomalyExtended)uiAnomaly).updateState(R4EAnomalyState.R4E_ANOMALY_STATE_CREATED);
            } else {
                ((R4EUIAnomalyExtended)uiAnomaly).updateState(R4EAnomalyState.R4E_ANOMALY_STATE_ASSIGNED);
            }
        }
        aUiPosition.setPositionInModel((R4EPosition)position);
        this.addChildren(uiAnomaly);
        return uiAnomaly;
    }

    @Override
    public void removeChildren(IR4EUIModelElement aChildToRemove, boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        R4EUIAnomalyBasic removedElement = this.fAnomalies.get(this.fAnomalies.indexOf(aChildToRemove));
        removedElement.removeAllChildren(aFileRemove);
        R4EAnomaly modelAnomaly = removedElement.getAnomaly();
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)modelAnomaly, R4EUIModelController.getReviewer());
        modelAnomaly.setEnabled(false);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        if (!R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
            this.fAnomalies.remove(removedElement);
        }
    }

    @Override
    public void removeAllChildren(boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException {
        for (R4EUIAnomalyBasic anomaly : this.fAnomalies) {
            this.removeChildren(anomaly, aFileRemove);
        }
    }

    @Override
    public boolean isNewChildElementCmd() {
        return !this.isReadOnly() && !((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED) && this.getParent().isEnabled() && this.getParent() instanceof R4EUIReviewBasic;
    }

    @Override
    public String getNewChildElementCmdName() {
        return NEW_CHILD_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getNewChildElementCmdTooltip() {
        return NEW_CHILD_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isShowPropertiesCmd() {
        return false;
    }

    public boolean checkCompletionStatus(AtomicReference<String> aMessage) {
        StringBuilder sb = new StringBuilder();
        boolean resultOk = true;
        for (R4EUIAnomalyBasic anomaly : this.fAnomalies) {
            if (anomaly.getAnomaly().getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_CREATED)) {
                sb.append("Anomaly (" + anomaly.getAnomaly().getTitle() + ") is in state CREATED" + R4EUIConstants.LINE_FEED);
                resultOk = false;
                continue;
            }
            if (anomaly.getAnomaly().getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_ASSIGNED)) {
                sb.append("Anomaly (" + anomaly.getAnomaly().getTitle() + ") is in state ASSIGNED" + R4EUIConstants.LINE_FEED);
                resultOk = false;
                continue;
            }
            if (anomaly.getAnomaly().getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_ACCEPTED)) {
                sb.append("Anomaly (" + anomaly.getAnomaly().getTitle() + ") is in state ACCEPTED" + R4EUIConstants.LINE_FEED);
                resultOk = false;
                continue;
            }
            if (anomaly.getAnomaly().getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_FIXED)) {
                if (anomaly.getAnomaly().getFixedByID() == null || "".equals(anomaly.getAnomaly().getFixedByID())) {
                    sb.append("Anomaly (" + anomaly.getAnomaly().getTitle() + ") does not have a fixer" + R4EUIConstants.LINE_FEED);
                    resultOk = false;
                }
                if (!R4EUIModelController.getActiveReview().getReview().getDecision().getValue().equals((Object)R4EDecision.R4E_REVIEW_DECISION_ACCEPTED_FOLLOWUP)) continue;
                sb.append("Anomaly (" + anomaly.getAnomaly().getTitle() + ") is in state FIXED, but Review" + " Decision is set to Accepted with Followup" + R4EUIConstants.LINE_FEED);
                resultOk = false;
                continue;
            }
            if (!anomaly.getAnomaly().getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_VERIFIED) || anomaly.getAnomaly().getFollowUpByID() != null && !"".equals(anomaly.getAnomaly().getFollowUpByID())) continue;
            sb.append("Anomaly (" + anomaly.getAnomaly().getTitle() + ") is in state VERIFIED and " + "does not have a follower" + R4EUIConstants.LINE_FEED);
            resultOk = false;
        }
        if (!resultOk) {
            aMessage.set(sb.toString());
            return false;
        }
        return true;
    }

    public boolean checkReworkStatus(AtomicReference<String> aMessage) {
        StringBuilder sb = new StringBuilder();
        boolean resultOk = true;
        for (R4EUIAnomalyBasic anomaly : this.fAnomalies) {
            if (anomaly.getAnomaly().getState().equals((Object)R4EAnomalyState.R4E_ANOMALY_STATE_CREATED)) {
                sb.append("Anomaly (" + anomaly.getAnomaly().getTitle() + ") is in state CREATED" + R4EUIConstants.LINE_FEED);
                resultOk = false;
                continue;
            }
            if (anomaly.getAnomaly().getDecidedByID() != null && !"".equals(anomaly.getAnomaly().getDecidedByID())) continue;
            sb.append("Anomaly (" + anomaly.getAnomaly().getTitle() + ") does not have a decider" + R4EUIConstants.LINE_FEED);
            resultOk = false;
        }
        if (!resultOk) {
            aMessage.set(sb.toString());
            return false;
        }
        return true;
    }
}

