/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.report.internal.dialog;

import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ReportDirectorySelection
extends Dialog {
    private final int fWIDTH = 400;
    private final int fHEIGHT = 150;
    private final String fTITLE = "R4E Directory selection";
    private final String fOkTooltip = "Consider the new directory as the valid one";
    private final String fCancelTooltip = "Return to the old directory";
    private final String fStorage = "storage";
    private File fReportFolder = null;
    private static Button ok;
    private static Button cancel;
    private DirectoryFieldEditor dirFieldEditor;

    public ReportDirectorySelection(Shell aParentShell) {
        super(aParentShell);
        this.setShellStyle(2160);
    }

    protected Control createDialogArea(Composite aParent) {
        this.getShell().setText("R4E Directory selection");
        Composite composite = (Composite)super.createDialogArea(aParent);
        composite.getShell().setMinimumSize(400, 150);
        this.createDirSelectionWindow(composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite aParent) {
        ok = this.createButton(aParent, 0, IDialogConstants.OK_LABEL, false);
        cancel = this.createButton(aParent, 1, IDialogConstants.CANCEL_LABEL, false);
        ok.setToolTipText("Consider the new directory as the valid one");
        cancel.setToolTipText("Return to the old directory");
    }

    protected void buttonPressed(int aButtonId) {
        if (aButtonId == 0) {
            File fi = this.getFieldDirectory();
            this.setReportDirectory(fi);
            super.close();
        }
        if (aButtonId == 1) {
            super.close();
        }
    }

    private void createDirSelectionWindow(Composite aParent) {
        this.dirFieldEditor = new DirectoryFieldEditor("storage", " &Directory:", aParent);
        this.setTextIntoGrid(aParent);
    }

    private void setTextIntoGrid(Composite aPparent) {
        final Text txt = this.dirFieldEditor.getTextControl(aPparent);
        txt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                txt.setToolTipText(txt.getText());
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        txt.setLayoutData((Object)gridData);
    }

    public void setFieldDirectory(String aSt) {
        this.dirFieldEditor.setStringValue(aSt);
    }

    private File getFieldDirectory() {
        String st = this.dirFieldEditor.getStringValue();
        return new File(st);
    }

    private void setReportDirectory(File afi) {
        this.fReportFolder = afi;
    }

    public File getReportDirectory() {
        return this.fReportFolder;
    }
}

