/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.EditorProxy;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContent;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorTreeViewer;
import org.eclipse.mylyn.reviews.r4e.ui.internal.navigator.ReviewNavigatorView;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.progress.UIJob;

public class SelectNextHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Selecting Next Element...";

    public Object execute(ExecutionEvent aEvent) {
        final IStructuredSelection selection = (IStructuredSelection)R4EUIModelController.getNavigatorView().getTreeViewer().getSelection();
        UIJob job = new UIJob(COMMAND_MESSAGE){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ReviewNavigatorView view;
                IR4EUIModelElement nextElement;
                monitor.beginTask(SelectNextHandler.COMMAND_MESSAGE, 1);
                if (selection != null && !selection.isEmpty() && (nextElement = SelectNextHandler.this.getNextElement((ReviewNavigatorTreeViewer)(view = R4EUIModelController.getNavigatorView()).getTreeViewer())) != null) {
                    R4EUIPlugin.Ftracer.traceInfo("Select next element " + nextElement.getName());
                    StructuredSelection nextSelection = new StructuredSelection((Object)nextElement);
                    view.getTreeViewer().setSelection((ISelection)nextSelection);
                    if (nextElement instanceof R4EUIFileContext || nextElement instanceof R4EUIContent || nextElement instanceof R4EUIAnomalyBasic) {
                        EditorProxy.openEditor(view.getSite().getPage(), (ISelection)nextSelection, false);
                    }
                }
                monitor.worked(1);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    private IR4EUIModelElement getNextElement(ReviewNavigatorTreeViewer aTreeViewer) {
        TreeItem item = aTreeViewer.getTree().getSelection()[0];
        TreeItem nextItem = aTreeViewer.getNext(item);
        return (IR4EUIModelElement)nextItem.getData();
    }
}

