/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.editors;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.List;

public class FilePathEditor
extends ListEditor {
    private static final String ADD_BUTTON_REPL_LABEL = "Add";
    public static final int INVALID_INDEX = -1;
    private String fLastFilePath;
    private String[] fFileExtensions;
    private String fValidator = null;
    private String fInvalidErrorDialogTitle;
    private String fInvalidErrorDialogMsg;

    protected FilePathEditor() {
    }

    public FilePathEditor(String aName, String aLabelText, String[] aFileExtensions, Composite aParent, String aValidator, String aInvalidErrorDialogTitle, String aInvalidErrorDialogMsg) {
        this.init(aName, aLabelText);
        this.fValidator = aValidator;
        this.fInvalidErrorDialogTitle = aInvalidErrorDialogTitle;
        this.fInvalidErrorDialogMsg = aInvalidErrorDialogMsg;
        this.fFileExtensions = (String[])aFileExtensions.clone();
        this.createControl(aParent);
        this.getAddButton().setText(ADD_BUTTON_REPL_LABEL);
    }

    protected String createList(String[] aItems) {
        StringBuffer path = new StringBuffer("");
        String[] stringArray = aItems;
        int n = aItems.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            path.append(item);
            path.append(File.pathSeparator);
            ++n2;
        }
        return path.toString();
    }

    protected String getNewInputObject() {
        String file;
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setFilterExtensions(this.fFileExtensions);
        if (this.fLastFilePath != null && new File(this.fLastFilePath).exists()) {
            dialog.setFilterPath(this.fLastFilePath);
        }
        if ((file = dialog.open()) != null) {
            if ((file = file.trim()).length() == 0) {
                return null;
            }
            if (this.getList().indexOf(file) != -1) {
                return null;
            }
            if (!this.validate(file)) {
                return null;
            }
            this.fLastFilePath = file;
        }
        return file;
    }

    protected String[] parseString(String aStringList) {
        StringTokenizer st = new StringTokenizer(aStringList, String.valueOf(File.pathSeparator) + System.getProperty("line.separator"));
        ArrayList<String> stringArray = new ArrayList<String>();
        while (st.hasMoreElements()) {
            stringArray.add((String)st.nextElement());
        }
        return stringArray.toArray(new String[stringArray.size()]);
    }

    public String getSelection() {
        String[] selections;
        List list = this.getList();
        if (list != null && (selections = list.getSelection()) != null && selections.length > 0) {
            return selections[0];
        }
        return null;
    }

    private boolean validate(String aEntry) {
        if (!(this.fValidator == null || aEntry != null && Pattern.matches(this.fValidator, aEntry))) {
            final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", this.fInvalidErrorDialogTitle, (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, "Entry: " + aEntry + ".  " + this.fInvalidErrorDialogMsg, null), 4);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    dialog.open();
                }
            });
            return false;
        }
        return true;
    }
}

