/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.Theme;

public class DrawData {
    public int style;
    public int[] state = new int[1];
    public Rectangle clientArea;
    public static final int SELECTED = 2;
    public static final int FOCUSED = 4;
    public static final int PRESSED = 8;
    public static final int ACTIVE = 16;
    public static final int DISABLED = 32;
    public static final int HOT = 64;
    public static final int DEFAULTED = 128;
    public static final int GRAYED = 256;
    public static final int DRAW_LEFT = 16;
    public static final int DRAW_TOP = 32;
    public static final int DRAW_RIGHT = 64;
    public static final int DRAW_BOTTOM = 128;
    public static final int DRAW_HCENTER = 256;
    public static final int DRAW_VCENTER = 512;
    public static final int WIDGET_NOWHERE = -1;
    public static final int WIDGET_WHOLE = 0;
    public static final int SCROLLBAR_UP_ARROW = 1;
    public static final int SCROLLBAR_DOWN_ARROW = 2;
    public static final int SCROLLBAR_LEFT_ARROW = 1;
    public static final int SCROLLBAR_RIGHT_ARROW = 2;
    public static final int SCROLLBAR_UP_TRACK = 3;
    public static final int SCROLLBAR_DOWN_TRACK = 4;
    public static final int SCROLLBAR_LEFT_TRACK = 3;
    public static final int SCROLLBAR_RIGHT_TRACK = 4;
    public static final int SCROLLBAR_THUMB = 5;
    public static final int SCALE_UP_TRACK = 1;
    public static final int SCALE_LEFT_TRACK = 1;
    public static final int SCALE_DOWN_TRACK = 2;
    public static final int SCALE_RIGHT_TRACK = 2;
    public static final int SCALE_THUMB = 3;
    public static final int TOOLITEM_ARROW = 1;
    public static final int COMBO_ARROW = 1;

    Rectangle computeTrim(Theme theme, GC gc) {
        return new Rectangle(this.clientArea.x, this.clientArea.y, this.clientArea.width, this.clientArea.height);
    }

    void draw(Theme theme, GC gc, Rectangle bounds) {
    }

    void drawImage(Theme theme, Image image, GC gc, Rectangle bounds) {
        int drawable = gc.getGCData().drawable;
        Rectangle rect = image.getBounds();
        int state_type = this.getStateType(0);
        if (state_type == 0) {
            gc.drawImage(image, 0, 0, rect.width, rect.height, bounds.x, bounds.y, bounds.width, bounds.height);
        } else {
            int pixbuf = ImageList.createPixbuf(image);
            int source = OS.gtk_icon_source_new();
            if (source != 0) {
                OS.gtk_icon_source_set_pixbuf(source, pixbuf);
                int buttonHandle = theme.buttonHandle;
                int gtkStyle = OS.gtk_widget_get_style(buttonHandle);
                theme.transferClipping(gc, gtkStyle);
                int rendered = OS.gtk_style_render_icon(gtkStyle, source, 0, state_type, -1, buttonHandle, null);
                OS.g_object_unref(pixbuf);
                if (rendered != 0) {
                    if (OS.USE_CAIRO) {
                        int cairo = OS.gdk_cairo_create(drawable);
                        OS.gdk_cairo_set_source_pixbuf(cairo, gc.handle, 0.0, 0.0);
                        Cairo.cairo_rectangle(cairo, bounds.x, bounds.y, bounds.width, bounds.height);
                        Cairo.cairo_fill(cairo);
                        Cairo.cairo_destroy(cairo);
                    } else {
                        OS.gdk_draw_pixbuf(drawable, gc.handle, rendered, 0, 0, bounds.x, bounds.y, bounds.width, bounds.height, 1, 0, 0);
                    }
                    OS.g_object_unref(rendered);
                }
                OS.gtk_icon_source_free(source);
            }
        }
    }

    void drawText(Theme theme, String text, int flags, GC gc, Rectangle bounds) {
        int widget = this.getTextHandle(theme);
        int gtkStyle = OS.gtk_widget_get_style(widget);
        int drawable = gc.getGCData().drawable;
        theme.transferClipping(gc, gtkStyle);
        byte[] buffer = Converter.wcsToMbcs(null, text, true);
        int layout = OS.gtk_widget_create_pango_layout(widget, buffer);
        int[] width = new int[1];
        int[] height = new int[1];
        OS.pango_layout_get_pixel_size(layout, width, height);
        OS.pango_layout_set_width(layout, bounds.width * 1024);
        int x = bounds.x;
        int y = bounds.y;
        if ((flags & 0x10) != 0) {
            OS.pango_layout_set_alignment(layout, 0);
        }
        if ((flags & 0x100) != 0) {
            OS.pango_layout_set_alignment(layout, 1);
        }
        if ((flags & 0x40) != 0) {
            OS.pango_layout_set_alignment(layout, 2);
        }
        if ((flags & 0x200) != 0) {
            y += (bounds.height - height[0]) / 2;
        }
        if ((flags & 0x80) != 0) {
            y += bounds.height - height[0];
        }
        int state_type = this.getStateType(0);
        byte[] detail = Converter.wcsToMbcs(null, "label", true);
        this.gtk_render_layout(gtkStyle, drawable, state_type, false, null, widget, detail, x, y, layout);
        OS.g_object_unref(layout);
    }

    Rectangle getBounds(int part, Rectangle bounds) {
        return new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    int getStateType(int part) {
        int state = this.state[part];
        int state_type = 0;
        if ((state & 0x20) != 0) {
            state_type = 4;
        } else {
            if ((state & 2) != 0) {
                state_type = 1;
            }
            if ((state & 0x40) != 0) {
                state_type = (state & 8) != 0 ? 1 : 2;
            }
        }
        return state_type;
    }

    int getTextHandle(Theme theme) {
        return theme.labelHandle;
    }

    int hit(Theme theme, Point position, Rectangle bounds) {
        return -1;
    }

    Rectangle measureText(Theme theme, String text, int flags, GC gc, Rectangle bounds) {
        int widget = this.getTextHandle(theme);
        byte[] buffer = Converter.wcsToMbcs(null, text, true);
        int layout = OS.gtk_widget_create_pango_layout(widget, buffer);
        if (bounds != null) {
            OS.pango_layout_set_width(layout, bounds.width);
        }
        if ((flags & 0x10) != 0) {
            OS.pango_layout_set_alignment(layout, 0);
        }
        if ((flags & 0x100) != 0) {
            OS.pango_layout_set_alignment(layout, 1);
        }
        if ((flags & 0x40) != 0) {
            OS.pango_layout_set_alignment(layout, 2);
        }
        int[] width = new int[1];
        int[] height = new int[1];
        OS.pango_layout_get_pixel_size(layout, width, height);
        OS.g_object_unref(layout);
        return new Rectangle(0, 0, width[0], height[0]);
    }

    void gtk_render_frame(int style, int window, int state_type, int shadow_type, GdkRectangle area, int widget, byte[] detail, int x, int y, int width, int height) {
        if (OS.GTK3) {
            int cairo = OS.gdk_cairo_create(window);
            int context = OS.gtk_widget_get_style_context(style);
            OS.gtk_render_frame(context, cairo, x, y, width, height);
            Cairo.cairo_destroy(cairo);
        } else {
            OS.gtk_paint_flat_box(style, window, state_type, shadow_type, area, widget, detail, x, y, width, height);
        }
    }

    void gtk_render_box(int style, int window, int state_type, int shadow_type, GdkRectangle area, int widget, byte[] detail, int x, int y, int width, int height) {
        if (OS.GTK3) {
            int cairo = OS.gdk_cairo_create(window);
            int context = OS.gtk_widget_get_style_context(style);
            OS.gtk_render_frame(context, cairo, x, y, width, height);
            OS.gtk_render_background(context, cairo, x, y, width, height);
            Cairo.cairo_destroy(cairo);
        } else {
            OS.gtk_paint_box(style, window, state_type, shadow_type, area, widget, detail, x, y, width, height);
        }
    }

    void gtk_render_layout(int style, int window, int state_type, boolean use_text, GdkRectangle area, int widget, byte[] detail, int x, int y, int layout) {
        if (OS.GTK3) {
            int cairo = OS.gdk_cairo_create(window);
            int context = OS.gtk_widget_get_style_context(style);
            OS.gtk_render_layout(context, cairo, x, y, layout);
            Cairo.cairo_destroy(cairo);
        } else {
            OS.gtk_paint_layout(style, window, state_type, use_text, area, widget, detail, x, y, layout);
        }
    }

    void gtk_render_focus(int style, int window, int state_type, GdkRectangle area, int widget, byte[] detail, int x, int y, int width, int height) {
        if (OS.GTK3) {
            int cairo = OS.gdk_cairo_create(window);
            int context = OS.gtk_widget_get_style_context(style);
            OS.gtk_style_context_save(context);
            OS.gtk_style_context_set_state(context, OS.gtk_widget_get_state_flags(widget));
            Cairo.cairo_save(cairo);
            OS.gtk_render_focus(context, cairo, x, y, width, height);
            Cairo.cairo_restore(cairo);
            OS.gtk_style_context_restore(context);
            Cairo.cairo_destroy(cairo);
        } else {
            OS.gtk_paint_focus(style, window, state_type, area, widget, detail, x, y, width, height);
        }
    }

    void gtk_render_arrow(int style, int window, int state_type, int shadow_type, GdkRectangle area, int widget, byte[] detail, int arrow_type, boolean fill, int x, int y, int width, int height) {
        if (OS.GTK3) {
            double angle = 0.0;
            double size = 0.0;
            switch (arrow_type) {
                case 0: {
                    angle = 0.0;
                    size = width;
                    break;
                }
                case 3: {
                    angle = 1.5707963267948966;
                    size = height;
                    break;
                }
                case 1: {
                    angle = Math.PI;
                    size = width;
                    break;
                }
                case 2: {
                    angle = 4.71238898038469;
                    size = height;
                }
            }
            int cairo = OS.gdk_cairo_create(window);
            int context = OS.gtk_widget_get_style_context(style);
            OS.gtk_style_context_set_state(context, state_type);
            OS.gtk_render_background(context, cairo, x, y, width, height);
            OS.gtk_render_frame(context, cairo, x, y, width, height);
            OS.gtk_render_arrow(context, cairo, angle, x, y, size);
            Cairo.cairo_destroy(cairo);
        } else {
            OS.gtk_paint_arrow(style, window, state_type, shadow_type, area, widget, detail, arrow_type, fill, x, y, width, height);
        }
    }
}

