/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import com.ibm.icu.text.Bidi;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.text.SmartBackspaceManager;
import org.eclipse.jdt.internal.ui.text.java.JavaFormattingContext;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class JavaSourceViewer
extends ProjectionViewer
implements IPropertyChangeListener {
    public static final int SHOW_OUTLINE = 51;
    public static final int OPEN_STRUCTURE = 52;
    public static final int SHOW_HIERARCHY = 53;
    public static final int ANNOTATE_CLASS_FILE = 54;
    private IInformationPresenter fOutlinePresenter;
    private IInformationPresenter fStructurePresenter;
    private IInformationPresenter fHierarchyPresenter;
    private Color fForegroundColor;
    private Color fBackgroundColor;
    private Color fSelectionForegroundColor;
    private Color fSelectionBackgroundColor;
    private IPreferenceStore fPreferenceStore;
    private boolean fIsConfigured;
    private SmartBackspaceManager fBackspaceManager;
    private boolean fIsSetVisibleDocumentDelayed = false;
    private static final String BIDI_DELIMITERS = "[ \\p{Punct}&&[^_]]";

    public JavaSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles, IPreferenceStore store) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        this.setPreferenceStore(store);
    }

    public IFormattingContext createFormattingContext() {
        JavaFormattingContext context = new JavaFormattingContext();
        HashMap map = new HashMap(JavaCore.getOptions());
        context.setProperty("formatting.context.preferences", map);
        return context;
    }

    public void doOperation(int operation) {
        if (this.getTextWidget() == null) {
            return;
        }
        switch (operation) {
            case 51: {
                if (this.fOutlinePresenter != null) {
                    this.fOutlinePresenter.showInformation();
                }
                return;
            }
            case 52: {
                if (this.fStructurePresenter != null) {
                    this.fStructurePresenter.showInformation();
                }
                return;
            }
            case 53: {
                if (this.fHierarchyPresenter != null) {
                    this.fHierarchyPresenter.showInformation();
                }
                return;
            }
        }
        super.doOperation(operation);
    }

    public boolean canDoOperation(int operation) {
        if (operation == 51) {
            return this.fOutlinePresenter != null;
        }
        if (operation == 52) {
            return this.fStructurePresenter != null;
        }
        if (operation == 53) {
            return this.fHierarchyPresenter != null;
        }
        return super.canDoOperation(operation);
    }

    public void configure(SourceViewerConfiguration configuration) {
        StyledText textWidget = this.getTextWidget();
        if (textWidget != null && !textWidget.isDisposed()) {
            Color backgroundColor;
            Color foregroundColor = textWidget.getForeground();
            if (foregroundColor != null && foregroundColor.isDisposed()) {
                textWidget.setForeground(null);
            }
            if ((backgroundColor = textWidget.getBackground()) != null && backgroundColor.isDisposed()) {
                textWidget.setBackground(null);
            }
        }
        super.configure(configuration);
        if (configuration instanceof JavaSourceViewerConfiguration) {
            JavaSourceViewerConfiguration javaSVCconfiguration = (JavaSourceViewerConfiguration)configuration;
            this.fOutlinePresenter = javaSVCconfiguration.getOutlinePresenter((ISourceViewer)this, false);
            if (this.fOutlinePresenter != null) {
                this.fOutlinePresenter.install((ITextViewer)this);
            }
            this.fStructurePresenter = javaSVCconfiguration.getOutlinePresenter((ISourceViewer)this, true);
            if (this.fStructurePresenter != null) {
                this.fStructurePresenter.install((ITextViewer)this);
            }
            this.fHierarchyPresenter = javaSVCconfiguration.getHierarchyPresenter((ISourceViewer)this, true);
            if (this.fHierarchyPresenter != null) {
                this.fHierarchyPresenter.install((ITextViewer)this);
            }
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
            this.initializeViewerColors();
        }
        this.fIsConfigured = true;
    }

    protected void initializeViewerColors() {
        if (this.fPreferenceStore != null) {
            StyledText styledText = this.getTextWidget();
            Color color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Foreground", styledText.getDisplay());
            styledText.setForeground(color);
            if (this.fForegroundColor != null) {
                this.fForegroundColor.dispose();
            }
            this.fForegroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background", styledText.getDisplay());
            styledText.setBackground(color);
            if (this.fBackgroundColor != null) {
                this.fBackgroundColor.dispose();
            }
            this.fBackgroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.SelectionForeground", styledText.getDisplay());
            styledText.setSelectionForeground(color);
            if (this.fSelectionForegroundColor != null) {
                this.fSelectionForegroundColor.dispose();
            }
            this.fSelectionForegroundColor = color;
            color = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault") ? null : this.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.SelectionBackground", styledText.getDisplay());
            styledText.setSelectionBackground(color);
            if (this.fSelectionBackgroundColor != null) {
                this.fSelectionBackgroundColor.dispose();
            }
            this.fSelectionBackgroundColor = color;
        }
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    public void adaptBackgroundColor(Control control) {
        Color javaDefaultColor;
        RGB javaDefaultRGB;
        float[] javaDefaultHSB;
        Color defaultColor = control.getBackground();
        float[] defaultBgHSB = defaultColor.getRGB().getHSB();
        if (Math.abs(defaultBgHSB[2] - (javaDefaultHSB = (javaDefaultRGB = (javaDefaultColor = JavaUI.getColorManager().getColor("java_default")) != null ? javaDefaultColor.getRGB() : new RGB(255, 255, 255)).getHSB())[2]) >= 0.5f) {
            this.getTextWidget().setBackground(defaultColor);
            if (this.fBackgroundColor != null) {
                this.fBackgroundColor.dispose();
                this.fBackgroundColor = null;
            }
        }
    }

    public void unconfigure() {
        if (this.fOutlinePresenter != null) {
            this.fOutlinePresenter.uninstall();
            this.fOutlinePresenter = null;
        }
        if (this.fStructurePresenter != null) {
            this.fStructurePresenter.uninstall();
            this.fStructurePresenter = null;
        }
        if (this.fHierarchyPresenter != null) {
            this.fHierarchyPresenter.uninstall();
            this.fHierarchyPresenter = null;
        }
        if (this.fForegroundColor != null) {
            this.fForegroundColor.dispose();
            this.fForegroundColor = null;
        }
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
            this.fBackgroundColor = null;
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        super.unconfigure();
        this.fIsConfigured = false;
    }

    public Point rememberSelection() {
        return super.rememberSelection();
    }

    public void restoreSelection() {
        super.restoreSelection();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("AbstractTextEditor.Color.Foreground".equals(property) || "AbstractTextEditor.Color.Foreground.SystemDefault".equals(property) || "AbstractTextEditor.Color.Background".equals(property) || "AbstractTextEditor.Color.Background.SystemDefault".equals(property) || "AbstractTextEditor.Color.SelectionForeground".equals(property) || "AbstractTextEditor.Color.SelectionForeground.SystemDefault".equals(property) || "AbstractTextEditor.Color.SelectionBackground".equals(property) || "AbstractTextEditor.Color.SelectionBackground.SystemDefault".equals(property)) {
            this.initializeViewerColors();
        }
    }

    public void setPreferenceStore(IPreferenceStore store) {
        if (this.fIsConfigured && this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.fPreferenceStore = store;
        if (this.fIsConfigured && this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
            this.initializeViewerColors();
        }
    }

    protected void createControl(Composite parent, int styles) {
        if ((styles & 0x4000000) == 0 && (styles & 0x2000000) == 0) {
            styles |= 0x2000000;
        }
        final int baseLevel = (styles & 0x4000000) != 0 ? 1 : 0;
        super.createControl(parent, styles);
        this.fBackspaceManager = new SmartBackspaceManager();
        this.fBackspaceManager.install((ITextViewer)this);
        StyledText text = this.getTextWidget();
        text.addBidiSegmentListener(new BidiSegmentListener(){

            public void lineGetSegments(BidiSegmentEvent event) {
                if (JavaSourceViewer.this.redraws()) {
                    try {
                        event.segments = JavaSourceViewer.getBidiLineSegments(JavaSourceViewer.this.getDocument(), baseLevel, JavaSourceViewer.this.widgetOffset2ModelOffset(event.lineOffset), event.lineText);
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
        });
    }

    public SmartBackspaceManager getBackspaceManager() {
        return this.fBackspaceManager;
    }

    protected void handleDispose() {
        if (this.fBackspaceManager != null) {
            this.fBackspaceManager.uninstall();
            this.fBackspaceManager = null;
        }
        super.handleDispose();
    }

    public void prependTextPresentationListener(ITextPresentationListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fTextPresentationListeners == null) {
            this.fTextPresentationListeners = new ArrayList();
        }
        this.fTextPresentationListeners.remove(listener);
        this.fTextPresentationListeners.add(0, listener);
    }

    void setReconciler(IReconciler reconciler) {
        this.fReconciler = reconciler;
    }

    IReconciler getReconciler() {
        return this.fReconciler;
    }

    protected static int[] getBidiLineSegments(IDocument document, int baseLevel, int lineStart, String lineText) throws BadLocationException {
        if (lineText == null || document == null) {
            return null;
        }
        int lineLength = lineText.length();
        if (lineLength <= 2) {
            return null;
        }
        Bidi bidi = new Bidi(lineText, baseLevel);
        if (bidi.isLeftToRight()) {
            return null;
        }
        IRegion line = document.getLineInformationOfOffset(lineStart);
        ITypedRegion[] linePartitioning = TextUtilities.computePartitioning((IDocument)document, (String)"___java_partitioning", (int)lineStart, (int)line.getLength(), (boolean)false);
        if (linePartitioning == null || linePartitioning.length < 1) {
            return null;
        }
        int segmentIndex = 1;
        int[] segments = new int[lineLength + 1];
        byte[] levels = bidi.getLevels();
        int nPartitions = linePartitioning.length;
        int partitionIndex = 0;
        while (partitionIndex < nPartitions) {
            ITypedRegion partition = linePartitioning[partitionIndex];
            int lineOffset = partition.getOffset() - lineStart;
            if (lineOffset > 0 && JavaSourceViewer.isMismatchingLevel(levels[lineOffset], baseLevel) && JavaSourceViewer.isMismatchingLevel(levels[lineOffset - 1], baseLevel)) {
                segments[segmentIndex++] = lineOffset;
            }
            if ("__dftl_partition_content_type".equals(partition.getType())) {
                int partitionEnd = Math.min(lineLength, lineOffset + partition.getLength());
                while (++lineOffset < partitionEnd) {
                    if (!JavaSourceViewer.isMismatchingLevel(levels[lineOffset], baseLevel) || !String.valueOf(lineText.charAt(lineOffset)).matches(BIDI_DELIMITERS)) continue;
                    segments[segmentIndex++] = lineOffset;
                }
            }
            ++partitionIndex;
        }
        if (segmentIndex <= 1) {
            return null;
        }
        segments[0] = 0;
        if (segments[segmentIndex - 1] != lineLength) {
            segments[segmentIndex++] = lineLength;
        }
        if (segmentIndex == segments.length) {
            return segments;
        }
        int[] newSegments = new int[segmentIndex];
        System.arraycopy(segments, 0, newSegments, 0, segmentIndex);
        return newSegments;
    }

    private static boolean isMismatchingLevel(int level, int baseLevel) {
        return ((level ^ baseLevel) & 1) != 0;
    }

    void prepareDelayedProjection() {
        Assert.isTrue((!this.fIsSetVisibleDocumentDelayed ? 1 : 0) != 0);
        this.fIsSetVisibleDocumentDelayed = true;
    }

    protected void setVisibleDocument(IDocument document) {
        if (this.fIsSetVisibleDocumentDelayed) {
            this.fIsSetVisibleDocumentDelayed = false;
            IDocument previous = this.getVisibleDocument();
            this.enableProjection();
            IDocument current = this.getVisibleDocument();
            if (current != null && current != previous) {
                return;
            }
        }
        super.setVisibleDocument(document);
    }

    protected StyleRange modelStyleRange2WidgetStyleRange(StyleRange range) {
        IRegion region = this.modelRange2WidgetRange((IRegion)new Region(range.start, range.length));
        if (region != null) {
            range.start = region.getOffset();
            range.length = region.getLength();
            return range;
        }
        return null;
    }
}

