/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.standalone.ScriptedCommand;
import org.eclipse.update.standalone.StandaloneUpdateApplication;

public class ListFeaturesCommand
extends ScriptedCommand {
    private IConfiguredSite[] sites = this.getConfiguration().getConfiguredSites();

    public ListFeaturesCommand(String fromSite) throws Exception {
        if (fromSite != null) {
            File sitePath = new File(fromSite);
            if (!sitePath.exists()) {
                throw new Exception(String.valueOf(Messages.Standalone_noSite) + fromSite);
            }
            URL fromSiteURL = sitePath.toURL();
            ISite site = SiteManager.getSite(fromSiteURL, null);
            if (site == null) {
                throw new Exception(String.valueOf(Messages.Standalone_noSite) + fromSite);
            }
            IConfiguredSite csite = site.getCurrentConfiguredSite();
            if (csite == null) {
                throw new Exception(String.valueOf(Messages.Standalone_noConfiguredSite) + fromSite);
            }
            this.sites = new IConfiguredSite[]{csite};
        }
    }

    public boolean run(IProgressMonitor monitor) {
        try {
            if (this.sites != null) {
                int i = 0;
                while (i < this.sites.length) {
                    System.out.println("Site: " + this.sites[i].getSite().getURL());
                    IFeatureReference[] features = this.sites[i].getFeatureReferences();
                    int f = 0;
                    while (f < features.length) {
                        boolean configured = this.sites[i].isConfigured(features[f].getFeature(null));
                        System.out.println("  Feature: " + features[f].getVersionedIdentifier().getIdentifier() + " " + features[f].getVersionedIdentifier().getVersion() + "  " + (configured ? "enabled" : "disabled"));
                        ++f;
                    }
                    ++i;
                }
            }
            return true;
        }
        catch (CoreException e) {
            StandaloneUpdateApplication.exceptionLogged();
            UpdateCore.log(e);
            return false;
        }
    }
}

