/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleTableAdapter;
import org.eclipse.swt.accessibility.AccessibleTableEvent;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSValue;

class AccessibleTableRow
extends Accessible {
    public AccessibleTableRow(Accessible accessible, int childID) {
        super(accessible);
        this.index = childID;
        this.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = Math.max(1, AccessibleTableRow.this.parent.getColumnCount());
            }

            public void getChildren(AccessibleControlEvent e) {
                int validColumnCount = Math.max(1, AccessibleTableRow.this.parent.getColumnCount());
                Object[] children = new Object[validColumnCount];
                AccessibleTableEvent event = new AccessibleTableEvent(this);
                int i = 0;
                while (i < validColumnCount) {
                    event.column = i;
                    event.row = AccessibleTableRow.this.index;
                    int j = 0;
                    while (j < AccessibleTableRow.this.parent.accessibleTableListeners.size()) {
                        AccessibleTableListener listener = AccessibleTableRow.this.parent.accessibleTableListeners.get(j);
                        listener.getCell(event);
                        ++j;
                    }
                    if (event.accessible != null) {
                        event.accessible.parent = AccessibleTableRow.this;
                    }
                    children[i] = event.accessible;
                    ++i;
                }
                e.children = children;
            }

            public void getLocation(AccessibleControlEvent e) {
                int validColumnCount = Math.max(1, AccessibleTableRow.this.parent.getColumnCount());
                Accessible[] children = new Accessible[validColumnCount];
                AccessibleTableEvent event = new AccessibleTableEvent(this);
                int i = 0;
                while (i < validColumnCount) {
                    event.column = i;
                    event.row = AccessibleTableRow.this.index;
                    int j = 0;
                    while (j < AccessibleTableRow.this.parent.accessibleTableListeners.size()) {
                        AccessibleTableListener listener = AccessibleTableRow.this.parent.accessibleTableListeners.get(j);
                        listener.getCell(event);
                        ++j;
                    }
                    children[i] = event.accessible;
                    ++i;
                }
                NSValue positionObj = (NSValue)children[0].getPositionAttribute(-1);
                NSPoint position = positionObj.pointValue();
                int height = 0;
                int width = 0;
                int j = 0;
                while (j < children.length) {
                    NSValue sizeObj = (NSValue)children[j].getSizeAttribute(-1);
                    NSSize size = sizeObj.sizeValue();
                    if (size.height > (double)height) {
                        height = (int)size.height;
                    }
                    width = (int)((double)width + size.width);
                    ++j;
                }
                e.x = (int)position.x;
                NSArray screens = NSScreen.screens();
                NSScreen screen = new NSScreen(screens.objectAtIndex(0L));
                NSRect frame = screen.frame();
                e.y = (int)(frame.height - position.y - (double)height);
                e.width = width;
                e.height = height;
            }

            public void getRole(AccessibleControlEvent e) {
                int childID = e.childID;
                e.detail = childID == -1 ? 28 : 29;
            }

            public void getFocus(AccessibleControlEvent e) {
                NSNumber focusedObj;
                AccessibleTableEvent event = new AccessibleTableEvent(this);
                event.column = 0;
                event.row = AccessibleTableRow.this.index;
                int j = 0;
                while (j < AccessibleTableRow.this.parent.accessibleTableListeners.size()) {
                    AccessibleTableListener listener = AccessibleTableRow.this.parent.accessibleTableListeners.get(j);
                    listener.getCell(event);
                    ++j;
                }
                e.childID = event.accessible != null ? ((focusedObj = (NSNumber)event.accessible.getFocusedAttribute(-1)).boolValue() ? -1 : -2) : -2;
            }
        });
        this.addAccessibleTableListener(new AccessibleTableAdapter(){

            public void isColumnSelected(AccessibleTableEvent e) {
                e.isSelected = false;
            }

            public void isRowSelected(AccessibleTableEvent e) {
                AccessibleTableEvent event = new AccessibleTableEvent(this);
                event.row = e.row;
                int i = 0;
                while (i < AccessibleTableRow.this.parent.accessibleTableListeners.size()) {
                    AccessibleTableListener listener = AccessibleTableRow.this.parent.accessibleTableListeners.get(i);
                    listener.isRowSelected(event);
                    ++i;
                }
                e.isSelected = event.isSelected;
            }
        });
    }

    void getChildAtPoint(AccessibleControlEvent e) {
        int validColumnCount = Math.max(1, this.parent.getColumnCount());
        Accessible[] children = new Accessible[validColumnCount];
        AccessibleTableEvent event = new AccessibleTableEvent(this);
        int i = 0;
        while (i < validColumnCount) {
            event.column = i;
            event.row = this.index;
            int j = 0;
            while (j < this.parent.accessibleTableListeners.size()) {
                AccessibleTableListener listener = this.parent.accessibleTableListeners.get(j);
                listener.getCell(event);
                ++j;
            }
            children[i] = event.accessible;
            ++i;
        }
        int j = 0;
        while (j < children.length) {
            NSValue positionObj = (NSValue)children[j].getPositionAttribute(this.index);
            NSPoint position = positionObj.pointValue();
            NSValue sizeObj = (NSValue)children[j].getSizeAttribute(this.index);
            NSSize size = sizeObj.sizeValue();
            if (position.x <= (double)e.x && (double)e.x <= position.x + size.width) {
                children[j].parent = this;
                e.accessible = children[j];
                break;
            }
            ++j;
        }
    }
}

