/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaRestriction;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.schema.SchemaAttribute;
import org.eclipse.pde.internal.core.schema.SchemaSimpleType;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.schema.AbstractSchemaDetails;
import org.eclipse.pde.internal.ui.editor.schema.ElementSection;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.parts.ComboPart;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class SchemaAttributeDetails
extends AbstractSchemaDetails {
    private SchemaAttribute fAttribute;
    private FormEntry fValue;
    private FormEntry fName;
    private Button fDepTrue;
    private Button fDepFalse;
    private ComboPart fType;
    private ComboPart fUseDefault;
    private ComboPart fUseOther;
    private StackLayout fUseLayout;
    private Composite fUseComp;
    private Composite fUseCompDefault;
    private Composite fUseCompOther;

    public SchemaAttributeDetails(ElementSection section) {
        super(section, false, true);
    }

    @Override
    public void createDetails(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Color foreground = toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE");
        this.fName = new FormEntry(parent, toolkit, PDEUIMessages.SchemaDetails_name, 0);
        ((GridData)this.fName.getLabel().getLayoutData()).widthHint = this.minLabelWeight;
        Label label = toolkit.createLabel(parent, PDEUIMessages.SchemaDetails_deprecated);
        label.setForeground(foreground);
        Button[] buttons = this.createTrueFalseButtons(parent, toolkit, 2);
        this.fDepTrue = buttons[0];
        this.fDepFalse = buttons[1];
        label = toolkit.createLabel(parent, PDEUIMessages.SchemaAttributeDetails_use);
        label.setForeground(foreground);
        this.fUseComp = toolkit.createComposite(parent);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fUseComp.setLayoutData((Object)gd);
        this.fUseLayout = new StackLayout();
        this.fUseComp.setLayout((Layout)this.fUseLayout);
        this.fUseCompDefault = toolkit.createComposite(this.fUseComp);
        this.fUseCompDefault.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).create());
        this.fUseDefault = this.createComboPart(this.fUseCompDefault, toolkit, ISchemaAttribute.USE_TABLE, 1, 0);
        this.fValue = new FormEntry(this.fUseCompDefault, toolkit, null, 0, 1);
        this.fUseCompOther = toolkit.createComposite(this.fUseComp);
        this.fUseCompOther.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).create());
        this.fUseOther = this.createComboPart(this.fUseCompOther, toolkit, ISchemaAttribute.USE_TABLE, 1);
        label = toolkit.createLabel(parent, PDEUIMessages.SchemaAttributeDetails_type);
        label.setForeground(foreground);
        this.fType = this.createComboPart(parent, toolkit, ISchemaAttribute.TYPES, 2);
        this.createTypeDetails(parent, toolkit);
        toolkit.paintBordersFor(parent);
        this.setText(PDEUIMessages.SchemaAttributeDetails_title);
    }

    protected abstract void createTypeDetails(Composite var1, FormToolkit var2);

    @Override
    public void updateFields(ISchemaObject object) {
        if (!(object instanceof SchemaAttribute)) {
            return;
        }
        this.fAttribute = (SchemaAttribute)object;
        this.setDecription(NLS.bind((String)PDEUIMessages.SchemaAttributeDetails_description, (Object)this.fAttribute.getName()));
        this.fName.setValue(this.fAttribute.getName(), true);
        this.fDepTrue.setSelection(this.fAttribute.isDeprecated());
        this.fDepFalse.setSelection(!this.fAttribute.isDeprecated());
        boolean isStringType = this.fAttribute.getType().getName().equals(ISchemaAttribute.TYPES[1]);
        int kind = this.fAttribute.getKind();
        this.fType.select(isStringType ? 1 + kind : 0);
        this.fUseDefault.select(this.fAttribute.getUse());
        this.fUseOther.select(this.fAttribute.getUse());
        Object value = this.fAttribute.getValue();
        this.fValue.setValue(value != null ? value.toString() : PDEUIMessages.SchemaAttributeDetails_defaultDefaultValue, true);
        boolean editable = this.isEditableElement();
        this.fUseLayout.topControl = this.fAttribute.getUse() != 2 ? this.fUseCompOther : this.fUseCompDefault;
        this.fUseComp.layout();
        this.fName.setEditable(editable);
        this.fDepTrue.setEnabled(editable);
        this.fDepFalse.setEnabled(editable);
        this.fType.setEnabled(editable);
        this.fUseDefault.setEnabled(editable);
        this.fUseOther.setEnabled(editable);
        this.fValue.setEditable(editable);
    }

    @Override
    public void hookListeners() {
        this.fValue.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry entry) {
                if (SchemaAttributeDetails.this.blockListeners()) {
                    return;
                }
                SchemaAttributeDetails.this.fAttribute.setValue(SchemaAttributeDetails.this.fValue.getValue());
            }
        });
        this.fName.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void textValueChanged(FormEntry entry) {
                if (SchemaAttributeDetails.this.blockListeners()) {
                    return;
                }
                boolean revert = false;
                if (SchemaAttributeDetails.this.fName.getValue().length() == 0) {
                    revert = true;
                } else {
                    ISchemaObject parent = SchemaAttributeDetails.this.fAttribute.getParent();
                    while (!(parent instanceof ISchemaElement)) {
                        parent = parent.getParent();
                    }
                    ISchemaElement element = (ISchemaElement)parent;
                    ISchemaAttribute[] attributes = element.getAttributes();
                    int i = 0;
                    while (i < attributes.length) {
                        if (attributes[i] != SchemaAttributeDetails.this.fAttribute && attributes[i].getName().equalsIgnoreCase(SchemaAttributeDetails.this.fName.getValue())) {
                            revert = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (revert) {
                    SchemaAttributeDetails.this.fName.setValue(SchemaAttributeDetails.this.fAttribute.getName(), true);
                } else {
                    SchemaAttributeDetails.this.fAttribute.setName(SchemaAttributeDetails.this.fName.getValue());
                    SchemaAttributeDetails.this.setDecription(NLS.bind((String)PDEUIMessages.SchemaAttributeDetails_description, (Object)SchemaAttributeDetails.this.fAttribute.getName()));
                }
            }
        });
        this.fDepTrue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SchemaAttributeDetails.this.blockListeners()) {
                    return;
                }
                SchemaAttributeDetails.this.fAttribute.setDeprecatedProperty(SchemaAttributeDetails.this.fDepTrue.getSelection());
            }
        });
        this.fType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SchemaAttributeDetails.this.blockListeners()) {
                    return;
                }
                String typeString = SchemaAttributeDetails.this.fType.getSelection();
                if (!typeString.equals(ISchemaAttribute.TYPES[0])) {
                    typeString = ISchemaAttribute.TYPES[1];
                }
                SchemaAttributeDetails.this.fAttribute.setType((ISchemaSimpleType)new SchemaSimpleType(SchemaAttributeDetails.this.fAttribute.getSchema(), typeString));
                int kind = SchemaAttributeDetails.this.fType.getSelectionIndex() - 1;
                SchemaAttributeDetails.this.fAttribute.setKind(kind > 0 ? kind : 0);
                ISchemaSimpleType type = SchemaAttributeDetails.this.fAttribute.getType();
                if (type instanceof SchemaSimpleType && kind != 0 && ((SchemaSimpleType)type).getRestriction() != null) {
                    ((SchemaSimpleType)type).setRestriction(null);
                }
                SchemaAttributeDetails.this.fireSelectionChange();
            }
        });
        this.fUseDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SchemaAttributeDetails.this.blockListeners()) {
                    return;
                }
                int i = SchemaAttributeDetails.this.fUseDefault.getSelectionIndex();
                SchemaAttributeDetails.this.setBlockListeners(true);
                SchemaAttributeDetails.this.fUseOther.select(i);
                SchemaAttributeDetails.this.setBlockListeners(false);
                SchemaAttributeDetails.this.doUseChange(i);
            }
        });
        this.fUseOther.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SchemaAttributeDetails.this.blockListeners()) {
                    return;
                }
                int i = SchemaAttributeDetails.this.fUseOther.getSelectionIndex();
                SchemaAttributeDetails.this.setBlockListeners(true);
                SchemaAttributeDetails.this.fUseDefault.select(i);
                SchemaAttributeDetails.this.setBlockListeners(false);
                SchemaAttributeDetails.this.doUseChange(i);
            }
        });
    }

    private void doUseChange(int index) {
        this.fAttribute.setUse(index);
        if (index == 2) {
            this.fUseLayout.topControl = this.fUseCompDefault;
            this.fUseComp.layout();
            if (this.fValue.getValue().equals(PDEUIMessages.SchemaAttributeDetails_defaultDefaultValue)) {
                this.fValue.getText().setSelection(0, this.fValue.getValue().length());
            }
            this.fValue.getText().setFocus();
        } else if (index != 2) {
            this.fUseLayout.topControl = this.fUseCompOther;
            this.fUseComp.layout();
            this.fValue.setValue(PDEUIMessages.SchemaAttributeDetails_defaultDefaultValue);
            this.fUseCompOther.setFocus();
        }
    }

    @Override
    public void modelChanged(IModelChangedEvent event) {
        Object[] changedObjs = event.getChangedObjects();
        if (event.getChangeType() == 1 && changedObjs.length > 0 && changedObjs[0] instanceof SchemaAttribute) {
            this.fName.getText().setFocus();
        }
        super.modelChanged(event);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
        this.fName.commit();
        this.fValue.commit();
    }

    protected SchemaAttribute getAttribute() {
        return this.fAttribute;
    }

    class SchemaAttributeContentProvider
    extends DefaultTableProvider {
        SchemaAttributeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ISchemaSimpleType type = SchemaAttributeDetails.this.fAttribute.getType();
            ISchemaRestriction restriction = type.getRestriction();
            if (restriction != null) {
                return restriction.getChildren();
            }
            return new Object[0];
        }
    }
}

