/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.ischema.IDocumentSection;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaComplexType;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaType;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.schema.SchemaFormPage;
import org.eclipse.pde.internal.ui.editor.schema.SchemaOverviewPage;

public class SchemaFormOutlinePage
extends FormOutlinePage {
    private Object[] fTopics;

    @Override
    public Object[] getChildren(Object parent) {
        ISchema schema = (ISchema)this.fEditor.getAggregateModel();
        if (schema != null && schema.isValid()) {
            if (parent instanceof SchemaFormPage) {
                return this.getMarkup();
            }
            if (parent instanceof ISchemaElement) {
                return this.getAttributes((ISchemaElement)parent);
            }
            if (parent instanceof SchemaOverviewPage) {
                return this.getTopics();
            }
        }
        return super.getChildren(parent);
    }

    public SchemaFormOutlinePage(PDEFormEditor editor) {
        super(editor);
    }

    @Override
    public ILabelProvider createLabelProvider() {
        return new SchemaLabelProvider((ILabelProvider)PDEPlugin.getDefault().getLabelProvider());
    }

    protected Object[] createTopics() {
        ISchema schema = (ISchema)this.fEditor.getAggregateModel();
        IDocumentSection[] sections = schema.getDocumentSections();
        Object[] result = new Object[sections.length + 1];
        result[0] = schema;
        int i = 1;
        while (i <= sections.length) {
            result[i] = sections[i - 1];
            ++i;
        }
        return result;
    }

    private Object[] getAttributes(ISchemaElement element) {
        ISchemaType type = element.getType();
        if (type instanceof ISchemaComplexType) {
            return ((ISchemaComplexType)type).getAttributes();
        }
        return new Object[0];
    }

    private Object[] getMarkup() {
        ISchema schema = (ISchema)this.fEditor.getAggregateModel();
        return schema.getElements();
    }

    protected String getObjectLabel(Object obj) {
        if (obj instanceof ISchema) {
            return PDEUIMessages.SchemaEditor_topic_overview;
        }
        if (obj instanceof IDocumentSection) {
            IDocumentSection section = (IDocumentSection)obj;
            String sectionId = section.getSectionId();
            if (sectionId.equals("examples")) {
                return PDEUIMessages.SchemaEditor_topic_examples;
            }
            if (sectionId.equals("since")) {
                return PDEUIMessages.SchemaEditor_topic_since;
            }
            if (sectionId.equals("implementation")) {
                return PDEUIMessages.SchemaEditor_topic_implementation;
            }
            if (sectionId.equalsIgnoreCase("apiinfo")) {
                return PDEUIMessages.SchemaEditor_topic_api;
            }
            if (sectionId.equals("copyright")) {
                return PDEUIMessages.SchemaEditor_topic_copyright;
            }
        }
        return null;
    }

    Object[] getTopics() {
        if (this.fTopics == null) {
            this.fTopics = this.createTopics();
        }
        return this.fTopics;
    }

    @Override
    protected String getParentPageId(Object item) {
        if (item instanceof ISchemaElement || item instanceof ISchemaAttribute) {
            return "form";
        }
        if (item instanceof IDocumentSection || item instanceof ISchema) {
            return "overview";
        }
        return super.getParentPageId(item);
    }

    @Override
    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.fTopics = null;
            this.fTreeViewer.refresh();
            return;
        }
        Object object = event.getChangedObjects()[0];
        if (event.getChangeType() == 3) {
            this.fTreeViewer.update(object, null);
        } else {
            ISchemaObject parent = null;
            if (object instanceof ISchemaObject) {
                parent = ((ISchemaObject)object).getParent();
            }
            if (parent != null) {
                this.fTreeViewer.refresh((Object)parent);
                this.fTreeViewer.expandToLevel((Object)parent, 2);
            } else {
                this.fTreeViewer.refresh();
                this.fTreeViewer.expandAll();
            }
        }
    }

    class SchemaLabelProvider
    extends FormOutlinePage.BasicLabelProvider {
        public SchemaLabelProvider(ILabelProvider ilp) {
            super(SchemaFormOutlinePage.this, ilp);
        }

        @Override
        public String getText(Object obj) {
            String label = SchemaFormOutlinePage.this.getObjectLabel(obj);
            return label == null ? super.getText(obj) : label;
        }
    }
}

