/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.ui.editor.toc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IEditingModel;
import org.eclipse.pde.internal.ua.core.toc.text.Toc;
import org.eclipse.pde.internal.ua.core.toc.text.TocModel;
import org.eclipse.pde.internal.ui.editor.AbstractFoldingStructureProvider;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;

public class TocFoldingStructureProvider
extends AbstractFoldingStructureProvider {
    private Map fPositionToElement = new HashMap();

    public TocFoldingStructureProvider(PDESourcePage editor, IEditingModel model) {
        super(editor, model);
    }

    public void addFoldingRegions(Set currentRegions, IEditingModel model) throws BadLocationException {
        Toc toc = ((TocModel)model).getToc();
        List childList = toc.getChildren();
        IDocumentElementNode[] children = childList.toArray(new IDocumentElementNode[childList.size()]);
        this.addFoldingRegions(currentRegions, children, model.getDocument());
    }

    private void addFoldingRegions(Set regions, IDocumentElementNode[] nodes, IDocument document) throws BadLocationException {
        int i = 0;
        while (i < nodes.length) {
            IDocumentElementNode[] children;
            int endLine;
            IDocumentElementNode element = nodes[i];
            int startLine = document.getLineOfOffset(element.getOffset());
            if (startLine < (endLine = document.getLineOfOffset(element.getOffset() + element.getLength()))) {
                int start = document.getLineOffset(startLine);
                int end = document.getLineOffset(endLine) + document.getLineLength(endLine);
                Position position = new Position(start, end - start);
                regions.add(position);
                this.fPositionToElement.put(position, element);
            }
            if ((children = element.getChildNodes()) != null) {
                this.addFoldingRegions(regions, children, document);
            }
            ++i;
        }
    }
}

