/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.browsing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.help.IContextProvider;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.jdt.internal.ui.actions.NewWizardsActionGroup;
import org.eclipse.jdt.internal.ui.browsing.JavaBrowsingContentProvider;
import org.eclipse.jdt.internal.ui.browsing.JavaBrowsingMessages;
import org.eclipse.jdt.internal.ui.browsing.JavaElementTypeComparator;
import org.eclipse.jdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.jdt.internal.ui.browsing.MembersView;
import org.eclipse.jdt.internal.ui.browsing.PackagesView;
import org.eclipse.jdt.internal.ui.browsing.PatchedOpenInNewWindowAction;
import org.eclipse.jdt.internal.ui.browsing.ToggleLinkingAction;
import org.eclipse.jdt.internal.ui.dnd.JdtViewerDragSupport;
import org.eclipse.jdt.internal.ui.dnd.JdtViewerDropSupport;
import org.eclipse.jdt.internal.ui.infoviews.AbstractInfoView;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.internal.ui.util.JavaUIHelp;
import org.eclipse.jdt.internal.ui.util.SelectionUtil;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemTableViewer;
import org.eclipse.jdt.internal.ui.viewsupport.StatusBarUpdater;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.actions.BuildActionGroup;
import org.eclipse.jdt.ui.actions.CCPActionGroup;
import org.eclipse.jdt.ui.actions.CustomFiltersActionGroup;
import org.eclipse.jdt.ui.actions.GenerateActionGroup;
import org.eclipse.jdt.ui.actions.ImportActionGroup;
import org.eclipse.jdt.ui.actions.JavaSearchActionGroup;
import org.eclipse.jdt.ui.actions.OpenEditorActionGroup;
import org.eclipse.jdt.ui.actions.OpenViewActionGroup;
import org.eclipse.jdt.ui.actions.RefactorActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.AbstractMultiEditor;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JavaBrowsingPart
extends ViewPart
implements IMenuListener,
IViewPartInputProvider,
INullSelectionListener {
    private static final String TAG_SELECTED_ELEMENTS = "selectedElements";
    private static final String TAG_SELECTED_ELEMENT = "selectedElement";
    private static final String TAG_LOGICAL_PACKAGE = "logicalPackage";
    private static final String TAG_SELECTED_ELEMENT_PATH = "selectedElementPath";
    private JavaUILabelProvider fLabelProvider;
    private ILabelProvider fTitleProvider;
    private StructuredViewer fViewer;
    private IMemento fMemento;
    private JavaElementTypeComparator fTypeComparator;
    private JdtViewerDropSupport fDropSupport;
    private WorkingSetFilterActionGroup fWorkingSetFilterActionGroup;
    private boolean fHasWorkingSetFilter = true;
    private boolean fHasCustomFilter = true;
    private OpenEditorActionGroup fOpenEditorGroup;
    private CCPActionGroup fCCPActionGroup;
    private BuildActionGroup fBuildActionGroup;
    private ToggleLinkingAction fToggleLinkingAction;
    protected CompositeActionGroup fActionGroups;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;
    protected IWorkbenchPart fPreviousSelectionProvider;
    protected Object fPreviousSelectedElement;
    private boolean fLinkingEnabled;
    private boolean fProcessSelectionEvents = true;
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (ref != null && ref.getId() == JavaBrowsingPart.this.getSite().getId()) {
                ISelection selection;
                JavaBrowsingPart.this.fProcessSelectionEvents = true;
                IWorkbenchPage page = JavaBrowsingPart.this.getSite().getWorkbenchWindow().getActivePage();
                if (page != null && (selection = page.getSelection()) != null) {
                    JavaBrowsingPart.this.selectionChanged(page.getActivePart(), selection);
                }
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (ref != null && ref.getId() == JavaBrowsingPart.this.getSite().getId()) {
                JavaBrowsingPart.this.fProcessSelectionEvents = false;
            }
        }
    };
    private OpenAndLinkWithEditorHelper fOpenAndLinkWithEditorHelper;

    public JavaBrowsingPart() {
        this.initLinkingEnabled();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fMemento = memento;
    }

    public void saveState(IMemento memento) {
        if (this.fViewer == null) {
            if (this.fMemento != null) {
                memento.putMemento(this.fMemento);
            }
            return;
        }
        if (this.fHasWorkingSetFilter) {
            this.fWorkingSetFilterActionGroup.saveState(memento);
        }
        if (this.fHasCustomFilter) {
            this.fCustomFiltersActionGroup.saveState(memento);
        }
        this.saveSelectionState(memento);
        this.saveLinkingEnabled(memento);
    }

    private void saveLinkingEnabled(IMemento memento) {
        memento.putInteger(this.getLinkToEditorKey(), this.fLinkingEnabled ? 1 : 0);
    }

    private void saveSelectionState(IMemento memento) {
        Object[] elements = ((IStructuredSelection)this.fViewer.getSelection()).toArray();
        if (elements.length > 0) {
            IMemento selectionMem = memento.createChild(TAG_SELECTED_ELEMENTS);
            int i = 0;
            while (i < elements.length) {
                IMemento elementMem = selectionMem.createChild(TAG_SELECTED_ELEMENT);
                Object o = elements[i];
                if (o instanceof IJavaElement) {
                    elementMem.putString(TAG_SELECTED_ELEMENT_PATH, ((IJavaElement)elements[i]).getHandleIdentifier());
                } else if (o instanceof LogicalPackage) {
                    IPackageFragment[] packages = ((LogicalPackage)((Object)o)).getFragments();
                    int j = 0;
                    while (j < packages.length) {
                        IMemento packageMem = elementMem.createChild(TAG_LOGICAL_PACKAGE);
                        packageMem.putString(TAG_SELECTED_ELEMENT_PATH, packages[j].getHandleIdentifier());
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    protected void restoreState(IMemento memento) {
        if (this.fHasWorkingSetFilter) {
            this.fWorkingSetFilterActionGroup.restoreState(memento);
        }
        if (this.fHasCustomFilter) {
            this.fCustomFiltersActionGroup.restoreState(memento);
        }
        if (this.fHasCustomFilter || this.fHasWorkingSetFilter) {
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.refresh();
            this.fViewer.getControl().setRedraw(true);
        }
    }

    private ISelection restoreSelectionState(IMemento memento) {
        if (memento == null) {
            return null;
        }
        IMemento childMem = memento.getChild(TAG_SELECTED_ELEMENTS);
        if (childMem != null) {
            ArrayList<LogicalPackage> list = new ArrayList<LogicalPackage>();
            IMemento[] elementMem = childMem.getChildren(TAG_SELECTED_ELEMENT);
            int i = 0;
            while (i < elementMem.length) {
                String javaElementHandle = elementMem[i].getString(TAG_SELECTED_ELEMENT_PATH);
                if (javaElementHandle == null) {
                    IMemento[] packagesMem = elementMem[i].getChildren(TAG_LOGICAL_PACKAGE);
                    LogicalPackage lp = null;
                    int j = 0;
                    while (j < packagesMem.length) {
                        javaElementHandle = packagesMem[j].getString(TAG_SELECTED_ELEMENT_PATH);
                        IJavaElement pack = JavaCore.create((String)javaElementHandle);
                        if (pack instanceof IPackageFragment && ((IPackageFragment)pack).exists()) {
                            if (lp == null) {
                                lp = new LogicalPackage((IPackageFragment)pack);
                            } else {
                                lp.add((IPackageFragment)pack);
                            }
                        }
                        ++j;
                    }
                    if (lp != null) {
                        list.add(lp);
                    }
                } else {
                    IJavaElement element = JavaCore.create((String)javaElementHandle);
                    if (element != null && element.exists()) {
                        list.add((LogicalPackage)element);
                    }
                }
                ++i;
            }
            return new StructuredSelection(list);
        }
        return null;
    }

    private void restoreLinkingEnabled(IMemento memento) {
        Integer val = memento.getInteger(this.getLinkToEditorKey());
        if (val != null) {
            this.fLinkingEnabled = val != 0;
        }
    }

    public void createPartControl(Composite parent) {
        Assert.isTrue((this.fViewer == null ? 1 : 0) != 0);
        this.fTypeComparator = new JavaElementTypeComparator();
        this.fViewer = this.createViewer(parent);
        this.initDragAndDrop();
        this.fLabelProvider = this.createLabelProvider();
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.createDecoratingLabelProvider(this.fLabelProvider));
        this.fViewer.setComparator((ViewerComparator)this.createJavaElementComparator());
        this.fViewer.setUseHashlookup(true);
        this.fTitleProvider = this.createTitleProvider();
        this.createContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        if (this.fMemento != null) {
            this.restoreLinkingEnabled(this.fMemento);
        }
        this.createActions();
        this.addKeyListener();
        if (this.fMemento != null) {
            this.restoreState(this.fMemento);
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.fViewer);
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fViewer.addSelectionChangedListener((ISelectionChangedListener)this.createStatusBarUpdater(slManager));
        this.hookViewerListeners();
        this.addFilters();
        this.fViewer.setContentProvider(this.createContentProvider());
        this.setInitialInput();
        this.setInitialSelection();
        this.fMemento = null;
        this.getViewSite().getPage().addPostSelectionListener((ISelectionListener)this);
        this.getViewSite().getPage().addPartListener(this.fPartListener);
        this.activateHandlers((IHandlerService)this.getViewSite().getService(IHandlerService.class));
        this.fillActionBars(this.getViewSite().getActionBars());
        this.setHelp();
    }

    public <T> T getAdapter(Class<T> key) {
        if (key == IShowInSource.class) {
            return (T)this.getShowInSource();
        }
        if (key == IContextProvider.class) {
            return (T)JavaUIHelp.getHelpContextProvider((IWorkbenchPart)this, this.getHelpContextId());
        }
        return (T)super.getAdapter(key);
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(null, JavaBrowsingPart.this.getSite().getSelectionProvider().getSelection());
            }
        };
    }

    protected DecoratingJavaLabelProvider createDecoratingLabelProvider(JavaUILabelProvider provider) {
        return new DecoratingJavaLabelProvider(provider);
    }

    protected JavaElementComparator createJavaElementComparator() {
        return new JavaElementComparator();
    }

    protected StatusBarUpdater createStatusBarUpdater(IStatusLineManager slManager) {
        return new StatusBarUpdater(slManager);
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu contextMenu = menuManager.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(contextMenu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.fViewer);
    }

    protected void initDragAndDrop() {
        this.fDropSupport = new JdtViewerDropSupport(this.fViewer);
        this.fDropSupport.start();
        new JdtViewerDragSupport(this.fViewer).start();
    }

    protected JdtViewerDropSupport getDropSupport() {
        return this.fDropSupport;
    }

    protected void fillActionBars(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        this.fillToolBar(toolBar);
        if (this.fHasWorkingSetFilter) {
            this.fWorkingSetFilterActionGroup.fillActionBars(this.getViewSite().getActionBars());
        }
        actionBars.updateActionBars();
        this.fActionGroups.fillActionBars(actionBars);
        if (this.fHasCustomFilter) {
            this.fCustomFiltersActionGroup.fillActionBars(actionBars);
        }
        IMenuManager menu = actionBars.getMenuManager();
        menu.add((IAction)this.fToggleLinkingAction);
    }

    protected void activateHandlers(IHandlerService handlerService) {
        handlerService.activateHandler("org.eclipse.ui.navigate.linkWithEditor", (IHandler)new ActionHandler((IAction)this.fToggleLinkingAction));
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.fViewer != null) {
            this.getViewSite().getPage().removePostSelectionListener((ISelectionListener)this);
            this.getViewSite().getPage().removePartListener(this.fPartListener);
            this.fViewer = null;
        }
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
            this.fActionGroups = null;
        }
        if (this.fWorkingSetFilterActionGroup != null) {
            this.fWorkingSetFilterActionGroup.dispose();
            this.fWorkingSetFilterActionGroup = null;
        }
        super.dispose();
    }

    protected void addKeyListener() {
        this.fViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                JavaBrowsingPart.this.handleKeyReleased(event);
            }
        });
    }

    protected void handleKeyReleased(KeyEvent event) {
        IAction action;
        if (event.stateMask != 0) {
            return;
        }
        int key = event.keyCode;
        if (key == 0x100000E && (action = this.fBuildActionGroup.getRefreshAction()).isEnabled()) {
            action.run();
        }
    }

    protected void fillToolBar(IToolBarManager tbm) {
    }

    public void menuAboutToShow(IMenuManager menu) {
        JavaPlugin.createStandardGroups(menu);
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        int size = selection.size();
        Object element = selection.getFirstElement();
        if (size == 1) {
            this.addOpenNewWindowAction(menu, element);
        }
        this.fActionGroups.setContext(new ActionContext((ISelection)selection));
        this.fActionGroups.fillContextMenu(menu);
        this.fActionGroups.setContext(null);
    }

    private void addOpenNewWindowAction(IMenuManager menu, Object element) {
        if (element instanceof IJavaElement) {
            element = ((IJavaElement)element).getResource();
        }
        if (!(element instanceof IContainer)) {
            return;
        }
        menu.appendToGroup("group.open", (IAction)new PatchedOpenInNewWindowAction(this.getSite().getWorkbenchWindow(), (IAdaptable)((IContainer)element)));
    }

    protected void createActions() {
        ActionGroup[] actionGroupArray = new ActionGroup[9];
        actionGroupArray[0] = new NewWizardsActionGroup((IWorkbenchSite)this.getSite());
        this.fOpenEditorGroup = new OpenEditorActionGroup((IViewPart)this);
        actionGroupArray[1] = this.fOpenEditorGroup;
        actionGroupArray[2] = new OpenViewActionGroup((IViewPart)this);
        this.fCCPActionGroup = new CCPActionGroup((IViewPart)this);
        actionGroupArray[3] = this.fCCPActionGroup;
        actionGroupArray[4] = new GenerateActionGroup((IViewPart)this);
        actionGroupArray[5] = new RefactorActionGroup((IViewPart)this);
        actionGroupArray[6] = new ImportActionGroup((IViewPart)this);
        this.fBuildActionGroup = new BuildActionGroup((IViewPart)this);
        actionGroupArray[7] = this.fBuildActionGroup;
        actionGroupArray[8] = new JavaSearchActionGroup((IViewPart)this);
        this.fActionGroups = new CompositeActionGroup(actionGroupArray);
        if (this.fHasWorkingSetFilter) {
            String viewId = this.getConfigurationElement().getAttribute("id");
            Assert.isNotNull((Object)viewId);
            IPropertyChangeListener workingSetListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    JavaBrowsingPart.this.doWorkingSetChanged(event);
                }
            };
            this.fWorkingSetFilterActionGroup = new WorkingSetFilterActionGroup(this.getSite(), workingSetListener);
            this.fViewer.addFilter(this.fWorkingSetFilterActionGroup.getWorkingSetFilter());
        }
        if (this.fHasCustomFilter) {
            this.fCustomFiltersActionGroup = new CustomFiltersActionGroup((IViewPart)this, this.fViewer);
        }
        this.fToggleLinkingAction = new ToggleLinkingAction(this);
        this.fToggleLinkingAction.setActionDefinitionId("org.eclipse.ui.navigate.linkWithEditor");
    }

    private void doWorkingSetChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("workingSetLabelChange".equals(property)) {
            this.updateTitle();
        } else if ("workingSetContentChange".equals(property)) {
            this.updateTitle();
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.refresh();
            this.fViewer.getControl().setRedraw(true);
        }
    }

    Shell getShell() {
        return this.fViewer.getControl().getShell();
    }

    protected final Display getDisplay() {
        return this.fViewer.getControl().getDisplay();
    }

    ISelectionProvider getSelectionProvider() {
        return this.fViewer;
    }

    protected abstract boolean isValidInput(Object var1);

    protected boolean isValidElement(Object element) {
        if (!(element instanceof IJavaElement)) {
            return false;
        }
        Object input = this.getViewer().getInput();
        if (input == null) {
            return false;
        }
        if (input instanceof Collection) {
            return ((Collection)input).contains(element);
        }
        return input.equals(element);
    }

    boolean isInputResetBy(Object newInput, Object input, IWorkbenchPart part) {
        if (newInput == null) {
            return part == this.fPreviousSelectionProvider;
        }
        if (input instanceof IJavaElement && newInput instanceof IJavaElement) {
            return this.getTypeComparator().compare((IJavaElement)newInput, (IJavaElement)input) > 0;
        }
        return newInput instanceof List && part instanceof PackagesView;
    }

    private boolean isInputResetBy(IWorkbenchPart part) {
        if (!(part instanceof JavaBrowsingPart)) {
            return true;
        }
        Object thisInput = this.getViewer().getInput();
        Object partInput = ((JavaBrowsingPart)part).getViewer().getInput();
        if (thisInput instanceof Collection) {
            thisInput = ((Collection)thisInput).iterator().next();
        }
        if (partInput instanceof Collection) {
            partInput = ((Collection)partInput).iterator().next();
        }
        if (thisInput instanceof IJavaElement && partInput instanceof IJavaElement) {
            return this.getTypeComparator().compare((IJavaElement)partInput, (IJavaElement)thisInput) > 0;
        }
        return true;
    }

    protected boolean isAncestorOf(Object ancestor, Object element) {
        if (element instanceof IJavaElement && ancestor instanceof IJavaElement) {
            return !element.equals(ancestor) && this.internalIsAncestorOf((IJavaElement)ancestor, (IJavaElement)element);
        }
        return false;
    }

    private boolean internalIsAncestorOf(IJavaElement ancestor, IJavaElement element) {
        if (element != null) {
            return element.equals(ancestor) || this.internalIsAncestorOf(ancestor, element.getParent());
        }
        return false;
    }

    private boolean isSearchResultView(IWorkbenchPart part) {
        return SearchUtil.isSearchPlugInActivated() && part instanceof ISearchResultViewPart;
    }

    protected boolean needsToProcessSelectionChanged(IWorkbenchPart part) {
        if (!this.fProcessSelectionEvents || part == this || this.isSearchResultView(part) || part instanceof AbstractInfoView) {
            if (part == this) {
                this.fPreviousSelectionProvider = part;
            }
            return false;
        }
        return true;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.needsToProcessSelectionChanged(part)) {
            return;
        }
        if (this.fToggleLinkingAction.isChecked() && part instanceof IEditorPart) {
            this.setSelectionFromEditor(part, selection);
            return;
        }
        Object selectedElement = this.getSingleElementFromSelection(selection);
        if (selectedElement != null && (part == null || part.equals(this.fPreviousSelectionProvider)) && selectedElement.equals(this.fPreviousSelectedElement)) {
            return;
        }
        this.fPreviousSelectedElement = selectedElement;
        Object currentInput = this.getViewer().getInput();
        if (selectedElement != null && selectedElement.equals(currentInput)) {
            IJavaElement elementToSelect = this.findElementToSelect(selectedElement);
            if (elementToSelect != null && this.getTypeComparator().compare((IJavaElement)selectedElement, elementToSelect) < 0) {
                this.setSelection((ISelection)new StructuredSelection((Object)elementToSelect), true);
            } else if (elementToSelect == null && this instanceof MembersView) {
                this.setSelection((ISelection)StructuredSelection.EMPTY, true);
                this.fPreviousSelectedElement = StructuredSelection.EMPTY;
            }
            this.fPreviousSelectionProvider = part;
            return;
        }
        if (part != this.fPreviousSelectionProvider && selectedElement != null && !selectedElement.equals(currentInput) && this.isInputResetBy(selectedElement, currentInput, part)) {
            if (!this.isAncestorOf(selectedElement, currentInput)) {
                this.setInput(null);
            }
            this.fPreviousSelectionProvider = part;
            return;
        }
        if (selection != null && selection.isEmpty() && !this.isInputResetBy(part)) {
            this.fPreviousSelectionProvider = part;
            return;
        }
        if (selectedElement == null && part == this.fPreviousSelectionProvider) {
            this.setInput(null);
            this.fPreviousSelectionProvider = part;
            return;
        }
        this.fPreviousSelectionProvider = part;
        this.adjustInputAndSetSelection(selectedElement);
    }

    void setHasWorkingSetFilter(boolean state) {
        this.fHasWorkingSetFilter = state;
    }

    void setHasCustomSetFilter(boolean state) {
        this.fHasCustomFilter = state;
    }

    protected Object getInput() {
        return this.fViewer.getInput();
    }

    protected void setInput(Object input) {
        this.setViewerInput(input);
        this.updateTitle();
    }

    boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    private void initLinkingEnabled() {
        this.fLinkingEnabled = PreferenceConstants.getPreferenceStore().getBoolean(this.getLinkToEditorKey());
    }

    private void setViewerInput(Object input) {
        this.fProcessSelectionEvents = false;
        this.fViewer.setInput(input);
        this.fProcessSelectionEvents = true;
    }

    void updateTitle() {
        this.setTitleToolTip(this.getToolTipText(this.fViewer.getInput()));
    }

    String getToolTipText(Object element) {
        IPath path;
        String result = !(element instanceof IResource) ? JavaElementLabels.getTextLabel(element, 36283885813801L) : ((path = ((IResource)element).getFullPath()).isRoot() ? this.getConfigurationElement().getAttribute("name") : path.makeRelative().toString());
        if (this.fWorkingSetFilterActionGroup == null || this.fWorkingSetFilterActionGroup.getWorkingSet() == null) {
            return result;
        }
        IWorkingSet ws = this.fWorkingSetFilterActionGroup.getWorkingSet();
        String wsstr = Messages.format(JavaBrowsingMessages.JavaBrowsingPart_toolTip, new String[]{BasicElementLabels.getWorkingSetLabel(ws)});
        if (result.length() == 0) {
            return wsstr;
        }
        return Messages.format(JavaBrowsingMessages.JavaBrowsingPart_toolTip2, new String[]{result, BasicElementLabels.getWorkingSetLabel(ws)});
    }

    public String getTitleToolTip() {
        if (this.fViewer == null) {
            return super.getTitleToolTip();
        }
        return this.getToolTipText(this.fViewer.getInput());
    }

    protected final StructuredViewer getViewer() {
        return this.fViewer;
    }

    protected final void setViewer(StructuredViewer viewer) {
        this.fViewer = viewer;
    }

    protected JavaUILabelProvider createLabelProvider() {
        return new AppearanceAwareLabelProvider(36283885813801L, 3);
    }

    protected ILabelProvider createTitleProvider() {
        return new JavaElementLabelProvider(256);
    }

    protected final ILabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    protected final ILabelProvider getTitleProvider() {
        return this.fTitleProvider;
    }

    protected StructuredViewer createViewer(Composite parent) {
        return new ProblemTableViewer(parent, 2);
    }

    protected int getLabelProviderFlags() {
        return 786;
    }

    protected void addFilters() {
    }

    protected IContentProvider createContentProvider() {
        return new JavaBrowsingContentProvider(true, this);
    }

    protected void setInitialInput() {
        ISelection selection = this.getSite().getPage().getSelection();
        Object input = this.getSingleElementFromSelection(selection);
        if (!(input instanceof IJavaElement) && !((input = this.getSite().getPage().getInput()) instanceof IJavaElement) && input instanceof IAdaptable) {
            input = ((IAdaptable)input).getAdapter(IJavaElement.class);
        }
        this.setInput(this.findInputForJavaElement((IJavaElement)input));
    }

    protected void setInitialSelection() {
        IWorkbenchPart part;
        IWorkbenchPage page = this.getSite().getPage();
        ISelection selection = null;
        if (page != null) {
            selection = page.getSelection();
        }
        if (selection instanceof ITextSelection && (part = page.getActivePart()) instanceof IEditorPart) {
            this.setSelectionFromEditor((IWorkbenchPart)((IEditorPart)part));
            if (this.fViewer.getSelection() != null) {
                return;
            }
        }
        if (selection == null || selection.isEmpty()) {
            selection = this.restoreSelectionState(this.fMemento);
        }
        if (selection == null || selection.isEmpty()) {
            Object input = this.getSite().getPage().getInput();
            if (!(input instanceof IJavaElement)) {
                if (input instanceof IAdaptable) {
                    input = input.getAdapter(IJavaElement.class);
                } else {
                    return;
                }
            }
            selection = new StructuredSelection(input);
        }
        this.selectionChanged(null, selection);
    }

    protected final void setHelp() {
        JavaUIHelp.setHelp(this.fViewer, this.getHelpContextId());
    }

    protected abstract String getHelpContextId();

    protected abstract String getLinkToEditorKey();

    protected void hookViewerListeners() {
        this.fOpenAndLinkWithEditorHelper = new OpenAndLinkWithEditorHelper(this.fViewer){

            protected void activate(ISelection selection) {
                try {
                    Object selectedElement = SelectionUtil.getSingleElement(selection);
                    if (EditorUtility.isOpenInEditor(selectedElement) != null) {
                        EditorUtility.openInEditor(selectedElement, true);
                    }
                }
                catch (PartInitException partInitException) {}
            }

            protected void linkToEditor(ISelection selection) {
                if (!JavaBrowsingPart.this.fProcessSelectionEvents) {
                    return;
                }
                JavaBrowsingPart.this.fPreviousSelectedElement = JavaBrowsingPart.this.getSingleElementFromSelection(selection);
                IWorkbenchPage page = JavaBrowsingPart.this.getSite().getPage();
                if (page == null) {
                    return;
                }
                if (page.equals(JavaPlugin.getActivePage()) && JavaBrowsingPart.this.equals(page.getActivePart())) {
                    JavaBrowsingPart.this.linkToEditor(selection);
                }
            }

            protected void open(ISelection selection, boolean activate) {
                IAction open = JavaBrowsingPart.this.fOpenEditorGroup.getOpenAction();
                if (open.isEnabled()) {
                    open.run();
                    JavaBrowsingPart.this.restoreSelection();
                }
            }
        };
        this.fOpenAndLinkWithEditorHelper.setLinkWithEditor(this.fLinkingEnabled);
    }

    void restoreSelection() {
    }

    void adjustInputAndSetSelection(Object o) {
        if (!(o instanceof IJavaElement)) {
            if (o == null) {
                this.setInput(null);
            }
            this.setSelection((ISelection)StructuredSelection.EMPTY, true);
            return;
        }
        IJavaElement je = (IJavaElement)o;
        IJavaElement elementToSelect = this.findElementToSelect(je);
        IJavaElement newInput = this.findInputForJavaElement(je);
        IJavaElement oldInput = null;
        if (this.getInput() instanceof IJavaElement) {
            oldInput = (IJavaElement)this.getInput();
        }
        if (elementToSelect == null && !this.isValidInput(newInput) && newInput == null && !this.isAncestorOf(je, oldInput)) {
            this.setInput(null);
        } else if (this.mustSetNewInput(elementToSelect, oldInput, newInput)) {
            this.setInput(newInput);
        }
        if (elementToSelect != null && elementToSelect.exists()) {
            this.setSelection((ISelection)new StructuredSelection((Object)elementToSelect), true);
        } else {
            this.setSelection((ISelection)StructuredSelection.EMPTY, true);
        }
    }

    private boolean mustSetNewInput(IJavaElement elementToSelect, IJavaElement oldInput, IJavaElement newInput) {
        return !(newInput != null && newInput.equals(oldInput) || elementToSelect != null && oldInput != null && elementToSelect instanceof IPackageDeclaration && elementToSelect.getParent().equals(oldInput.getParent()) && !this.isAncestorOf(this.getViewPartInput(), elementToSelect));
    }

    protected IJavaElement findInputForJavaElement(IJavaElement je) {
        if (je == null || !je.exists()) {
            return null;
        }
        if (this.isValidInput(je)) {
            return je;
        }
        return this.findInputForJavaElement(je.getParent());
    }

    protected final IJavaElement findElementToSelect(Object obj) {
        if (obj instanceof IJavaElement) {
            return this.findElementToSelect((IJavaElement)obj);
        }
        return null;
    }

    protected abstract IJavaElement findElementToSelect(IJavaElement var1);

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected final Object getSingleElementFromSelection(ISelection selection) {
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return null;
        }
        iter = ((IStructuredSelection)selection).iterator();
        firstElement /* !! */  = iter.next();
        if (!(firstElement /* !! */  instanceof IJavaElement)) {
            if (firstElement /* !! */  instanceof IMarker) {
                firstElement /* !! */  = ((IMarker)firstElement /* !! */ ).getResource();
            }
            if (firstElement /* !! */  instanceof IAdaptable) {
                je = (IJavaElement)((IAdaptable)firstElement /* !! */ ).getAdapter(IJavaElement.class);
                if (je == null && firstElement /* !! */  instanceof IFile) {
                    parent = ((IFile)firstElement /* !! */ ).getParent();
                    if (parent != null) {
                        return parent.getAdapter(IJavaElement.class);
                    }
                    return null;
                }
                return je;
            }
            return firstElement /* !! */ ;
        }
        currentInput = this.getViewer().getInput();
        if (currentInput != null && currentInput.equals(this.findInputForJavaElement((IJavaElement)firstElement /* !! */ ))) ** GOTO lbl27
        if (iter.hasNext()) {
            return null;
        }
        return firstElement /* !! */ ;
lbl-1000:
        // 1 sources

        {
            element = iter.next();
            if (!(element instanceof IJavaElement)) {
                return null;
            }
            if (currentInput.equals(this.findInputForJavaElement((IJavaElement)element))) continue;
            return null;
lbl27:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl28:
        // 1 sources

        return firstElement /* !! */ ;
    }

    protected Comparator<IJavaElement> getTypeComparator() {
        return this.fTypeComparator;
    }

    private void linkToEditor(ISelection selection) {
        IEditorPart part;
        Object obj = SelectionUtil.getSingleElement(selection);
        if (obj != null && (part = EditorUtility.isOpenInEditor(obj)) != null) {
            IWorkbenchPage page = this.getSite().getPage();
            page.bringToTop((IWorkbenchPart)part);
            if (obj instanceof IJavaElement) {
                EditorUtility.revealInEditor(part, (IJavaElement)obj);
            }
        }
    }

    void setSelectionFromEditor(IWorkbenchPart part) {
        if (!(this.fProcessSelectionEvents && this.linkBrowsingViewSelectionToEditor() && part instanceof IEditorPart)) {
            return;
        }
        IWorkbenchPartSite site = part.getSite();
        if (site == null) {
            return;
        }
        ISelectionProvider provider = site.getSelectionProvider();
        if (provider != null) {
            this.setSelectionFromEditor(part, provider.getSelection());
        }
    }

    private void setSelectionFromEditor(IWorkbenchPart part, ISelection selection) {
        if (part instanceof IEditorPart) {
            Object obj;
            IJavaElement element = null;
            if (selection instanceof IStructuredSelection && (obj = this.getSingleElementFromSelection(selection)) instanceof IJavaElement) {
                element = (IJavaElement)obj;
            }
            IEditorInput ei = part instanceof AbstractMultiEditor ? ((AbstractMultiEditor)part).getActiveEditor().getEditorInput() : ((IEditorPart)part).getEditorInput();
            if (selection instanceof ITextSelection) {
                int offset = ((ITextSelection)selection).getOffset();
                element = this.getElementAt(ei, offset);
            }
            if (element != null) {
                this.adjustInputAndSetSelection(element);
                return;
            }
            if (ei instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)ei).getFile();
                IJavaElement je = (IJavaElement)file.getAdapter(IJavaElement.class);
                IContainer container = null;
                if (je == null && (container = ((IFileEditorInput)ei).getFile().getParent()) != null) {
                    je = (IJavaElement)container.getAdapter(IJavaElement.class);
                }
                if (je == null && container == null) {
                    this.setSelection(null, false);
                    return;
                }
                this.adjustInputAndSetSelection(je);
            } else if (ei instanceof IClassFileEditorInput) {
                IClassFile cf = ((IClassFileEditorInput)ei).getClassFile();
                this.adjustInputAndSetSelection(cf);
            }
        }
    }

    Object getElementOfInput(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        if (input != null) {
            return JavaUI.getEditorInputJavaElement(input);
        }
        return null;
    }

    void setSelection(ISelection selection, boolean reveal) {
        if (selection != null && selection.equals(this.fViewer.getSelection())) {
            return;
        }
        this.fProcessSelectionEvents = false;
        this.fViewer.setSelection(selection, reveal);
        this.fProcessSelectionEvents = true;
    }

    protected IJavaElement getElementAt(IEditorInput input, int offset) {
        if (input instanceof IClassFileEditorInput) {
            try {
                return ((IClassFileEditorInput)input).getClassFile().getElementAt(offset);
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        WorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
        ICompilationUnit unit = manager.getWorkingCopy(input);
        if (unit != null) {
            try {
                if (unit.isConsistent()) {
                    return unit.getElementAt(offset);
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    protected IType getTypeForCU(ICompilationUnit cu) {
        IType primaryType = cu.findPrimaryType();
        if (primaryType != null) {
            return primaryType;
        }
        try {
            IType[] types = cu.getTypes();
            if (types.length > 0) {
                return types[0];
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    void setProcessSelectionEvents(boolean state) {
        this.fProcessSelectionEvents = state;
    }

    @Override
    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    protected void setActionGroups(CompositeActionGroup actionGroups) {
        this.fActionGroups = actionGroups;
    }

    protected void setBuildActionGroup(BuildActionGroup actionGroup) {
        this.fBuildActionGroup = actionGroup;
    }

    protected void setCCPActionGroup(CCPActionGroup actionGroup) {
        this.fCCPActionGroup = actionGroup;
    }

    protected void setCustomFiltersActionGroup(CustomFiltersActionGroup customFiltersActionGroup) {
        this.fCustomFiltersActionGroup = customFiltersActionGroup;
    }

    protected boolean hasCustomFilter() {
        return this.fHasCustomFilter;
    }

    protected boolean hasWorkingSetFilter() {
        return this.fHasWorkingSetFilter;
    }

    protected void setOpenEditorGroup(OpenEditorActionGroup openEditorGroup) {
        this.fOpenEditorGroup = openEditorGroup;
    }

    protected OpenEditorActionGroup getOpenEditorGroup() {
        return this.fOpenEditorGroup;
    }

    protected BuildActionGroup getBuildActionGroup() {
        return this.fBuildActionGroup;
    }

    protected CCPActionGroup getCCPActionGroup() {
        return this.fCCPActionGroup;
    }

    private boolean linkBrowsingViewSelectionToEditor() {
        return this.isLinkingEnabled();
    }

    public void setLinkingEnabled(boolean enabled) {
        IEditorPart editor;
        this.fLinkingEnabled = enabled;
        PreferenceConstants.getPreferenceStore().setValue(this.getLinkToEditorKey(), enabled);
        if (enabled && (editor = this.getSite().getPage().getActiveEditor()) != null) {
            this.setSelectionFromEditor((IWorkbenchPart)editor);
        }
        this.fOpenAndLinkWithEditorHelper.setLinkWithEditor(enabled);
    }
}

