/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public abstract class SelectionListenerAction
extends BaseSelectionListenerAction {
    private boolean selectionDirty = true;
    private List<IResource> resources;
    private List<Object> nonResources;

    protected SelectionListenerAction(String text) {
        super(text);
    }

    protected void clearCache() {
        this.selectionDirty = true;
        this.resources = null;
        this.nonResources = null;
    }

    private final void computeResources() {
        this.resources = null;
        this.nonResources = null;
        for (Object next : this.getStructuredSelection()) {
            if (next instanceof IResource) {
                if (this.resources == null) {
                    this.resources = new ArrayList<IResource>(this.getStructuredSelection().size());
                }
                this.resources.add((IResource)next);
                continue;
            }
            if (next instanceof IAdaptable) {
                IResource resource = (IResource)((IAdaptable)next).getAdapter(IResource.class);
                if (resource != null) {
                    if (this.resources == null) {
                        this.resources = new ArrayList<IResource>(this.getStructuredSelection().size());
                    }
                    this.resources.add(resource);
                    continue;
                }
            } else {
                boolean resourcesFoundForThisSelection = false;
                IAdapterManager adapterManager = Platform.getAdapterManager();
                ResourceMapping mapping = (ResourceMapping)adapterManager.getAdapter(next, ResourceMapping.class);
                if (mapping != null) {
                    ResourceTraversal[] traversals = null;
                    try {
                        traversals = mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException exception) {
                        IDEWorkbenchPlugin.log(exception.getLocalizedMessage(), exception.getStatus());
                    }
                    if (traversals != null) {
                        int i = 0;
                        while (i < traversals.length) {
                            IResource[] traversalResources = traversals[i].getResources();
                            if (traversalResources != null) {
                                resourcesFoundForThisSelection = true;
                                if (this.resources == null) {
                                    this.resources = new ArrayList<IResource>(this.getStructuredSelection().size());
                                }
                                int j = 0;
                                while (j < traversalResources.length) {
                                    this.resources.add(traversalResources[j]);
                                    ++j;
                                }
                            }
                            ++i;
                        }
                    }
                }
                if (resourcesFoundForThisSelection) continue;
            }
            if (this.nonResources == null) {
                this.nonResources = new ArrayList<Object>(1);
            }
            this.nonResources.add(next);
        }
    }

    protected List<?> getSelectedNonResources() {
        if (this.selectionDirty) {
            this.computeResources();
            this.selectionDirty = false;
        }
        if (this.nonResources == null) {
            return Collections.emptyList();
        }
        return this.nonResources;
    }

    protected List<? extends IResource> getSelectedResources() {
        if (this.selectionDirty) {
            this.computeResources();
            this.selectionDirty = false;
        }
        if (this.resources == null) {
            return Collections.emptyList();
        }
        return this.resources;
    }

    protected boolean resourceIsType(IResource resource, int resourceMask) {
        return (resource.getType() & resourceMask) != 0;
    }

    protected boolean selectionIsOfType(int resourceMask) {
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        for (IResource iResource : this.getSelectedResources()) {
            if (this.resourceIsType(iResource, resourceMask)) continue;
            return false;
        }
        return true;
    }
}

