/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.CommitMessageViewer;
import org.eclipse.egit.ui.internal.history.SWTCommit;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.RevWalkUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;

public class CommitInfoBuilder {
    private static final String SPACE = " ";
    private static final String LF = "\n";
    private static final int MAXBRANCHES = 20;
    private final DateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private PlotCommit<?> commit;
    private final Repository db;
    private final boolean fill;
    private Color linkColor;
    private Color darkGrey;
    private final Collection<Ref> allRefs;

    public CommitInfoBuilder(Repository db, PlotCommit commit, boolean fill, Collection<Ref> allRefs) {
        this.db = db;
        this.commit = commit;
        this.fill = fill;
        this.allRefs = allRefs;
    }

    public void setColors(Color linkColor, Color darkGrey) {
        this.linkColor = linkColor;
        this.darkGrey = darkGrey;
    }

    public String format(List<StyleRange> styles, IProgressMonitor monitor) throws IOException {
        Matcher spm;
        String tagsString;
        RevWalk rw32;
        Object p;
        boolean trace = GitTraceLocation.HISTORYVIEW.isActive();
        if (trace) {
            GitTraceLocation.getTrace().traceEntry(GitTraceLocation.HISTORYVIEW.getLocation());
        }
        monitor.setTaskName(UIText.CommitMessageViewer_FormattingMessageTaskName);
        StringBuilder d = new StringBuilder();
        PersonIdent author = this.commit.getAuthorIdent();
        PersonIdent committer = this.commit.getCommitterIdent();
        d.append(UIText.CommitMessageViewer_commit);
        d.append(SPACE);
        d.append(this.commit.getId().name());
        d.append(LF);
        if (author != null) {
            d.append(UIText.CommitMessageViewer_author);
            d.append(": ");
            d.append(author.getName());
            d.append(" <");
            d.append(author.getEmailAddress());
            d.append("> ");
            d.append(this.fmt.format(author.getWhen()));
            d.append(LF);
        }
        if (committer != null) {
            d.append(UIText.CommitMessageViewer_committer);
            d.append(": ");
            d.append(committer.getName());
            d.append(" <");
            d.append(committer.getEmailAddress());
            d.append("> ");
            d.append(this.fmt.format(committer.getWhen()));
            d.append(LF);
        }
        int i = 0;
        while (i < this.commit.getParentCount()) {
            p = (SWTCommit)this.commit.getParent(i);
            ((SWTCommit)((Object)p)).parseBody();
            d.append(UIText.CommitMessageViewer_parent);
            d.append(": ");
            this.addLink(d, styles, (RevCommit)p);
            d.append(" (");
            d.append(p.getShortMessage());
            d.append(")");
            d.append(LF);
            ++i;
        }
        i = 0;
        while (i < this.commit.getChildCount()) {
            p = (SWTCommit)this.commit.getChild(i);
            ((SWTCommit)((Object)p)).parseBody();
            d.append(UIText.CommitMessageViewer_child);
            d.append(": ");
            this.addLink(d, styles, (RevCommit)p);
            d.append(" (");
            d.append(p.getShortMessage());
            d.append(")");
            d.append(LF);
            ++i;
        }
        if (Activator.getDefault().getPreferenceStore().getBoolean("HistoryView_ShowBranchSequence")) {
            try {
                Throwable i2 = null;
                p = null;
                try {
                    rw32 = new RevWalk(this.db);
                    try {
                        List<Ref> branches = CommitInfoBuilder.getBranches(this.commit, this.allRefs, this.db);
                        if (!branches.isEmpty()) {
                            d.append(UIText.CommitMessageViewer_branches);
                            d.append(": ");
                            int count = 0;
                            Iterator<Ref> i3 = branches.iterator();
                            while (i3.hasNext()) {
                                Ref head = i3.next();
                                RevCommit p2 = rw32.parseCommit((AnyObjectId)head.getObjectId());
                                this.addLink(d, this.formatHeadRef(head), styles, p2);
                                if (!i3.hasNext()) continue;
                                if (count++ <= 20) {
                                    d.append(", ");
                                    continue;
                                }
                                d.append(NLS.bind((String)UIText.CommitMessageViewer_MoreBranches, (Object)(branches.size() - 20)));
                                break;
                            }
                            d.append(LF);
                        }
                    }
                    finally {
                        if (rw32 != null) {
                            rw32.close();
                        }
                    }
                }
                catch (Throwable p2) {
                    if (i2 == null) {
                        i2 = p2;
                    } else if (i2 != p2) {
                        i2.addSuppressed(p2);
                    }
                    throw i2;
                }
            }
            catch (IOException e) {
                Activator.logError(e.getMessage(), e);
            }
        }
        if ((tagsString = this.getTagsString()).length() > 0) {
            d.append(UIText.CommitMessageViewer_tags);
            d.append(": ");
            d.append(tagsString);
            d.append(LF);
        }
        if (Activator.getDefault().getPreferenceStore().getBoolean("HistoryView_ShowTagSequence")) {
            RevCommit p3;
            RevWalk rw;
            try {
                p = null;
                rw32 = null;
                try {
                    rw = new RevWalk(this.db);
                    try {
                        monitor.setTaskName(UIText.CommitMessageViewer_GettingPreviousTagTaskName);
                        Ref followingTag = this.getNextTag(false, monitor);
                        if (followingTag != null) {
                            d.append(UIText.CommitMessageViewer_follows);
                            d.append(": ");
                            p3 = rw.parseCommit((AnyObjectId)followingTag.getObjectId());
                            this.addLink(d, this.formatTagRef(followingTag), styles, p3);
                            d.append(LF);
                        }
                    }
                    finally {
                        if (rw != null) {
                            rw.close();
                        }
                    }
                }
                catch (Throwable rw32) {
                    if (p == null) {
                        p = rw32;
                    } else if (p != rw32) {
                        ((Throwable)p).addSuppressed(rw32);
                    }
                    throw p;
                }
            }
            catch (IOException e) {
                Activator.logError(e.getMessage(), e);
            }
            try {
                Throwable e = null;
                rw32 = null;
                try {
                    rw = new RevWalk(this.db);
                    try {
                        monitor.setTaskName(UIText.CommitMessageViewer_GettingNextTagTaskName);
                        Ref precedingTag = this.getNextTag(true, monitor);
                        if (precedingTag != null) {
                            d.append(UIText.CommitMessageViewer_precedes);
                            d.append(": ");
                            p3 = rw.parseCommit((AnyObjectId)precedingTag.getObjectId());
                            this.addLink(d, this.formatTagRef(precedingTag), styles, p3);
                            d.append(LF);
                        }
                    }
                    finally {
                        if (rw != null) {
                            rw.close();
                        }
                    }
                }
                catch (Throwable rw32) {
                    if (e == null) {
                        e = rw32;
                    } else if (e != rw32) {
                        e.addSuppressed(rw32);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                Activator.logError(e.getMessage(), e);
            }
        }
        this.makeGrayText(d, styles);
        d.append(LF);
        String msg = this.commit.getFullMessage();
        Pattern p4 = Pattern.compile("\n([A-Z](?:[A-Za-z]+-)+by: [^\n]+)");
        if (this.fill && (spm = p4.matcher(msg)).find()) {
            String subMsg = msg.substring(0, spm.end());
            msg = String.valueOf(subMsg.replaceAll("([\\w.,; \t])\n(\\w)", "$1 $2")) + msg.substring(spm.end());
        }
        int h0 = d.length();
        d.append(msg);
        if (!msg.endsWith(LF)) {
            d.append(LF);
        }
        Matcher matcher = p4.matcher(msg);
        while (matcher.find()) {
            styles.add(new StyleRange(h0 + matcher.start(), matcher.end() - matcher.start(), null, null, 2));
        }
        if (trace) {
            GitTraceLocation.getTrace().traceExit(GitTraceLocation.HISTORYVIEW.getLocation());
        }
        return d.toString();
    }

    private void addLink(StringBuilder d, String linkLabel, List<StyleRange> styles, RevCommit to) {
        CommitMessageViewer.ObjectLink sr = new CommitMessageViewer.ObjectLink();
        sr.targetCommit = to;
        sr.foreground = this.linkColor;
        sr.underline = true;
        sr.start = d.length();
        d.append(linkLabel);
        sr.length = d.length() - sr.start;
        styles.add(sr);
    }

    private void addLink(StringBuilder d, List<StyleRange> styles, RevCommit to) {
        this.addLink(d, to.getId().name(), styles, to);
    }

    private static List<Ref> getBranches(RevCommit commit, Collection<Ref> allRefs, Repository db) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (RevWalk revWalk = new RevWalk(db);){
            revWalk.setRetainBody(false);
            return RevWalkUtils.findBranchesReachableFrom((RevCommit)commit, (RevWalk)revWalk, allRefs);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String formatHeadRef(Ref ref) {
        String name = ref.getName();
        if (name.startsWith("refs/heads/")) {
            return name.substring("refs/heads/".length());
        }
        if (name.startsWith("refs/remotes/")) {
            return name.substring("refs/remotes/".length());
        }
        return name;
    }

    private String formatTagRef(Ref ref) {
        String name = ref.getName();
        if (name.startsWith("refs/tags/")) {
            return name.substring("refs/tags/".length());
        }
        return name;
    }

    private void makeGrayText(StringBuilder d, List<StyleRange> styles) {
        int p0 = 0;
        int i = 0;
        while (i < styles.size()) {
            StyleRange r = styles.get(i);
            if (p0 < r.start) {
                StyleRange nr = new StyleRange(p0, r.start - p0, this.darkGrey, null);
                styles.add(i, nr);
                p0 = r.start;
            } else {
                if (r.foreground == null) {
                    r.foreground = this.darkGrey;
                }
                p0 = r.start + r.length;
            }
            ++i;
        }
        if (d.length() - 1 > p0) {
            StyleRange nr = new StyleRange(p0, d.length() - p0, this.darkGrey, null);
            styles.add(nr);
        }
    }

    private String getTagsString() {
        StringBuilder sb = new StringBuilder();
        Map tagsMap = this.db.getTags();
        for (Map.Entry tagEntry : tagsMap.entrySet()) {
            ObjectId target = ((Ref)tagEntry.getValue()).getPeeledObjectId();
            if (target == null) {
                target = ((Ref)tagEntry.getValue()).getObjectId();
            }
            if (target == null || !target.equals(this.commit)) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append((String)tagEntry.getKey());
        }
        return sb.toString();
    }

    private Ref getNextTag(boolean searchDescendant, IProgressMonitor monitor) throws IOException, OperationCanceledException {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (RevWalk revWalk = new RevWalk(this.db);){
            revWalk.setRetainBody(false);
            Map tagsMap = this.db.getTags();
            Ref tagRef = null;
            for (Ref ref : tagsMap.values()) {
                RevCommit newTag;
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                RevCommit current = revWalk.parseCommit(this.commit);
                RevObject any = revWalk.peel(revWalk.parseAny((AnyObjectId)ref.getObjectId()));
                if (!(any instanceof RevCommit) || (newTag = (RevCommit)any).getId().equals(this.commit) || !this.isMergedInto(revWalk, newTag, current, searchDescendant)) continue;
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (tagRef != null) {
                    RevCommit oldTag = revWalk.parseCommit((AnyObjectId)tagRef.getObjectId());
                    if (!this.isMergedInto(revWalk, oldTag, newTag, searchDescendant)) continue;
                    tagRef = ref;
                    continue;
                }
                tagRef = ref;
            }
            return tagRef;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean isMergedInto(RevWalk rw, RevCommit base, RevCommit tip, boolean swap) throws IOException {
        return !swap ? rw.isMergedInto(base, tip) : rw.isMergedInto(tip, base);
    }
}

