/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.staging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.ui.internal.staging.StagingEntry;
import org.eclipse.egit.ui.internal.staging.StagingFolderEntry;
import org.eclipse.egit.ui.internal.staging.StagingView;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class StagingViewContentProvider
extends WorkbenchContentProvider {
    private StagingEntry[] content = new StagingEntry[0];
    private Object[] treeRoots;
    private Object[] compactTreeRoots;
    private StagingView stagingView;
    private boolean unstagedSection;
    private Repository repository;
    private final EntryComparator comparator;

    StagingViewContentProvider(StagingView stagingView, boolean unstagedSection) {
        this.stagingView = stagingView;
        this.unstagedSection = unstagedSection;
        this.comparator = new EntryComparator();
    }

    public Object getParent(Object element) {
        if (element instanceof StagingFolderEntry) {
            return ((StagingFolderEntry)element).getParent();
        }
        if (element instanceof StagingEntry) {
            return ((StagingEntry)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return !(element instanceof StagingEntry);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (this.repository == null) {
            return new Object[0];
        }
        if (parentElement instanceof StagingEntry) {
            return new Object[0];
        }
        if (parentElement instanceof StagingFolderEntry) {
            return ((StagingFolderEntry)parentElement).getChildren();
        }
        if (this.stagingView.getPresentation() == StagingView.Presentation.LIST) {
            return this.content;
        }
        return this.getTreePresentationRoots();
    }

    Object[] getTreePresentationRoots() {
        StagingView.Presentation presentation = this.stagingView.getPresentation();
        switch (presentation) {
            case COMPACT_TREE: {
                return this.getCompactTreeRoots();
            }
            case TREE: {
                return this.getTreeRoots();
            }
        }
        return new StagingFolderEntry[0];
    }

    private Object[] getCompactTreeRoots() {
        if (this.compactTreeRoots == null) {
            this.compactTreeRoots = this.calculateTreePresentationRoots(true);
        }
        return this.compactTreeRoots;
    }

    private Object[] getTreeRoots() {
        if (this.treeRoots == null) {
            this.treeRoots = this.calculateTreePresentationRoots(false);
        }
        return this.treeRoots;
    }

    private Object[] calculateTreePresentationRoots(boolean compact) {
        if (this.content == null || this.content.length == 0) {
            return new Object[0];
        }
        ArrayList<IAdaptable> roots = new ArrayList<IAdaptable>();
        HashMap<IPath, List<Object>> childrenForPath = new HashMap<IPath, List<Object>>();
        HashSet<IPath> folderPaths = new HashSet<IPath>();
        HashMap<IPath, String> childSegments = new HashMap<IPath, String>();
        StagingEntry[] stagingEntryArray = this.content;
        int n = this.content.length;
        int n2 = 0;
        while (n2 < n) {
            StagingEntry file = stagingEntryArray[n2];
            IPath folderPath = file.getParentPath();
            if (folderPath.segmentCount() == 0) {
                roots.add(file);
            } else {
                folderPaths.add(folderPath);
                StagingViewContentProvider.addChild(childrenForPath, folderPath, file);
                IPath p = folderPath;
                while (p.segmentCount() != 1) {
                    IPath parent = p.removeLastSegments(1);
                    if (!compact) {
                        folderPaths.add(parent);
                    } else {
                        String childSegment = p.lastSegment();
                        String knownChildSegment = (String)childSegments.get(parent);
                        if (knownChildSegment == null) {
                            childSegments.put(parent, childSegment);
                        } else if (!childSegment.equals(knownChildSegment)) {
                            folderPaths.add(parent);
                        }
                    }
                    p = p.removeLastSegments(1);
                }
            }
            ++n2;
        }
        Path workingDirectory = new Path(this.repository.getWorkTree().getAbsolutePath());
        ArrayList<StagingFolderEntry> folderEntries = new ArrayList<StagingFolderEntry>();
        for (IPath folderPath : folderPaths) {
            IPath parent = folderPath.removeLastSegments(1);
            while (parent.segmentCount() != 0 && !folderPaths.contains(parent)) {
                parent = parent.removeLastSegments(1);
            }
            if (parent.segmentCount() == 0) {
                StagingFolderEntry folderEntry = new StagingFolderEntry((IPath)workingDirectory, folderPath, folderPath);
                folderEntries.add(folderEntry);
                roots.add(folderEntry);
                continue;
            }
            IPath nodePath = folderPath.makeRelativeTo(parent);
            StagingFolderEntry folderEntry = new StagingFolderEntry((IPath)workingDirectory, folderPath, nodePath);
            folderEntries.add(folderEntry);
            StagingViewContentProvider.addChild(childrenForPath, parent, folderEntry);
        }
        for (StagingFolderEntry folderEntry : folderEntries) {
            List children = (List)childrenForPath.get(folderEntry.getPath());
            if (children == null) continue;
            for (Object child : children) {
                if (child instanceof StagingEntry) {
                    ((StagingEntry)child).setParent(folderEntry);
                    continue;
                }
                if (!(child instanceof StagingFolderEntry)) continue;
                ((StagingFolderEntry)child).setParent(folderEntry);
            }
            Collections.sort(children, this.comparator);
            folderEntry.setChildren(children.toArray());
        }
        Collections.sort(roots, this.comparator);
        return roots.toArray();
    }

    private static void addChild(Map<IPath, List<Object>> childrenForPath, IPath path, Object child) {
        List<Object> children = childrenForPath.get(path);
        if (children == null) {
            children = new ArrayList<Object>();
            childrenForPath.put(path, children);
        }
        children.add(child);
    }

    int getShownCount() {
        String filterString = this.getFilterString();
        if (filterString.length() == 0) {
            return this.getCount();
        }
        int shownCount = 0;
        StagingEntry[] stagingEntryArray = this.content;
        int n = this.content.length;
        int n2 = 0;
        while (n2 < n) {
            StagingEntry entry = stagingEntryArray[n2];
            if (this.isInFilter(entry)) {
                ++shownCount;
            }
            ++n2;
        }
        return shownCount;
    }

    List<StagingEntry> getStagingEntriesFiltered(StagingFolderEntry folder) {
        ArrayList<StagingEntry> stagingEntries = new ArrayList<StagingEntry>();
        StagingEntry[] stagingEntryArray = this.content;
        int n = this.content.length;
        int n2 = 0;
        while (n2 < n) {
            StagingEntry stagingEntry = stagingEntryArray[n2];
            if (folder.getLocation().isPrefixOf(stagingEntry.getLocation()) && this.isInFilter(stagingEntry)) {
                stagingEntries.add(stagingEntry);
            }
            ++n2;
        }
        return stagingEntries;
    }

    boolean isInFilter(StagingEntry stagingEntry) {
        String filterString = this.getFilterString();
        return filterString.length() == 0 || stagingEntry.getPath().toUpperCase().contains(filterString.toUpperCase());
    }

    private String getFilterString() {
        return this.stagingView.getFilterString();
    }

    boolean hasVisibleChildren(StagingFolderEntry folder) {
        if (this.getFilterString().length() == 0) {
            return true;
        }
        return !this.getStagingEntriesFiltered(folder).isEmpty();
    }

    StagingEntry[] getStagingEntries() {
        return this.content;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (!(newInput instanceof StagingView.StagingViewUpdate)) {
            return;
        }
        StagingView.StagingViewUpdate update = (StagingView.StagingViewUpdate)newInput;
        if (update.repository == null || update.indexDiff == null) {
            this.content = new StagingEntry[0];
            this.treeRoots = new Object[0];
            this.compactTreeRoots = new Object[0];
            return;
        }
        if (update.repository != this.repository) {
            this.treeRoots = null;
            this.compactTreeRoots = null;
        }
        this.repository = update.repository;
        TreeSet<StagingEntry> nodes = new TreeSet<StagingEntry>(new Comparator<StagingEntry>(){

            @Override
            public int compare(StagingEntry o1, StagingEntry o2) {
                return o1.getPath().compareTo(o2.getPath());
            }
        });
        if (update.changedResources != null && !update.changedResources.isEmpty()) {
            nodes.addAll(Arrays.asList(this.content));
            for (String res : update.changedResources) {
                StagingEntry[] stagingEntryArray = this.content;
                int n = this.content.length;
                int n2 = 0;
                while (n2 < n) {
                    StagingEntry entry = stagingEntryArray[n2];
                    if (entry.getPath().equals(res)) {
                        nodes.remove(entry);
                    }
                    ++n2;
                }
            }
        }
        IndexDiffData indexDiff = update.indexDiff;
        if (this.unstagedSection) {
            for (String file : indexDiff.getMissing()) {
                if (indexDiff.getChanged().contains(file)) {
                    nodes.add(new StagingEntry(this.repository, StagingEntry.State.MISSING_AND_CHANGED, file));
                    continue;
                }
                nodes.add(new StagingEntry(this.repository, StagingEntry.State.MISSING, file));
            }
            for (String file : indexDiff.getModified()) {
                if (indexDiff.getChanged().contains(file)) {
                    nodes.add(new StagingEntry(this.repository, StagingEntry.State.MODIFIED_AND_CHANGED, file));
                    continue;
                }
                if (indexDiff.getAdded().contains(file)) {
                    nodes.add(new StagingEntry(this.repository, StagingEntry.State.MODIFIED_AND_ADDED, file));
                    continue;
                }
                nodes.add(new StagingEntry(this.repository, StagingEntry.State.MODIFIED, file));
            }
            for (String file : indexDiff.getUntracked()) {
                nodes.add(new StagingEntry(this.repository, StagingEntry.State.UNTRACKED, file));
            }
            for (String file : indexDiff.getConflicting()) {
                nodes.add(new StagingEntry(this.repository, StagingEntry.State.CONFLICTING, file));
            }
        } else {
            for (String file : indexDiff.getAdded()) {
                nodes.add(new StagingEntry(this.repository, StagingEntry.State.ADDED, file));
            }
            for (String file : indexDiff.getChanged()) {
                nodes.add(new StagingEntry(this.repository, StagingEntry.State.CHANGED, file));
            }
            for (String file : indexDiff.getRemoved()) {
                nodes.add(new StagingEntry(this.repository, StagingEntry.State.REMOVED, file));
            }
        }
        this.setSymlinkFileMode(indexDiff, nodes);
        this.setSubmoduleFileMode(indexDiff, nodes);
        this.content = nodes.toArray(new StagingEntry[nodes.size()]);
        Arrays.sort(this.content, this.comparator);
        this.treeRoots = null;
        this.compactTreeRoots = null;
    }

    public void dispose() {
    }

    public int getCount() {
        if (this.content == null) {
            return 0;
        }
        return this.content.length;
    }

    void setFileNameMode(boolean enable) {
        this.comparator.fileNameMode = enable;
        if (this.content != null) {
            Arrays.sort(this.content, this.comparator);
        }
    }

    private void setSymlinkFileMode(IndexDiffData indexDiff, Collection<StagingEntry> entries) {
        Set symlinks = indexDiff.getSymlinks();
        for (StagingEntry stagingEntry : entries) {
            if (!symlinks.contains(stagingEntry.getPath())) continue;
            stagingEntry.setSymlink(true);
        }
    }

    private void setSubmoduleFileMode(IndexDiffData indexDiff, Collection<StagingEntry> entries) {
        Set submodules = indexDiff.getSubmodules();
        for (StagingEntry stagingEntry : entries) {
            if (!submodules.contains(stagingEntry.getPath())) continue;
            stagingEntry.setSubmodule(true);
        }
    }

    private static class EntryComparator
    implements Comparator<Object> {
        boolean fileNameMode;

        private EntryComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof StagingEntry) {
                if (o2 instanceof StagingEntry) {
                    StagingEntry e1 = (StagingEntry)o1;
                    StagingEntry e2 = (StagingEntry)o2;
                    if (this.fileNameMode) {
                        int result = e1.getName().compareTo(e2.getName());
                        if (result != 0) {
                            return result;
                        }
                        return e1.getParentPath().toString().compareTo(e2.getParentPath().toString());
                    }
                    return e1.getPath().compareTo(e2.getPath());
                }
                return 1;
            }
            if (o1 instanceof StagingFolderEntry) {
                if (o2 instanceof StagingFolderEntry) {
                    StagingFolderEntry f1 = (StagingFolderEntry)o1;
                    StagingFolderEntry f2 = (StagingFolderEntry)o2;
                    return f1.getPath().toString().compareTo(f2.getPath().toString());
                }
                return -1;
            }
            return 0;
        }
    }
}

