/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.InputStream;
import org.eclipse.core.runtime.Path;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.xhtml.DynamicXHTMLProcessor;
import org.eclipse.help.search.SearchParticipantXML;
import org.xml.sax.Attributes;

public class XHTMLSearchParticipant
extends SearchParticipantXML {
    private static final String KEYWORDS = "keywords";
    private static final String META_TAG = "meta";
    private static final String DESCRIPTION = "description";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String CONTENT_ATTRIBUTE = "content";
    private String title;
    private String summary;
    private boolean hasDescriptionMetaTag = false;

    protected void handleEndElement(String name, SearchParticipantXML.IParsedXMLContent data) {
    }

    protected void handleStartElement(String name, Attributes attributes, SearchParticipantXML.IParsedXMLContent data) {
        this.title = null;
        if (META_TAG.equalsIgnoreCase(name)) {
            String keywordsAttribute;
            String nameAttribute = attributes.getValue(NAME_ATTRIBUTE);
            if (DESCRIPTION.equalsIgnoreCase(nameAttribute)) {
                String descriptionAttribute = attributes.getValue(CONTENT_ATTRIBUTE);
                if (descriptionAttribute != null) {
                    this.hasDescriptionMetaTag = true;
                    data.addToSummary(descriptionAttribute);
                    data.addText(" ");
                    data.addText(descriptionAttribute);
                    data.addText(" ");
                }
            } else if (KEYWORDS.equalsIgnoreCase(nameAttribute) && (keywordsAttribute = attributes.getValue(CONTENT_ATTRIBUTE)) != null) {
                data.addText(" ");
                data.addText(keywordsAttribute);
                data.addText(" ");
            }
        }
    }

    protected void handleStartDocument(SearchParticipantXML.IParsedXMLContent data) {
        this.hasDescriptionMetaTag = false;
    }

    protected void handleText(String text, SearchParticipantXML.IParsedXMLContent data) {
        String stackPath = this.getElementStackPath();
        Path path = new Path(stackPath);
        if (path.segment(1).equalsIgnoreCase("body") && !this.isSkipped(path.segment(path.segmentCount() - 1))) {
            data.addText(text);
            if (!this.hasDescriptionMetaTag) {
                data.addToSummary(text);
            }
        } else if (path.segment(1).equalsIgnoreCase("head") && path.segment(path.segmentCount() - 1).equalsIgnoreCase("title")) {
            this.title = this.title == null ? text : String.valueOf(this.title) + text;
            data.setTitle(this.title);
        }
    }

    private boolean isSkipped(String tag) {
        return tag.equals("script");
    }

    protected InputStream preprocess(InputStream in, String name, String locale) {
        try {
            return DynamicXHTMLProcessor.process(name, in, locale, false);
        }
        catch (Throwable t) {
            String msg = "An error occured while pre-processing help XHTML document \"" + name + "\" for search indexing";
            HelpBasePlugin.logError(msg, t);
            return in;
        }
    }

    public String getSummary() {
        return this.summary;
    }
}

