/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.jface;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlDecoratorRecordingHolder {
    private static WeakHashMap<Control, List<WeakReference<ControlDecoration>>> decorations = new WeakHashMap();

    public static synchronized List<ControlDecoration> getDecorators(Control ctrl) {
        ArrayList<ControlDecoration> result = new ArrayList<ControlDecoration>();
        ArrayList<WeakReference<ControlDecoration>> toRemove = new ArrayList<WeakReference<ControlDecoration>>();
        List<WeakReference<ControlDecoration>> values = decorations.get(ctrl);
        if (values == null) {
            return result;
        }
        for (WeakReference<ControlDecoration> controlDecoration : values) {
            ControlDecoration decoration = (ControlDecoration)controlDecoration.get();
            if (decoration != null) {
                if (decoration.getControl() == null || decoration.getControl().isDisposed()) {
                    toRemove.add(controlDecoration);
                    continue;
                }
                result.add(decoration);
                continue;
            }
            toRemove.add(controlDecoration);
        }
        values.removeAll(toRemove);
        if (values.size() == 0) {
            decorations.remove(ctrl);
        }
        return result;
    }

    public static synchronized void add(Control ctrl, ControlDecoration decor) {
        List<WeakReference<ControlDecoration>> list = decorations.get(ctrl);
        if (list == null) {
            list = new ArrayList<WeakReference<ControlDecoration>>();
            decorations.put(ctrl, list);
        }
        list.add(new WeakReference<ControlDecoration>(decor));
    }
}

