/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.commons;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.databinding.viewers.IViewerObservableList;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.actions.SelectionAction;
import org.eclipse.rcptt.ui.commons.ClipboardUtils;
import org.eclipse.rcptt.ui.commons.IContentNamer;
import org.eclipse.rcptt.ui.commons.ISelectionActionsHandler;
import org.eclipse.rcptt.ui.controls.AbstractEmbeddedComposite;
import org.eclipse.rcptt.ui.editors.NamedElementEditorActions;
import org.eclipse.rcptt.ui.panels.Actions;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ResourceTransfer;

public abstract class EObjectTable
extends AbstractEmbeddedComposite
implements IContentNamer,
ISelectionActionsHandler,
NamedElementEditorActions.INamedElementActions {
    protected TableViewer viewer;
    protected EObject content;
    private final EStructuralFeature feature;
    private ToolBar toolBar;
    private SelectionAction.RemoveAction removeAction;
    private SelectionAction.CutAction cutAction;
    private SelectionAction.CopyAction copyAction;
    private SelectionAction.PasteAction pasteAction;
    private Action addTool;
    private Action removeTool;
    private Action upTool;
    private Action downTool;
    private IViewerObservableList viewerSelection;
    private ComputedValue removeToolComputedValue;
    private ComputedValue upToolComputedValue;
    private ComputedValue downToolComputedValue;
    private Binding removeToolBinding;
    private Binding upToolBinding;
    private Binding downToolBinding;
    private IObservableValue contentObservable;

    public EObjectTable(EObject content, EStructuralFeature feature) {
        this.content = content;
        this.feature = feature;
    }

    protected int getStyle() {
        return 2050;
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        Table table = new Table(parent, this.getStyle());
        this.viewer = new TableViewer(table);
        this.configureViewer(this.viewer);
        this.viewer.getControl().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if ('\u007f' == e.character && e.stateMask == 0 && EObjectTable.this.canRemove()) {
                    EObjectTable.this.handleRemove();
                    e.doit = false;
                } else if (EObjectTable.isCharAndModifier(e, SWT.MOD1, 120) && EObjectTable.this.canCut()) {
                    EObjectTable.this.cut();
                    e.doit = false;
                } else if (EObjectTable.isCharAndModifier(e, SWT.MOD1, 99) && EObjectTable.this.canCopy()) {
                    EObjectTable.this.copy();
                    e.doit = false;
                } else if (EObjectTable.isCharAndModifier(e, SWT.MOD1, 118) && EObjectTable.this.canPaste()) {
                    EObjectTable.this.paste();
                    e.doit = false;
                } else if (e.stateMask == SWT.MOD1 && e.keyCode == 0x1000001) {
                    EObjectTable.this.handleUp();
                    e.doit = false;
                } else if (e.stateMask == SWT.MOD1 && e.keyCode == 0x1000002) {
                    EObjectTable.this.handleDown();
                    e.doit = false;
                }
            }
        });
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        if (this.isInternalDragAndDropEnabled()) {
            this.initializeInternalDrapAndDrop();
        }
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                EObjectTable.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        Menu menu = popupMenuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void configureViewer(TableViewer viewer) {
        viewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    public void update(EObject content) {
        this.content = content;
        if (this.contentObservable != null) {
            this.contentObservable.dispose();
        }
        this.contentObservable = EMFObservables.observeValue((EObject)content, (EStructuralFeature)this.feature);
        this.contentObservable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                EObjectTable.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).EObjectTable.this.viewer.getTable().isDisposed()) {
                            (this).EObjectTable.this.viewer.refresh();
                        }
                    }
                });
            }
        });
        this.contentObservable.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                EObjectTable.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).EObjectTable.this.viewer.getControl().isDisposed()) {
                            (this).EObjectTable.this.viewer.refresh();
                        }
                    }
                });
            }
        });
        this.viewer.setInput(this.getViewerContents());
        if (this.removeToolBinding != null) {
            this.removeToolBinding.dispose();
        }
        this.removeToolBinding = this.dbc.bindValue(Actions.observeEnabled((IAction)this.removeTool), (IObservableValue)this.removeToolComputedValue);
        if (this.upToolBinding != null) {
            this.upToolBinding.dispose();
        }
        this.upToolBinding = this.dbc.bindValue(Actions.observeEnabled((IAction)this.upTool), (IObservableValue)this.upToolComputedValue);
        if (this.downToolBinding != null) {
            this.downToolBinding.dispose();
        }
        this.downToolBinding = this.dbc.bindValue(Actions.observeEnabled((IAction)this.downTool), (IObservableValue)this.downToolComputedValue);
        new Job("Update references after indexing"){

            protected IStatus run(IProgressMonitor monitor) {
                ModelManager.getModelManager().getIndexManager().waitUntilReady(monitor);
                EObjectTable.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).EObjectTable.this.viewer.getControl().isDisposed()) {
                            (this).EObjectTable.this.viewer.refresh();
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private static boolean isCharAndModifier(KeyEvent e, int modifiers, int ch) {
        return Character.toLowerCase(e.keyCode) == ch && e.stateMask == modifiers;
    }

    @Override
    public Control getControl() {
        return this.viewer.getControl();
    }

    public void refresh() {
        if (this.getControl().isDisposed()) {
            return;
        }
        this.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!EObjectTable.this.viewer.getTable().isDisposed()) {
                    EObjectTable.this.viewer.setInput(EObjectTable.this.getViewerContents());
                    EObjectTable.this.viewer.refresh(true);
                }
            }
        });
    }

    @Override
    public void createToolBar(Composite parent) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800100);
        this.fillActions((IToolBarManager)toolBarManager);
        this.toolBar = toolBarManager.createControl(parent);
        this.toolBar.moveAbove(null);
    }

    @Override
    public ToolBar getToolBar() {
        return this.toolBar;
    }

    protected boolean isInternalDragAndDropEnabled() {
        return true;
    }

    protected void initializeInternalDrapAndDrop() {
        int ops = 2;
        Transfer[] transferTypes = new Transfer[]{this.getContentTransfer()};
        this.viewer.addDragSupport(ops, transferTypes, (DragSourceListener)new ContentDragListener((StructuredViewer)this.viewer));
        transferTypes = this.getDropTransferTypes();
        this.viewer.addDropSupport(ops, transferTypes, (DropTargetListener)new ContentTableDropListener((StructuredViewer)this.viewer));
    }

    protected Transfer[] getDropTransferTypes() {
        return new Transfer[]{this.getContentTransfer()};
    }

    protected abstract ILabelProvider createLabelProvider();

    @Override
    protected void fillActions(IToolBarManager toolBarManager) {
        this.viewerSelection = ViewersObservables.observeMultiSelection((Viewer)this.viewer);
        this.addTool = new Action(){

            public void run() {
                Object[] newItems = EObjectTable.this.handleAdd();
                EObjectTable.this.doAdd(newItems);
            }
        };
        this.addTool.setText(Messages.EObjectTable_Add);
        this.addTool.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        toolBarManager.add((IAction)this.addTool);
        this.removeTool = new Action(){

            public void run() {
                EObjectTable.this.handleRemove();
            }
        };
        this.removeTool.setText(Messages.EObjectTable_Remove);
        this.removeTool.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_DELETE"));
        this.removeTool.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_DELETE_DISABLED"));
        this.removeToolComputedValue = new ComputedValue(){

            protected Object calculate() {
                return EObjectTable.this.canRemove();
            }
        };
        toolBarManager.add((IAction)this.removeTool);
        this.upToolComputedValue = new ComputedValue(){

            protected Object calculate() {
                return EObjectTable.this.calculateUpToolEnablement();
            }
        };
        this.upTool = new Action(){

            public void run() {
                EObjectTable.this.handleUp();
            }
        };
        this.upTool.setText(Messages.EObjectTable_Up);
        this.upTool.setImageDescriptor(Images.getImageDescriptor("icons/up.gif"));
        toolBarManager.add((IAction)this.upTool);
        this.downToolComputedValue = new ComputedValue(){

            protected Object calculate() {
                return EObjectTable.this.calculateDownToolEnablement();
            }
        };
        this.downTool = new Action(){

            public void run() {
                EObjectTable.this.handleDown();
            }
        };
        this.downTool.setText(Messages.EObjectTable_Down);
        this.downTool.setImageDescriptor(Images.getImageDescriptor("icons/down.gif"));
        toolBarManager.add((IAction)this.downTool);
        this.update(this.content);
    }

    protected EList<Object> getContents() {
        return (EList)this.content.eGet(this.feature);
    }

    protected List<Object> getViewerContents() {
        return this.getContents();
    }

    protected abstract Object[] handleAdd();

    public Object[] getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return selection.toArray();
    }

    public void setSelection(Object[] elements, boolean reveal) {
        StructuredSelection selection = new StructuredSelection(elements);
        this.viewer.setSelection((ISelection)selection, reveal);
    }

    protected abstract Class<?> getContentsType();

    protected abstract Transfer getContentTransfer();

    @Override
    public void handleRemove() {
        Object[] items = this.getSelection();
        this.getContents().removeAll(Arrays.asList(items));
        this.viewer.setInput(this.getViewerContents());
    }

    @Override
    public void cut() {
        this.copy();
        this.handleRemove();
    }

    @Override
    public void copy() {
        ClipboardUtils.setClipboardContents(this.getSelection(), this.getContentTransfer(), this);
    }

    @Override
    public void paste() {
        this.doAdd(ClipboardUtils.getClipboardContents(this.getContentTransfer()));
        this.doAdd(ClipboardUtils.getClipboardContents((Transfer)ResourceTransfer.getInstance()));
        this.refresh();
    }

    protected boolean canAdd(Object[] objects) {
        if (objects == null || objects.length == 0) {
            return false;
        }
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7Element file;
            Object obj = objectArray[n2];
            if (obj instanceof IResource && (file = RcpttCore.create((IResource)((IResource)obj))).getElementType().equals((Object)this.getAppropriateHandleType()) && file.exists()) {
                return true;
            }
            if (!this.getContentsType().isInstance(obj)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected abstract IQ7Element.HandleType getAppropriateHandleType();

    protected void doAdd(Object[] objects) {
        if (objects == null) {
            return;
        }
        EList<Object> content = this.getContents();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7Element file;
            Object obj;
            Object val = obj = objectArray[n2];
            if (obj instanceof IResource && (file = RcpttCore.create((IResource)((IResource)obj))).getElementType().equals((Object)this.getAppropriateHandleType()) && file.exists()) {
                try {
                    val = ((IContext)file).getID();
                }
                catch (ModelException e) {
                    Q7UIPlugin.log(e);
                }
            }
            if (!content.contains(val)) {
                content.add(val);
            }
            ++n2;
        }
        this.viewer.setInput(this.getViewerContents());
        this.setSelection(objects, true);
    }

    @Override
    public boolean canRemove() {
        if (this.viewerSelection.isEmpty() || this.viewerSelection.isDisposed()) {
            return false;
        }
        Object object = this.viewerSelection.get(0);
        EList<Object> contents = this.getContents();
        ArrayList<Object> viewerContents = new ArrayList<Object>(this.getViewerContents());
        viewerContents.removeAll((Collection<?>)contents);
        if (viewerContents.contains(object)) {
            return false;
        }
        return !this.viewer.getSelection().isEmpty();
    }

    @Override
    public boolean canCut() {
        if (this.viewerSelection.isEmpty() || this.viewerSelection.isDisposed()) {
            return false;
        }
        Object object = this.viewerSelection.get(0);
        EList<Object> contents = this.getContents();
        ArrayList<Object> viewerContents = new ArrayList<Object>(this.getViewerContents());
        viewerContents.removeAll((Collection<?>)contents);
        if (viewerContents.contains(object)) {
            return false;
        }
        return this.viewer.getControl().isFocusControl() && !this.viewer.getSelection().isEmpty();
    }

    @Override
    public boolean canCopy() {
        return this.viewer.getControl().isFocusControl() && !this.viewer.getSelection().isEmpty();
    }

    @Override
    public boolean canPaste() {
        return this.viewer.getControl().isFocusControl() && this.canAdd(ClipboardUtils.getClipboardContents(this.getContentTransfer())) || this.canAdd(ClipboardUtils.getClipboardContents((Transfer)ResourceTransfer.getInstance()));
    }

    protected void fillContextMenu(IMenuManager manager) {
        this.removeAction = new SelectionAction.RemoveAction(this);
        this.cutAction = new SelectionAction.CutAction(this);
        this.copyAction = new SelectionAction.CopyAction(this);
        this.pasteAction = new SelectionAction.PasteAction(this);
        this.removeAction.update();
        this.cutAction.update();
        this.copyAction.update();
        this.pasteAction.update();
        manager.add((IAction)this.removeAction);
        manager.add((IAction)this.cutAction);
        manager.add((IAction)this.copyAction);
        manager.add((IAction)this.pasteAction);
    }

    @Override
    public String getContentName(Object content) {
        return content.toString();
    }

    protected boolean allowDrag(IStructuredSelection selection) {
        return selection.size() == 1;
    }

    protected boolean doPerformDrop(Object data, Object currentTarget, int currentLocation) {
        Object[] toDrop;
        Object[] objectArray = toDrop = (Object[])data;
        int n = toDrop.length;
        int n2 = 0;
        while (n2 < n) {
            Object toDropObject = objectArray[n2];
            if (toDropObject.equals(currentTarget)) {
                return false;
            }
            ++n2;
        }
        EList<Object> content = this.getContents();
        int targetPosition = content.size() - 1;
        if (currentTarget != null) {
            targetPosition = content.indexOf(currentTarget);
        }
        int i = 0;
        while (i < toDrop.length) {
            Object toDropObject = toDrop[i];
            int oldPosition = content.indexOf(toDropObject);
            if (oldPosition == -1) {
                if (currentLocation == 2 || currentLocation == 4) {
                    ++targetPosition;
                }
                if (targetPosition != -1) {
                    content.add(targetPosition, toDropObject);
                } else {
                    content.add(toDropObject);
                }
            } else if (oldPosition < targetPosition && currentLocation == 1) {
                content.move(targetPosition - 1, oldPosition);
            } else if (oldPosition > targetPosition && currentLocation == 2) {
                content.move(targetPosition + 1, oldPosition);
            } else {
                if (targetPosition < 0) {
                    return false;
                }
                content.move(targetPosition, oldPosition);
            }
            ++i;
        }
        this.refresh();
        return true;
    }

    protected boolean doValidateDrop(Object target, int operation, TransferData transferType, int currentLocation) {
        return this.getContentTransfer().isSupportedType(transferType) && currentLocation != 3;
    }

    private void handleUp() {
        Object item = this.getSelection()[0];
        EList<Object> list = this.getContents();
        int index = list.indexOf(item);
        this.getContents().move(index - 1, index);
        this.viewerSelection.clear();
        this.viewerSelection.add(item);
        this.viewer.setInput(this.getViewerContents());
    }

    private void handleDown() {
        Object item = this.getSelection()[0];
        EList<Object> list = this.getContents();
        int index = list.indexOf(item);
        this.getContents().move(index + 1, index);
        this.viewerSelection.clear();
        this.viewerSelection.add(item);
        this.viewer.setInput(this.getViewerContents());
    }

    protected Object calculateUpToolEnablement() {
        if (this.viewerSelection.isEmpty() || this.viewerSelection.isDisposed()) {
            return false;
        }
        Object object = this.viewerSelection.get(0);
        EList<Object> contents = this.getContents();
        ArrayList<Object> viewerContents = new ArrayList<Object>(this.getViewerContents());
        viewerContents.removeAll((Collection<?>)contents);
        if (viewerContents.contains(object)) {
            return false;
        }
        Object first = Iterables.getFirst(contents, null);
        if (object != first) {
            return true;
        }
        return false;
    }

    private Object calculateDownToolEnablement() {
        if (this.viewerSelection.isEmpty() || this.viewerSelection.isDisposed()) {
            return false;
        }
        Object object = this.viewerSelection.get(this.viewerSelection.size() - 1);
        EList<Object> contents = this.getContents();
        ArrayList<Object> viewerContents = new ArrayList<Object>(this.getViewerContents());
        viewerContents.removeAll((Collection<?>)contents);
        if (viewerContents.contains(object)) {
            return false;
        }
        Object last = Iterables.getLast(contents, null);
        if (object != last) {
            return true;
        }
        return false;
    }

    @Override
    public void undo() {
    }

    @Override
    public void redo() {
    }

    @Override
    public boolean canUndo() {
        return false;
    }

    @Override
    public boolean canRedo() {
        return false;
    }

    @Override
    public void dispose() {
        if (this.contentObservable != null) {
            this.contentObservable.dispose();
        }
        super.dispose();
    }

    private class ContentDragListener
    extends DragSourceAdapter {
        private final StructuredViewer structuredViewer;

        public ContentDragListener(StructuredViewer structuredViewer) {
            this.structuredViewer = structuredViewer;
        }

        public void dragStart(DragSourceEvent event) {
            event.doit = EObjectTable.this.allowDrag((IStructuredSelection)this.structuredViewer.getSelection());
        }

        public void dragSetData(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.structuredViewer.getSelection();
            List selectedElements = selection.toList();
            Object[] objects = selectedElements.toArray(new Object[]{selection.size()});
            Transfer transfer = EObjectTable.this.getContentTransfer();
            if (transfer.isSupportedType(event.dataType)) {
                event.data = objects;
            }
        }
    }

    private class ContentTableDropListener
    extends ViewerDropAdapter {
        public ContentTableDropListener(StructuredViewer structuredViewer) {
            super((Viewer)structuredViewer);
        }

        public boolean performDrop(Object data) {
            return EObjectTable.this.doPerformDrop(data, this.getCurrentTarget(), this.getCurrentLocation());
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            return EObjectTable.this.doValidateDrop(target, operation, transferType, this.getCurrentLocation());
        }
    }
}

