/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.plugin.ImportObject;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEOutlinePage;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.editor.IFormPage;

public class FormOutlinePage
extends PDEOutlinePage
implements IModelChangedListener,
ISortableContentOutlinePage {
    private boolean fStale;
    private ViewerComparator fViewerComparator;
    private boolean fSorted;
    protected TreeViewer fTreeViewer;
    protected boolean fEditorSelection = false;
    protected boolean fOutlineSelection = false;

    public FormOutlinePage(PDEFormEditor editor) {
        super(editor);
    }

    public ITreeContentProvider createContentProvider() {
        return new BasicContentProvider();
    }

    public ViewerComparator createOutlineSorter() {
        return new BasicComparator();
    }

    public void createControl(Composite parent) {
        Tree widget = new Tree(parent, 770);
        this.fTreeViewer = new TreeViewer(widget);
        this.fTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fTreeViewer.setContentProvider((IContentProvider)this.createContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.fViewerComparator = this.createOutlineSorter();
        if (this.fSorted) {
            this.fTreeViewer.setComparator(this.fViewerComparator);
        } else {
            this.fTreeViewer.setComparator(null);
        }
        this.fTreeViewer.setAutoExpandLevel(-1);
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeViewer.setInput((Object)this.fEditor);
        IBaseModel model = this.fEditor.getAggregateModel();
        if (model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)model).addModelChangedListener((IModelChangedListener)this);
        }
    }

    public ILabelProvider createLabelProvider() {
        return new BasicLabelProvider((ILabelProvider)PDEPlugin.getDefault().getLabelProvider());
    }

    public void dispose() {
        IBaseModel model = this.fEditor.getAggregateModel();
        if (model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)model).removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public Control getControl() {
        return this.fTreeViewer != null ? this.fTreeViewer.getControl() : null;
    }

    private Object[] getPages() {
        ArrayList<IFormPage> formPages = new ArrayList<IFormPage>();
        IFormPage[] pages = this.fEditor.getPages();
        int i = 0;
        while (i < pages.length) {
            if (!pages[i].isEditor()) {
                formPages.add(pages[i]);
            }
            ++i;
        }
        return formPages.toArray();
    }

    public void modelChanged(IModelChangedEvent event) {
        IFormPage page = this.fEditor.getActivePageInstance();
        this.fStale = true;
        if (!page.isEditor()) {
            this.refresh();
        }
    }

    public void refresh() {
        if (this.fStale) {
            Control control = this.getControl();
            if (control == null || control.isDisposed()) {
                return;
            }
            control.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!FormOutlinePage.this.fTreeViewer.getControl().isDisposed()) {
                        FormOutlinePage.this.fTreeViewer.refresh();
                        FormOutlinePage.this.fTreeViewer.expandAll();
                        FormOutlinePage.this.fStale = false;
                    }
                }
            });
        }
    }

    protected String getParentPageId(Object item) {
        if (item instanceof IFormPage) {
            return ((IFormPage)item).getId();
        }
        return null;
    }

    protected Object[] getChildren(Object parent) {
        return new Object[0];
    }

    public void selectionChanged(Object item) {
        IFormPage revealPage;
        IFormPage page = this.fEditor.getActivePageInstance();
        String id = this.getParentPageId(item);
        IFormPage newPage = null;
        if (!(id == null || page != null && page.getId().equals(id))) {
            newPage = this.fEditor.setActivePage(id);
        }
        IFormPage iFormPage = revealPage = newPage != null ? newPage : page;
        if (revealPage != null && !(item instanceof IFormPage)) {
            revealPage.selectReveal(item);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.fEditorSelection) {
            return;
        }
        this.fOutlineSelection = true;
        try {
            ISelection selection = event.getSelection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                IStructuredSelection ssel = (IStructuredSelection)selection;
                Object item = ssel.getFirstElement();
                this.selectionChanged(item);
            }
            this.fireSelectionChanged(selection);
        }
        finally {
            this.fOutlineSelection = false;
        }
    }

    public void setFocus() {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.getTree().setFocus();
        }
    }

    public ISelection getSelection() {
        if (this.fTreeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.fTreeViewer.getSelection();
    }

    @Override
    public void sort(boolean sorting) {
        this.fSorted = sorting;
        if (this.fTreeViewer != null) {
            if (sorting) {
                this.fTreeViewer.setComparator(this.fViewerComparator);
            } else {
                this.fTreeViewer.setComparator(null);
            }
        }
    }

    public void setSelection(ISelection selection) {
        if (this.fOutlineSelection) {
            return;
        }
        this.fEditorSelection = true;
        try {
            if (this.fTreeViewer == null) {
                return;
            }
            if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
                Object item = ((IStructuredSelection)selection).getFirstElement();
                if (item instanceof ImportObject) {
                    selection = new StructuredSelection((Object)((ImportObject)item).getImport());
                }
                if (item instanceof IDocumentElementNode) {
                    while (this.fTreeViewer.testFindItem(item) == null) {
                        if ((item = ((IDocumentElementNode)item).getParentNode()) == null) break;
                        selection = new StructuredSelection(item);
                    }
                }
            }
            this.fTreeViewer.setSelection(selection);
        }
        finally {
            this.fEditorSelection = false;
        }
    }

    protected TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    public class BasicComparator
    extends ViewerComparator {
        public int category(Object element) {
            Object[] pages = FormOutlinePage.this.getPages();
            int i = 0;
            while (i < pages.length) {
                if (pages[i] == element) {
                    return i;
                }
                ++i;
            }
            return Integer.MAX_VALUE;
        }
    }

    public class BasicContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object obj) {
            return FormOutlinePage.this.getPages();
        }

        public Object[] getChildren(Object obj) {
            return FormOutlinePage.this.getChildren(obj);
        }

        public boolean hasChildren(Object obj) {
            return this.getChildren(obj).length > 0;
        }

        public Object getParent(Object obj) {
            return null;
        }
    }

    public class BasicLabelProvider
    extends LabelProvider {
        private ILabelProvider fWrappedLabelProvider;

        public BasicLabelProvider(ILabelProvider ilp) {
            this.fWrappedLabelProvider = ilp;
        }

        public String getText(Object obj) {
            if (obj instanceof IFormPage) {
                return ((IFormPage)obj).getTitle();
            }
            return this.fWrappedLabelProvider.getText(obj);
        }

        public Image getImage(Object obj) {
            if (obj instanceof IFormPage) {
                return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PAGE_OBJ);
            }
            return this.fWrappedLabelProvider.getImage(obj);
        }
    }
}

