/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.indexdiff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.Repository;

public class GitResourceDeltaVisitor
implements IResourceDeltaVisitor {
    private static final String GITIGNORE_NAME = ".gitignore";
    private static int INTERESTING_CHANGES = 323840;
    private final Repository repository;
    private final Collection<String> filesToUpdate;
    private final Collection<IResource> resourcesToUpdate;
    private boolean gitIgnoreChanged = false;

    public GitResourceDeltaVisitor(Repository repository) {
        this.repository = repository;
        this.filesToUpdate = new HashSet<String>();
        this.resourcesToUpdate = new HashSet<IResource>();
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource.getType() == 8) {
            return true;
        }
        if (resource.getType() == 4) {
            RepositoryMapping mapping = RepositoryMapping.getMapping((IProject)resource);
            return mapping != null && mapping.getRepository() == this.repository;
        }
        if (resource.isLinked()) {
            return false;
        }
        if (resource.getType() == 2) {
            if (delta.getKind() == 1) {
                String repoRelativePath = GitResourceDeltaVisitor.getRepoRelativePath(resource);
                if (repoRelativePath == null) {
                    return false;
                }
                String path = String.valueOf(repoRelativePath) + "/";
                if (this.isIgnoredInOldIndex(path)) {
                    return true;
                }
                this.filesToUpdate.add(path);
                this.resourcesToUpdate.add(resource);
            }
            return true;
        }
        if (delta.getKind() == 4 && (delta.getFlags() & INTERESTING_CHANGES) == 0) {
            return false;
        }
        if (resource.getName().equals(GITIGNORE_NAME)) {
            this.gitIgnoreChanged = true;
            return false;
        }
        String repoRelativePath = GitResourceDeltaVisitor.getRepoRelativePath(resource);
        if (repoRelativePath == null) {
            this.resourcesToUpdate.add(resource);
            return true;
        }
        if (this.isIgnoredInOldIndex(repoRelativePath)) {
            return false;
        }
        this.filesToUpdate.add(repoRelativePath);
        this.resourcesToUpdate.add(resource);
        return true;
    }

    private static String getRepoRelativePath(IResource resource) {
        RepositoryMapping mapping = RepositoryMapping.getMapping(resource.getProject());
        if (mapping == null) {
            return null;
        }
        return mapping.getRepoRelativePath(resource);
    }

    private boolean isIgnoredInOldIndex(String path) {
        if (this.gitIgnoreChanged) {
            return false;
        }
        IndexDiffCacheEntry entry = null;
        IndexDiffCache cache = Activator.getDefault().getIndexDiffCache();
        if (cache != null) {
            entry = cache.getIndexDiffCacheEntry(this.repository);
        }
        if (entry == null) {
            return false;
        }
        IndexDiffData indexDiff = entry.getIndexDiff();
        if (indexDiff == null) {
            return false;
        }
        String p = path;
        Set<String> ignored = indexDiff.getIgnoredNotInIndex();
        while (p != null) {
            if (ignored.contains(p)) {
                return true;
            }
            p = this.skipLastSegment(p);
        }
        return false;
    }

    private String skipLastSegment(String path) {
        int slashPos = path.lastIndexOf(47);
        return slashPos == -1 ? null : path.substring(0, slashPos);
    }

    public Collection<IFile> getFileResourcesToUpdate() {
        ArrayList<IFile> result = new ArrayList<IFile>();
        for (IResource resource : this.resourcesToUpdate) {
            if (!(resource instanceof IFile)) continue;
            result.add((IFile)resource);
        }
        return result;
    }

    public Collection<IResource> getResourcesToUpdate() {
        return this.resourcesToUpdate;
    }

    public Collection<String> getFilesToUpdate() {
        return this.filesToUpdate;
    }

    public boolean getGitIgnoreChanged() {
        return this.gitIgnoreChanged;
    }
}

