/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.patch;

import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.GitCreatePatchWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class PatchOperationUI {
    private IWorkbenchPart part;
    private Repository repository;
    private RevCommit commit;
    private Collection<? extends IResource> resources;

    private PatchOperationUI(IWorkbenchPart part, Repository repo) {
        this.part = part;
        this.repository = repo;
    }

    private PatchOperationUI(IWorkbenchPart part, Repository repo, RevCommit commit) {
        this(part, repo);
        this.commit = commit;
    }

    private PatchOperationUI(IWorkbenchPart part, Repository repo, Collection<? extends IResource> resources) {
        this(part, repo);
        this.resources = resources;
    }

    public static PatchOperationUI createPatch(IWorkbenchPart part, RevCommit commit, Repository repo) {
        return new PatchOperationUI(part, repo, commit);
    }

    public static PatchOperationUI createPatch(IWorkbenchPart part, Repository repo, Collection<? extends IResource> resources) {
        return new PatchOperationUI(null, repo, resources);
    }

    public void start() {
        if (this.commit != null) {
            GitCreatePatchWizard.run(this.getShell(), this.commit, this.repository, null);
            return;
        }
        if (this.isWorkingTreeClean()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)UIText.GitCreatePatchAction_cannotCreatePatch, (String)UIText.GitCreatePatchAction_workingTreeClean);
            return;
        }
        GitCreatePatchWizard.run(this.getShell(), null, this.repository, this.resources);
    }

    private boolean isWorkingTreeClean() {
        IndexDiffData diffData;
        IndexDiffCache diffCache = Activator.getDefault().getIndexDiffCache();
        if (diffCache != null && (diffData = diffCache.getIndexDiffCacheEntry(this.repository).getIndexDiff()) != null) {
            Set modified = diffData.getModified();
            Set untracked = diffData.getUntracked();
            Set missing = diffData.getMissing();
            for (IResource iResource : this.resources) {
                String repoRelativePath = this.makeRepoRelative(iResource);
                if (this.containsPrefix(modified, repoRelativePath)) {
                    return false;
                }
                if (this.containsPrefix(untracked, repoRelativePath)) {
                    return false;
                }
                if (!this.containsPrefix(missing, repoRelativePath)) continue;
                return false;
            }
        }
        return true;
    }

    private String makeRepoRelative(IResource res) {
        return Repository.stripWorkDir((File)this.repository.getWorkTree(), (File)res.getLocation().toFile());
    }

    private boolean containsPrefix(Set<String> collection, String prefix) {
        for (String path : collection) {
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private Shell getShell() {
        return PatchOperationUI.getShell(this.part);
    }

    private static Shell getShell(IWorkbenchPart part) {
        if (part != null) {
            return part.getSite().getShell();
        }
        return PlatformUI.getWorkbench().getDisplay().getActiveShell();
    }
}

