/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.env;

import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.apt.AnnotationProcessorListener;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.apt.core.env.EclipseAnnotationProcessorEnvironment;
import org.eclipse.jdt.apt.core.env.Phase;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.declaration.TypeDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.env.APTProblem;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.env.BuildEnv;
import org.eclipse.jdt.apt.core.internal.env.EnvUtil;
import org.eclipse.jdt.apt.core.internal.env.MessagerImpl;
import org.eclipse.jdt.apt.core.internal.env.ReconcileEnv;
import org.eclipse.jdt.apt.core.internal.util.Factory;
import org.eclipse.jdt.apt.core.internal.util.Visitors;
import org.eclipse.jdt.apt.core.util.EclipseMessager;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.ReconcileContext;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;

public abstract class AbstractCompilationEnv
extends BaseProcessorEnv
implements EclipseAnnotationProcessorEnvironment {
    private static final String RTTG_ENABLED_DASH_A_OPTION = "-AenableTypeGenerationInEditor";
    private static final String PROCESSING_IN_EDITOR_DISABLED_DASH_A_OPTION = "-AdisableProcessingInEditor";
    private Set<AnnotationProcessorListener> _listeners = null;
    protected List<APTProblem> _problems = new ArrayList<APTProblem>();
    private boolean _isClosed = false;
    EnvCallback _callback;
    private Set<IFile> _allGeneratedSourceFiles = new HashSet<IFile>();
    private Set<IFile> _modifiedGeneratedSourceFiles = new HashSet<IFile>();
    protected ASTRequestor _requestor;
    private AnnotationProcessorFactory _currentProcessorFactory = null;
    private boolean _currentProcessorFactoryWillReconcile;

    public static void newReconcileEnv(ReconcileContext reconcileContext, EnvCallback callback) {
        assert (reconcileContext != null) : "reconcile context is null";
        ReconcileEnv env = ReconcileEnv.newEnv(reconcileContext);
        env._callback = callback;
        env.openPipeline();
    }

    public static void newBuildEnv(BuildContext[] filesWithAnnotations, BuildContext[] additionalFiles, IJavaProject javaProj, EnvCallback callback) {
        assert (filesWithAnnotations != null) : "missing files";
        BuildEnv env = new BuildEnv(filesWithAnnotations, additionalFiles, javaProj);
        env._callback = callback;
        env.createASTs(filesWithAnnotations);
    }

    public static boolean doesFactorySupportReconcile(AnnotationProcessorFactory factory) {
        Collection<String> options = factory.supportedOptions();
        return options == null || !options.contains("disableProcessingInEditor") && !options.contains(PROCESSING_IN_EDITOR_DISABLED_DASH_A_OPTION);
    }

    AbstractCompilationEnv(CompilationUnit compilationUnit, IFile file, IJavaProject javaProj, Phase phase) {
        super(compilationUnit, file, javaProj, phase);
    }

    @Override
    protected IBinding getBindingFromKey(String key, ICompilationUnit unit) {
        return this._requestor.createBindings(new String[]{key})[0];
    }

    @Override
    public void addListener(AnnotationProcessorListener listener) {
        this.checkValid();
        if (this._listeners == null) {
            this._listeners = new HashSet<AnnotationProcessorListener>();
        }
        this._listeners.add(listener);
    }

    @Override
    public void removeListener(AnnotationProcessorListener listener) {
        this.checkValid();
        if (this._listeners == null) {
            return;
        }
        this._listeners.remove(listener);
    }

    public Set<AnnotationProcessorListener> getProcessorListeners() {
        if (this._listeners == null) {
            return Collections.emptySet();
        }
        return new HashSet<AnnotationProcessorListener>(this._listeners);
    }

    @Override
    public Map<String, String> getOptions() {
        HashMap<String, String> options = new HashMap<String, String>(this._options);
        options.put("phase", this.getPhase().toString());
        return options;
    }

    public abstract CompilationUnit getASTFrom(IFile var1);

    @Override
    public CompilationUnit getAST() {
        return this._astRoot;
    }

    @Override
    public EclipseMessager getMessager() {
        this.checkValid();
        return new MessagerImpl(this);
    }

    abstract void addMessage(IFile var1, int var2, int var3, MessagerImpl.Severity var4, String var5, int var6, String[] var7);

    public List<? extends CategorizedProblem> getProblems() {
        this.checkValid();
        if (!this._problems.isEmpty()) {
            EnvUtil.updateProblemLength(this._problems, this.getAstCompilationUnit());
        }
        return this._problems;
    }

    APTProblem createProblem(IFile resource, int start, int end, MessagerImpl.Severity severity, String msg, int line, String[] arguments) {
        APTProblem newProblem = new APTProblem(msg, severity, resource, start, end - 1, line, arguments, !this._currentProcessorFactoryWillReconcile);
        return newProblem;
    }

    @Override
    public abstract Filer getFiler();

    public void addGeneratedSourceFile(IFile f, boolean contentsChanged) {
        if (!f.toString().endsWith(".java")) {
            throw new IllegalArgumentException("Source files must be java source files, and end with .java");
        }
        boolean addedToAll = this._allGeneratedSourceFiles.add(f);
        boolean addedToMod = false;
        if (contentsChanged) {
            addedToMod = this._modifiedGeneratedSourceFiles.add(f);
        }
        if (AptPlugin.DEBUG_COMPILATION_ENV) {
            AptPlugin.trace("add generated file " + f + " to env " + this + "; addToAll = " + addedToAll + "; addToMod = " + addedToMod + "; contentsChanged = " + contentsChanged);
        }
    }

    public void addGeneratedNonSourceFile(IFile file) {
        this._allGeneratedSourceFiles.add(file);
    }

    public Set<IFile> getAllGeneratedFiles() {
        return this._allGeneratedSourceFiles;
    }

    public Set<IFile> getModifiedGeneratedFiles() {
        return this._modifiedGeneratedSourceFiles;
    }

    public boolean hasGeneratedSourceFiles() {
        return !this._allGeneratedSourceFiles.isEmpty();
    }

    public Map<String, AnnotationTypeDeclaration> getAnnotationTypes() {
        this.checkValid();
        ArrayList<Annotation> instances = new ArrayList<Annotation>();
        HashMap<String, AnnotationTypeDeclaration> decls = new HashMap<String, AnnotationTypeDeclaration>();
        Visitors.AnnotationVisitor visitor = new Visitors.AnnotationVisitor(instances);
        this._astRoot.accept((ASTVisitor)visitor);
        int instanceIndex = 0;
        int size = instances.size();
        while (instanceIndex < size) {
            TypeDeclarationImpl decl;
            Annotation instance = (Annotation)instances.get(instanceIndex);
            ITypeBinding annoType = instance.resolveTypeBinding();
            if (annoType != null && (decl = Factory.createReferenceType(annoType, this)) != null && decl.kind() == EclipseMirrorObject.MirrorKind.TYPE_ANNOTATION) {
                AnnotationTypeDeclaration annoDecl = (AnnotationTypeDeclaration)((Object)decl);
                decls.put(annoDecl.getQualifiedName(), annoDecl);
            }
            ++instanceIndex;
        }
        return decls;
    }

    void checkValid() {
        if (this._isClosed) {
            throw new IllegalStateException("Environment has expired");
        }
    }

    protected void completedProcessing() {
        this._modifiedGeneratedSourceFiles.clear();
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        if (this._listeners != null) {
            this._listeners.clear();
        }
        this._problems = null;
        this._typeCache.clear();
        this._packageRootsCache = null;
        this._isClosed = true;
        this._callback = null;
        this._requestor = null;
        this._allGeneratedSourceFiles = null;
        this._modifiedGeneratedSourceFiles = null;
        if (AptPlugin.DEBUG_COMPILATION_ENV) {
            AptPlugin.trace("closed env " + this);
        }
    }

    boolean isClosed() {
        return this._isClosed;
    }

    public void validateTypeName(String typeName) throws CoreException {
        String complianceLevel;
        Map options = this.getJavaProject().getOptions(true);
        String sourceLevel = (String)options.get("org.eclipse.jdt.core.compiler.source");
        IStatus status = JavaConventions.validateJavaTypeName((String)typeName, (String)sourceLevel, (String)(complianceLevel = (String)options.get("org.eclipse.jdt.core.compiler.compliance")));
        if (status.matches(4)) {
            throw new CoreException(status);
        }
    }

    public AnnotationProcessorFactory getCurrentProcessorFactory() {
        return this._currentProcessorFactory;
    }

    public void setCurrentProcessorFactory(AnnotationProcessorFactory factory, boolean willReconcile) {
        this._currentProcessorFactory = factory;
        this._currentProcessorFactoryWillReconcile = willReconcile;
    }

    public boolean currentProcessorSupportsRTTG() {
        AnnotationProcessorFactory factory = this.getCurrentProcessorFactory();
        if (factory == null) {
            return false;
        }
        Collection<String> options = factory.supportedOptions();
        if (options == null) {
            return false;
        }
        return options.contains("enableTypeGenerationInEditor") || options.contains(RTTG_ENABLED_DASH_A_OPTION);
    }

    public static interface EnvCallback {
        public void run(AbstractCompilationEnv var1);
    }
}

