/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.egit.core.synchronize.GitResourceVariantTreeSubscriber;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.operations.GitScopeOperation;
import org.eclipse.egit.ui.internal.operations.GitScopeOperationFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.IContributorResourceAdapter2;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.services.IServiceLocator;

public class GitScopeUtil {
    public static IResource[] getRelatedChanges(IWorkbenchPart part, IResource[] resources) throws ExecutionException, InterruptedException {
        IResource[] resourcesInScope;
        if (part == null) {
            throw new IllegalArgumentException();
        }
        if (resources == null) {
            return new IResource[0];
        }
        if (Activator.getDefault().getPreferenceStore().getBoolean("enable_logical_model")) {
            try {
                resourcesInScope = GitScopeUtil.findRelatedChanges(part, resources);
            }
            catch (InvocationTargetException e) {
                Activator.handleError(UIText.CommitActionHandler_errorBuildingScope, e.getCause(), true);
                resourcesInScope = resources;
            }
        } else {
            resourcesInScope = resources;
        }
        return resourcesInScope;
    }

    private static SubscriberScopeManager createScopeManager(IResource[] resources, IProgressMonitor monitor) {
        ResourceMapping[] mappings = GitScopeUtil.getResourceMappings(resources);
        GitSynchronizeDataSet set = new GitSynchronizeDataSet();
        GitResourceVariantTreeSubscriber subscriber = new GitResourceVariantTreeSubscriber(set);
        monitor.setTaskName(UIText.GitModelSynchronize_fetchGitDataJobName);
        subscriber.init(monitor);
        SubscriberScopeManager manager = new SubscriberScopeManager(UIText.GitScopeOperation_GitScopeManager, mappings, (Subscriber)subscriber, true);
        return manager;
    }

    private static ResourceMapping getResourceMapping(Object o) {
        if (o instanceof ResourceMapping) {
            return (ResourceMapping)o;
        }
        if (o instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)o;
            ResourceMapping adapted = CommonUtils.getAdapter(adaptable, ResourceMapping.class);
            if (adapted instanceof ResourceMapping) {
                return adapted;
            }
            adapted = CommonUtils.getAdapter(adaptable, IContributorResourceAdapter.class);
            if (adapted instanceof IContributorResourceAdapter2) {
                IContributorResourceAdapter2 cra = (IContributorResourceAdapter2)adapted;
                return cra.getAdaptedResourceMapping(adaptable);
            }
        } else {
            Object adapted = Platform.getAdapterManager().getAdapter(o, ResourceMapping.class);
            if (adapted instanceof ResourceMapping) {
                return (ResourceMapping)adapted;
            }
        }
        return null;
    }

    private static ResourceMapping[] getResourceMappings(IResource[] resources) {
        ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            result.add(GitScopeUtil.getResourceMapping(resource));
            ++n2;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }

    private static IResource[] findRelatedChanges(final IWorkbenchPart part, final IResource[] selectedResources) throws InvocationTargetException, InterruptedException {
        final ArrayList relatedChanges = new ArrayList();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask(UIText.CommitActionHandler_lookingForChanges, 100);
                    List collectedResources = GitScopeUtil.collectRelatedChanges(selectedResources, part, monitor);
                    relatedChanges.addAll(collectedResources);
                }
                finally {
                    monitor.done();
                }
            }
        };
        IProgressService progressService = CommonUtils.getService((IServiceLocator)part.getSite(), IProgressService.class);
        progressService.run(true, true, runnable);
        return relatedChanges.toArray(new IResource[relatedChanges.size()]);
    }

    private static List<IResource> collectRelatedChanges(IResource[] selectedResources, IWorkbenchPart part, IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        SubscriberScopeManager manager = GitScopeUtil.createScopeManager(selectedResources, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        GitScopeOperation buildScopeOperation = GitScopeOperationFactory.getFactory().createGitScopeOperation(part, manager);
        buildScopeOperation.run((IProgressMonitor)new SubProgressMonitor(monitor, 50));
        return buildScopeOperation.getRelevantResources();
    }
}

