/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.ApiDescriptionManager;
import org.eclipse.pde.api.tools.internal.builder.BuildState;
import org.eclipse.pde.api.tools.internal.model.ApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.util.Util;

public class WorkspaceDeltaProcessor
implements IElementChangedListener,
IResourceChangeListener {
    ApiBaselineManager bmanager = ApiBaselineManager.getManager();
    ApiDescriptionManager dmanager = ApiDescriptionManager.getManager();

    public void elementChanged(ElementChangedEvent event) {
        this.processJavaElementDeltas(event.getDelta().getAffectedChildren(), null);
    }

    void processJavaElementDeltas(IJavaElementDelta[] deltas, IJavaProject project) {
        int i = 0;
        while (i < deltas.length) {
            IJavaElementDelta delta = deltas[i];
            block1 : switch (delta.getElement().getElementType()) {
                case 2: {
                    IJavaProject proj = (IJavaProject)delta.getElement();
                    int flags = delta.getFlags();
                    block7 : switch (delta.getKind()) {
                        case 4: {
                            if (!Util.isApiProject(proj)) {
                                if (!ApiPlugin.DEBUG_WORKSPACE_DELTA_PROCESSOR) break;
                                System.out.println("--> skipped processing CHANGED delta for project: " + proj.getElementName());
                                break;
                            }
                            if ((flags & 0x200) != 0) {
                                if (ApiPlugin.DEBUG_WORKSPACE_DELTA_PROCESSOR) {
                                    System.out.println("--> processing OPEN project: [" + proj.getElementName() + "]");
                                }
                                this.bmanager.disposeWorkspaceBaseline();
                                break;
                            }
                            if ((flags & 0x200000) != 0 || (flags & 0x20000) != 0) {
                                if (ApiPlugin.DEBUG_WORKSPACE_DELTA_PROCESSOR) {
                                    System.out.println("--> processing CLASSPATH CHANGE project: [" + proj.getElementName() + "]");
                                }
                                this.bmanager.disposeWorkspaceBaseline();
                                this.dmanager.projectClasspathChanged(proj);
                                try {
                                    BuildState.setLastBuiltState(proj.getProject(), null);
                                }
                                catch (CoreException coreException) {}
                                this.dmanager.flushElementCache(delta.getElement());
                                break;
                            }
                            if ((flags & 8) != 0) {
                                if (ApiPlugin.DEBUG_WORKSPACE_DELTA_PROCESSOR) {
                                    System.out.println("--> processing CHILDREN delta of project: [" + proj.getElementName() + "]");
                                }
                                this.processJavaElementDeltas(delta.getAffectedChildren(), proj);
                                break;
                            }
                            if ((flags & 1) == 0) break;
                            if (proj != null) {
                                IResourceDelta[] resourcedeltas;
                                if (ApiPlugin.DEBUG_WORKSPACE_DELTA_PROCESSOR) {
                                    System.out.println("--> processing child CONTENT of project: [" + proj.getElementName() + "]");
                                }
                                if ((resourcedeltas = delta.getResourceDeltas()) == null) break;
                                IResourceDelta rdelta = null;
                                int j = 0;
                                while (j < resourcedeltas.length) {
                                    rdelta = resourcedeltas[j].findMember((IPath)new Path("MANIFEST.MF"));
                                    if (rdelta != null && rdelta.getKind() == 4 && (rdelta.getFlags() & 0x100) > 0) {
                                        if (ApiPlugin.DEBUG_WORKSPACE_DELTA_PROCESSOR) {
                                            System.out.println("--> processing manifest delta");
                                        }
                                        this.bmanager.disposeWorkspaceBaseline();
                                        break block7;
                                    }
                                    ++j;
                                }
                                break block1;
                            }
                            if (!ApiPlugin.DEBUG_WORKSPACE_DELTA_PROCESSOR) break;
                            System.out.println("--> ignoring child CONTENT project context is null");
                            break;
                        }
                        case 1: {
                            if (!Util.isApiProject(proj)) {
                                if (!ApiPlugin.DEBUG_WORKSPACE_DELTA_PROCESSOR) break;
                                System.out.println("--> skipped processing ADDED delta for project: " + proj.getElementName());
                                break;
                            }
                            if ((flags & 0x10) == 0) break;
                            if (ApiPlugin.DEBUG_WORKSPACE_DELTA_PROCESSOR) {
                                System.out.println("--> processing PROJECT RENAME from: [" + delta.getMovedFromElement().getJavaProject().getElementName() + "] to: [" + proj.getElementName() + "]");
                            }
                            this.bmanager.disposeWorkspaceBaseline();
                            break;
                        }
                    }
                    break;
                }
                case 3: {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)delta.getElement();
                    int flags = delta.getFlags();
                    if ((flags & 0x80C0) != 0) {
                        if (ApiPlugin.DEBUG_WORKSPACE_DELTA_PROCESSOR) {
                            System.out.println("processed CLASSPATH CHANGED for package fragment root: [" + root.getElementName() + "]");
                        }
                        this.dmanager.projectClasspathChanged(project);
                    }
                    if ((flags & 8) == 0) break;
                    if (ApiPlugin.DEBUG_WORKSPACE_DELTA_PROCESSOR) {
                        System.out.println("processed CHILDREN for package fragment root: [" + root.getElementName() + "]");
                    }
                    this.processJavaElementDeltas(delta.getAffectedChildren(), project);
                    break;
                }
                case 4: {
                    int flags;
                    IPackageFragment fragment = (IPackageFragment)delta.getElement();
                    if (delta.getKind() == 2) {
                        if (ApiPlugin.DEBUG_WORKSPACE_DELTA_PROCESSOR) {
                            System.out.println("processed REMOVED delta for package fragment: [" + fragment.getElementName() + "]");
                        }
                        ((ApiBaseline)this.bmanager.getWorkspaceBaseline()).clearPackage(fragment.getElementName());
                    }
                    if (((flags = delta.getFlags()) & 8) == 0) break;
                    if (ApiPlugin.DEBUG_WORKSPACE_DELTA_PROCESSOR) {
                        System.out.println("processed CHILDREN delta for package fragment: [" + fragment.getElementName() + "]");
                    }
                    this.processJavaElementDeltas(delta.getAffectedChildren(), project);
                    break;
                }
                case 5: {
                    int flags = delta.getFlags();
                    switch (delta.getKind()) {
                        case 4: {
                            if ((flags & 0x44001) == 0 || project == null) break block1;
                            if (ApiPlugin.DEBUG_WORKSPACE_DELTA_PROCESSOR) {
                                System.out.println("processed CONTENT / FINE_GRAINED / PRIMARY_RESOURCE delta for: [" + delta.getElement().getElementName() + "]");
                            }
                            this.dmanager.projectChanged(project);
                            this.dmanager.flushElementCache(delta.getElement());
                            break block1;
                        }
                        case 1: 
                        case 2: {
                            if (project == null) break block1;
                            if (ApiPlugin.DEBUG_WORKSPACE_DELTA_PROCESSOR) {
                                if (delta.getKind() == 1) {
                                    System.out.println("processed ADDED delta for: [" + delta.getElement().getElementName() + "]");
                                } else {
                                    System.out.println("processed REMOVED delta for: [" + delta.getElement().getElementName() + "]");
                                }
                            }
                            this.dmanager.projectChanged(project);
                            this.dmanager.flushElementCache(delta.getElement());
                            break block1;
                        }
                    }
                    break;
                }
            }
            ++i;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResource resource = event.getResource();
        block0 : switch (event.getType()) {
            case 8: {
                IResourceDelta delta;
                if (ApiPlugin.DEBUG_WORKSPACE_DELTA_PROCESSOR) {
                    if (resource == null) {
                        System.out.println("processed PRE_BUILD delta for workspace.");
                    } else {
                        System.out.println("processed PRE_BUILD delta for project: [" + resource.getName() + "]");
                    }
                }
                if ((delta = event.getDelta()) == null) break;
                IResourceDelta[] children = delta.getAffectedChildren(4);
                int i = 0;
                while (i < children.length) {
                    IProject project;
                    resource = children[i].getResource();
                    if (children[i].getResource().getType() == 4 && (Util.isApiProject(project = (IProject)resource) || Util.isJavaProject(project)) && (children[i].getFlags() & 0x80000) != 0) {
                        IJavaProject jp = (IJavaProject)JavaCore.create((IResource)resource);
                        this.dmanager.clean(jp, true, true);
                        this.bmanager.disposeWorkspaceBaseline();
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 2: 
            case 4: {
                IProject project;
                if (resource.getType() != 4 || !Util.isApiProject(project = (IProject)resource) && !Util.isJavaProject(project)) break;
                if (ApiPlugin.DEBUG_WORKSPACE_DELTA_PROCESSOR) {
                    if (event.getType() == 2) {
                        System.out.println("processed PRE_CLOSE delta for project: [" + resource.getName() + "]");
                    } else if (ApiPlugin.DEBUG_WORKSPACE_DELTA_PROCESSOR) {
                        System.out.println("processed PRE_DELETE delta for project: [" + resource.getName() + "]");
                    }
                }
                this.bmanager.disposeWorkspaceBaseline();
                IJavaProject javaProject = (IJavaProject)JavaCore.create((IResource)resource);
                this.dmanager.clean(javaProject, false, true);
                this.dmanager.flushElementCache((IJavaElement)javaProject);
                break;
            }
        }
    }
}

