/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.workspace;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.workspace.IWorkspaceFinder;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.core.RcpttPlugin;

public class WorkspaceFinder
implements IWorkspaceFinder {
    private static WorkspaceFinder instance = null;

    private WorkspaceFinder() {
    }

    public static WorkspaceFinder getInstance() {
        if (instance == null) {
            instance = new WorkspaceFinder();
        }
        return instance;
    }

    @Override
    public IContext[] findContext(IQ7NamedElement dependant, String id) {
        IQ7NamedElement[] elements = this.findNamedElements(dependant, id);
        ArrayList<IContext> result = new ArrayList<IContext>();
        IQ7NamedElement[] iQ7NamedElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7NamedElement e = iQ7NamedElementArray[n2];
            if (e instanceof IContext) {
                result.add((IContext)e);
            }
            ++n2;
        }
        if (result.size() != 0) {
            return result.toArray(new IContext[result.size()]);
        }
        return null;
    }

    @Override
    public ITestCase[] findTestcase(IQ7NamedElement dependant, String id) {
        IQ7NamedElement[] elements = this.findNamedElements(dependant, id);
        ArrayList<ITestCase> result = new ArrayList<ITestCase>();
        IQ7NamedElement[] iQ7NamedElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7NamedElement e = iQ7NamedElementArray[n2];
            if (e instanceof ITestCase) {
                result.add((ITestCase)e);
            }
            ++n2;
        }
        if (result.size() != 0) {
            return result.toArray(new ITestCase[result.size()]);
        }
        return null;
    }

    @Override
    public ITestSuite[] findTestsuites(IQ7NamedElement dependant, String id) {
        IQ7NamedElement[] elements = this.findNamedElements(dependant, id);
        ArrayList<ITestSuite> result = new ArrayList<ITestSuite>();
        IQ7NamedElement[] iQ7NamedElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7NamedElement e = iQ7NamedElementArray[n2];
            if (e instanceof ITestSuite) {
                result.add((ITestSuite)e);
            }
            ++n2;
        }
        if (result.size() != 0) {
            return result.toArray(new ITestSuite[result.size()]);
        }
        return null;
    }

    public IQ7NamedElement[] findNamedElements(IQ7NamedElement dependant, String id) {
        if (dependant == null) {
            IProject[] q7Projects;
            IProject[] iProjectArray = q7Projects = RcpttCore.getQ7Projects();
            int n = q7Projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject iProject = iProjectArray[n2];
                IQ7Project project = RcpttCore.create(iProject);
                try {
                    IQ7NamedElement[] tests = project.findNamedElement(id);
                    if (tests != null && tests.length > 0) {
                        return tests;
                    }
                }
                catch (ModelException e) {
                    RcpttPlugin.log((Throwable)((Object)e));
                }
                ++n2;
            }
            return null;
        }
        IQ7Project project = dependant.getQ7Project();
        try {
            return project.findNamedElement(id);
        }
        catch (ModelException e) {
            RcpttPlugin.log((Throwable)((Object)e));
            return null;
        }
    }

    @Override
    public IVerification[] findVerification(IQ7NamedElement dependant, String id) {
        IQ7NamedElement[] elements = this.findNamedElements(dependant, id);
        ArrayList<IVerification> result = new ArrayList<IVerification>();
        IQ7NamedElement[] iQ7NamedElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7NamedElement e = iQ7NamedElementArray[n2];
            if (e instanceof IVerification) {
                result.add((IVerification)e);
            }
            ++n2;
        }
        if (result.size() != 0) {
            return result.toArray(new IVerification[result.size()]);
        }
        return null;
    }
}

